/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.potions;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import scala.actors.threadpool.Arrays;

public class PrimalPotion
extends Potion {
    private final ResourceLocation iconTexture;
    private ItemStack[] curative_items;

    public PrimalPotion(boolean isBadEffect, int liquidColor, String name, ItemStack ... curative_items) {
        super(isBadEffect, liquidColor);
        PrimalPotion.setPotionName(this, name);
        this.iconTexture = new ResourceLocation("primal", "textures/gui/potions/" + name + ".png");
        this.curative_items = curative_items;
    }

    public PrimalPotion(boolean isBadEffect, int liquidR, int liquidG, int liquidB, String name, ItemStack ... curative_items) {
        this(isBadEffect, new Color(liquidR, liquidG, liquidB).getRGB(), name, new ItemStack[0]);
    }

    public static void setPotionName(Potion potion, String potionName) {
        potion.setRegistryName("primal", potionName);
        potion.func_76390_b("potion.effect.primal." + potionName);
    }

    public boolean func_76400_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        if (mc.field_71462_r != null) {
            mc.func_110434_K().func_110577_a(this.iconTexture);
            Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        mc.func_110434_K().func_110577_a(this.iconTexture);
        Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    public List<ItemStack> getCurativeItems() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.curative_items.length == 0) {
            ret.add(new ItemStack(Items.field_151117_aB));
        } else {
            ret.addAll(Arrays.asList((Object[])this.curative_items));
        }
        return ret;
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        PrimalAPI.logger(31, "potion effect");
    }

    public void func_180793_a(@Nullable Entity source, @Nullable Entity indirectSource, EntityLivingBase entityLivingBaseIn, int amplifier, double health) {
    }
}

