/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.projectiles;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import nmd.primal.core.common.entities.projectiles.TypeRock;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.PrimalItem;

public class Rock
extends PrimalItem {
    private Type type;

    public Rock(Type type) {
        this.field_77777_bU = ModConfig.Features.ROCK_STACKSIZE;
        this.type = type;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            int duration = this.func_77626_a(stack) - timeLeft;
            float velocity = Rock.getVelocity(duration);
            if (duration < 0) {
                return;
            }
            if ((double)velocity >= 0.5) {
                stack.func_190918_g(1);
                if (stack.func_190916_E() == 0) {
                    player.field_71071_by.func_184437_d(stack);
                }
                world.func_184148_a((EntityPlayer)null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
                if (!world.field_72995_K) {
                    TypeRock rock = new TypeRock(world, (EntityLivingBase)player);
                    rock.setType(this.type.func_176610_l());
                    rock.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity, 1.0f);
                    world.func_72838_d((Entity)rock);
                }
                player.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }

    public static float getVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return 42000;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.BOW;
    }

    public static enum Type implements IStringSerializable
    {
        STONE("stone", 0.45f, 0.5f),
        ANDESITE("andesite", 0.55f, 0.8f),
        DIORITE("diorite", 0.55f, 0.8f),
        GRANITE("granite", 0.55f, 0.8f),
        NETHERRACK("netherrack", 0.35f, 0.5f),
        END("end", 0.35f, 1.0f);

        private final String name;
        private final float drop_chance;
        private final float damage_modifier;

        private Type(String name, float drop_chance, float damage_modifier) {
            this.name = name;
            this.drop_chance = drop_chance;
            this.damage_modifier = damage_modifier;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public float getDropChance() {
            return this.drop_chance;
        }

        public float getDamgeModifier() {
            return this.damage_modifier;
        }

        public static Type byName(String name) {
            for (Type blocks$enumtype : Type.values()) {
                if (!blocks$enumtype.func_176610_l().equals(name)) continue;
                return blocks$enumtype;
            }
            return STONE;
        }
    }
}

