/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.debug;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.common.blocks.machines.Cauldron;
import nmd.primal.core.common.blocks.machines.DryingRack;
import nmd.primal.core.common.blocks.machines.Hibachi;
import nmd.primal.core.common.blocks.machines.Smelter;
import nmd.primal.core.common.items.PrimalItem;
import nmd.primal.core.common.tiles.AbstractTile;
import nmd.primal.core.common.tiles.machines.TileCauldron;
import nmd.primal.core.common.tiles.machines.TileDryingRack;
import nmd.primal.core.common.tiles.machines.TileHibachi;
import nmd.primal.core.common.tiles.machines.TileSmelter;

public class DirtStick
extends PrimalItem {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.debug_item"));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!world.field_72995_K) {
            AbstractTile tile;
            if (block instanceof ISchedule && !this.getSchedule(world, pos, state, player)) {
                IBlockState up_state = world.func_180495_p(pos.func_177984_a());
                this.getSchedule(world, pos, up_state, player);
            }
            if (block instanceof DryingRack) {
                tile = (TileDryingRack)((DryingRack)block).getTileEntity((IBlockAccess)world, pos);
                if (tile != null) {
                    for (int counter : ((TileDryingRack)tile).getSlotCounters()) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a79\u00a7oDrying Rack counter: " + counter, new Object[0]));
                    }
                }
            } else if (block instanceof Hibachi) {
                tile = (TileHibachi)((Hibachi)block).getTileEntity((IBlockAccess)world, pos);
                if (tile != null) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a79\u00a7oHibachi fuel time: " + ((TileHibachi)tile).getFuelTime() + ", amount: " + ((TileHibachi)tile).getFuelHandler().getStackInSlot(0).func_190916_E(), new Object[0]));
                    for (int counter : ((TileHibachi)tile).getSlotCounters()) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a79\u00a7oHibachi counter: " + counter, new Object[0]));
                    }
                }
            } else if (block instanceof Smelter) {
                tile = (TileSmelter)((Smelter)block).getTileEntity((IBlockAccess)world, pos);
                if (tile != null) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + "Smelter counter: " + ((TileSmelter)tile).getCounter(), new Object[0]));
                }
            } else if (block instanceof Cauldron && (tile = (TileCauldron)((Cauldron)block).getTileEntity((IBlockAccess)world, pos)) != null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + "Cauldron counter: " + ((TileCauldron)tile).getCounter(), new Object[0]));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean getSchedule(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        Block block = state.func_177230_c();
        if (block instanceof ISchedule) {
            if (!world.func_184145_b(pos, block)) {
                if (((ISchedule)block).shouldSchedule(world, pos, state)) {
                    PrimalAPI.scheduleBlock(world, pos, state);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + I18n.func_74838_a((String)"chat.message.debug.primal.schedule_update_restart"), new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + I18n.func_74838_a((String)"chat.message.debug.primal.schedule_update_failed"), new Object[0]));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + I18n.func_74838_a((String)"chat.message.debug.primal.schedule_update_in_progress"), new Object[0]));
            }
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.YELLOW + I18n.func_74838_a((String)"chat.message.debug.primal.schedule_not_updatable"), new Object[0]));
        return false;
    }
}

