/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.IFireProof;
import nmd.primal.core.common.init.ModInfo;

public abstract class AbstractItemBlock
extends ItemBlock
implements IFireProof<AbstractItemBlock> {
    private boolean is_fire_proof;

    public AbstractItemBlock(Block block, boolean sub_types) {
        super(block);
        this.func_77627_a(sub_types);
        if (this.is_fire_proof) {
            Blocks.field_150480_ab.func_180686_a(this.func_179223_d(), 0, 0);
        }
    }

    public AbstractItemBlock(Block block) {
        this(block, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        if (this.isFireProof(stack)) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.abstract_fire_proof"));
        }
    }

    public CreativeTabs func_77640_w() {
        return ModInfo.TAB_PRIMAL;
    }

    public String func_77667_c(ItemStack stack) {
        return this.field_150939_a.func_149739_a();
    }

    public String func_77658_a() {
        return this.field_150939_a.func_149739_a();
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 6000;
    }

    public boolean isFireProof(ItemStack stack) {
        return this.is_fire_proof;
    }

    @Override
    public AbstractItemBlock setFireProof(boolean is_fire_proof) {
        this.is_fire_proof = is_fire_proof;
        return this;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.is_fire_proof || this.isFireProof(stack);
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        return this.getEntity(world, location, stack);
    }
}

