/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.init;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.TileFixer;

@Mod.EventBusSubscriber(modid="primal")
public final class ModRemapper {
    private static final Map<String, String> REMAPPED_BLOCKS = new HashMap<String, String>();
    private static final Map<String, String> REMAPPED_ITEMS = new HashMap<String, String>();

    @SubscribeEvent
    public static void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            ResourceLocation resource = missing.key;
            String domain = resource.func_110624_b();
            String path = resource.func_110623_a();
            if (!domain.equals("primal")) continue;
            if (REMAPPED_BLOCKS.containsKey(path)) {
                String new_name = REMAPPED_BLOCKS.remove(path);
                Block new_mapping = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(domain, new_name));
                if (new_mapping != null && new_mapping != Blocks.field_150350_a) {
                    PrimalCore.LOGGER.info("re-mapping: " + path + " to " + new_name + "(" + new_mapping + ")");
                    missing.remap((IForgeRegistryEntry)new_mapping);
                    continue;
                }
                PrimalCore.LOGGER.info("re-mapping failed: " + path + " to " + new_name + "(" + new_mapping + ")");
                missing.warn();
                continue;
            }
            missing.warn();
        }
    }

    @SubscribeEvent
    public static void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            ResourceLocation resource = missing.key;
            String domain = resource.func_110624_b();
            String path = resource.func_110623_a();
            if (!domain.equals("primal")) continue;
            if (REMAPPED_ITEMS.containsKey(path)) {
                String new_name = REMAPPED_ITEMS.remove(path);
                Item new_mapping = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(domain, new_name));
                if (new_mapping != null && new_mapping != Items.field_190931_a) {
                    PrimalCore.LOGGER.info("re-mapping: " + path + " to " + new_name + "(" + new_mapping + ")");
                    missing.remap((IForgeRegistryEntry)new_mapping);
                    continue;
                }
                PrimalCore.LOGGER.info("re-mapping failed: " + path + " to " + new_name + "(" + new_mapping + ")");
                missing.warn();
                continue;
            }
            missing.warn();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void remapTiles(RegistryEvent.Register<Block> event) {
        ModFixs fix = FMLCommonHandler.instance().getDataFixer().init("primal", 1);
        HashMap<String, String> oldTileRemap = new HashMap<String, String>();
        oldTileRemap.put("tile.primal.storage_crate", "primal:tile.storage_crate");
        oldTileRemap.put("minecraft:tile.primal.storage_crate", "primal:tile.storage_crate");
        oldTileRemap.put("tile.primal.worktable_shelf", "primal:tile.worktable_shelf");
        oldTileRemap.put("minecraft:tile.primal.worktable_shelf", "primal:tile.worktable_shelf");
        oldTileRemap.put("tile.primal.worktable_slab", "primal:tile.worktable_slab");
        oldTileRemap.put("minecraft:tile.primal.worktable_slab", "primal:tile.worktable_slab");
        oldTileRemap.put("tile.primal.shelf", "primal:tile.shelf");
        oldTileRemap.put("minecraft:tile.primal.shelf", "primal:tile.shelf");
        oldTileRemap.put("tile.primal.drying_rack", "primal:tile.drying_rack");
        oldTileRemap.put("minecraft:tile.primal.drying_rack", "primal:tile.drying_rack");
        oldTileRemap.put("tile.primal.fish_trap", "primal:tile.fish_trap");
        oldTileRemap.put("minecraft:tile.primal.fish_trap", "primal:tile.fish_trap");
        oldTileRemap.put("tile.primal.hibachi", "primal:tile.hibachi");
        oldTileRemap.put("minecraft:tile.primal.hibachi", "primal:tile.hibachi");
        oldTileRemap.put("tile.primal.smelter", "primal:tile.smelter");
        oldTileRemap.put("minecraft:tile.primal.smelter", "primal:tile.smelter");
        oldTileRemap.put("tile.primal.cauldron", "primal:tile.cauldron");
        oldTileRemap.put("minecraft:tile.primal.cauldron", "primal:tile.cauldron");
        oldTileRemap.put("tile.primal.barrel", "primal:tile.barrel");
        oldTileRemap.put("minecraft:tile.primal.barrel", "primal:tile.barrel");
        oldTileRemap.put("tile.primal.brick_mold", "primal:tile.brick_mold");
        oldTileRemap.put("minecraft:tile.primal.brick_mold", "primal:tile.brick_mold");
        oldTileRemap.put("tile.primal.firepit", "primal:tile.firepit");
        oldTileRemap.put("minecraft:tile.primal.firepit", "primal:tile.firepit");
        oldTileRemap.put("tile.primal.brickform", "primal:tile.brickform");
        oldTileRemap.put("minecraft:tile.primal.brickform", "primal:tile.brickform");
        oldTileRemap.put("tile.primal.kiln", "primal:tile.kiln");
        oldTileRemap.put("minecraft:tile.primal.kiln", "primal:tile.kiln");
        fix.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileFixer(oldTileRemap, 1));
    }

    static {
        PrimalCore.LOGGER.info("Re-mapper Rick!");
        REMAPPED_BLOCKS.put("magma", "magma_basaltic");
        REMAPPED_BLOCKS.put("ovis_wool", "ovis_atre_wool");
        REMAPPED_BLOCKS.put("terraclay_block", "terra_block");
        REMAPPED_BLOCKS.put("cinisclay_block", "cinis_block");
        REMAPPED_BLOCKS.put("adobebrick", "adobe_brick");
        REMAPPED_BLOCKS.put("earthwax_block", "calcified_paraffin");
        REMAPPED_ITEMS.put("rush_tips", "rush_stems");
        REMAPPED_ITEMS.put("rush_tips_bloom", "rush_stems");
        REMAPPED_ITEMS.put("cauldron_slag", "slag");
        REMAPPED_ITEMS.put("tamahagane_clump", "tamahagane_bloom");
        REMAPPED_ITEMS.put("sinuous_spores", "sinuous_spore");
        REMAPPED_ITEMS.put("pigiron_plate", "crude_iron_plate");
        REMAPPED_ITEMS.put("pigiron_dust", "crude_iron_dust");
        REMAPPED_ITEMS.put("pigiron_ingot", "crude_iron_ingot");
        REMAPPED_ITEMS.put("pigiron_nugget", "crude_iron_nugget");
        REMAPPED_ITEMS.put("bear_fat", "animal_fat");
        REMAPPED_ITEMS.put("lard", "animal_fat");
        REMAPPED_ITEMS.put("suet", "animal_fat");
        REMAPPED_ITEMS.put("terraclay_clump", "terra_clump");
        REMAPPED_ITEMS.put("cinisclay_clump", "cinis_clump");
        REMAPPED_ITEMS.put("terracotta_brick", "terra_brick_dry");
        REMAPPED_ITEMS.put("ciniscotta_brick", "cinis_brick_dry");
        REMAPPED_ITEMS.put("adobebrick_wet", "adobe_brick_wet");
        REMAPPED_ITEMS.put("adobebrick_dry", "adobe_brick_dry");
        REMAPPED_ITEMS.put("adobebrick_mix", "adobe_clump");
        REMAPPED_ITEMS.put("nickle_nugget", "nickel_nugget");
        REMAPPED_ITEMS.put("nickle_dust", "nickel_dust");
        REMAPPED_ITEMS.put("nickle_ingot", "nickel_ingot");
        REMAPPED_ITEMS.put("nickle_plate", "nickel_plate");
        REMAPPED_ITEMS.put("earthwax_clump", "paraffin_clump");
        REMAPPED_ITEMS.put("magnetite", "ore_cluster_magnetite");
        REMAPPED_ITEMS.put("bog_iron", "ore_cluster_bog_iron");
    }
}

