/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.init;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.fluids.BasicFluidBlock;
import nmd.primal.core.common.fluids.Bitumen;
import nmd.primal.core.common.fluids.Magma;
import nmd.primal.core.common.fluids.OvisAtreMilk;
import nmd.primal.core.common.fluids.Paraffin;
import nmd.primal.core.common.fluids.gas.Smoke;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.helper.checks.ItemMultiplexer;
import nmd.primal.core.common.init.ModConfig;

public final class ModFluids {
    public static final Set<IFluidBlock> FLUID_BLOCKS = new HashSet<IFluidBlock>();
    public static final Predicate<ItemStack> VANILLA_BUCKETS = ItemMultiplexer.forItem(Items.field_151131_as, Items.field_151129_at);
    public static final FluidStack VANILLA_BUCKET_WATER = new FluidStack(FluidRegistry.WATER, 1000);
    public static final FluidStack VANILLA_BUCKET_LAVA = new FluidStack(FluidRegistry.LAVA, 1000);
    private static List<ItemStack> FLUID_SPONGES;

    public static void init() {
        FLUID_SPONGES = CommonUtils.getStackList(ModConfig.Machines.FLUID_SPONGE_ITEMS);
    }

    private static <T extends Block> Fluid createFluid(String name, int color, boolean hasFlowIcon, Consumer<Fluid> fluidPropertyApplier, Function<Fluid, T> blockFactory) {
        return RegistryHelper.createFluid(name, "primal", FLUID_BLOCKS, color, hasFlowIcon, fluidPropertyApplier, blockFactory);
    }

    public static FluidStack getVanillaBucketStack(Item bucket) {
        return bucket == Items.field_151131_as ? VANILLA_BUCKET_WATER : (bucket == Items.field_151129_at ? VANILLA_BUCKET_LAVA : null);
    }

    public static ItemStack getVanillaEmpty() {
        return new ItemStack(Items.field_151133_ar);
    }

    public static ItemStack getFilledBucket(UniversalBucket bucket, @Nonnull FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (FluidRegistry.getBucketFluids().contains(fluid) || fluid == FluidRegistry.WATER || fluid == FluidRegistry.LAVA) {
            ItemStack bucket_filled = new ItemStack((Item)bucket);
            FluidStack bucket_fluid = new FluidStack(fluidStack, bucket.getCapacity());
            IFluidHandlerItem handler = (IFluidHandlerItem)bucket_filled.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (handler != null && handler.fill(bucket_fluid, true) == bucket_fluid.amount) {
                return handler.getContainer();
            }
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> getSponges() {
        return FLUID_SPONGES;
    }

    public static boolean isSponge(ItemStack match) {
        return CommonUtils.matchItemList(FLUID_SPONGES, match);
    }

    @Mod.EventBusSubscriber(modid="primal")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registryFluidBlocks(RegistryEvent.Register<Block> event) {
            PrimalAPI.logger(1, "Registering Fluid Blocks");
            IForgeRegistry registry = event.getRegistry();
            PrimalAPI.Fluids.TANNIN = ModFluids.createFluid("tannin", -4221440, true, fluid -> fluid.setDensity(2000).setViscosity(2000), fluid -> new BasicFluidBlock((Fluid)fluid, Material.field_151586_h));
            RegistryHelper.registerFluidBlock((IForgeRegistry<Block>)registry, PrimalAPI.Fluids.TANNIN);
            PrimalAPI.Fluids.URUSHI = ModFluids.createFluid("urushi", -7508353, true, fluid -> fluid.setDensity(2000).setViscosity(2000), fluid -> new BasicFluidBlock((Fluid)fluid, Material.field_151586_h));
            RegistryHelper.registerFluidBlock((IForgeRegistry<Block>)registry, PrimalAPI.Fluids.URUSHI);
            PrimalAPI.Fluids.BRINE = ModFluids.createFluid("brine_netjry", -7763598, true, fluid -> fluid.setDensity(1000).setViscosity(1000), fluid -> new BasicFluidBlock((Fluid)fluid, Material.field_151586_h));
            RegistryHelper.registerFluidBlock((IForgeRegistry<Block>)registry, PrimalAPI.Fluids.BRINE);
            PrimalAPI.Fluids.WASTE = ModFluids.createFluid("waste", -7763598, true, fluid -> fluid.setDensity(1000).setViscosity(1000), fluid -> new BasicFluidBlock((Fluid)fluid, Material.field_151586_h));
            RegistryHelper.registerFluidBlock((IForgeRegistry<Block>)registry, PrimalAPI.Fluids.WASTE);
            PrimalAPI.Fluids.BITUMEN = Bitumen.createFluid("bitumen", -1523405, fluid -> fluid.setDensity(1600).setViscosity(3000).setTemperature(400), fluid -> new Bitumen((Fluid)fluid).setBoiling(false));
            RegistryHelper.registerFluidBlock((IForgeRegistry<Block>)registry, PrimalAPI.Fluids.BITUMEN);
            PrimalAPI.Fluids.BITUMEN_BOILING = Bitumen.createFluid("bitumen_boiling", -1523405, fluid -> fluid.setDensity(1600).setViscosity(3000).setTemperature(800), fluid -> new Bitumen((Fluid)fluid).setBoiling(true));
            RegistryHelper.registerFluidBlock((IForgeRegistry<Block>)registry, PrimalAPI.Fluids.BITUMEN_BOILING);
            PrimalAPI.Fluids.PARAFFIN = Paraffin.createFluid("paraffin", -5396656, fluid -> fluid.setDensity(800).setViscosity(1600), fluid -> new Paraffin((Fluid)fluid));
            RegistryHelper.registerFluidBlock((IForgeRegistry<Block>)registry, PrimalAPI.Fluids.PARAFFIN);
            PrimalAPI.Fluids.MAGMA = ModFluids.createFluid("magma_basaltic", -1, true, fluid -> fluid.setDensity(3200).setViscosity(6000).setTemperature(1600).setLuminosity(12), fluid -> new Magma((Fluid)fluid, Material.field_151587_i));
            RegistryHelper.registerFluidBlock((IForgeRegistry<Block>)registry, PrimalAPI.Fluids.MAGMA);
            PrimalAPI.Fluids.OVIS_ATRE_MILK = ModFluids.createFluid("ovis_atre_milk", -262022, true, fluid -> fluid.setDensity(1200).setViscosity(1600).setTemperature(600).setLuminosity(6), fluid -> new OvisAtreMilk((Fluid)fluid, Material.field_151587_i));
            RegistryHelper.registerFluidBlock((IForgeRegistry<Block>)registry, PrimalAPI.Fluids.OVIS_ATRE_MILK);
            PrimalAPI.Fluids.SMOKE = ModFluids.createFluid("smoke", 0, false, fluid -> fluid.setDensity(-1000).setViscosity(200).setTemperature(600).setGaseous(true), fluid -> new Smoke((Fluid)fluid, (Material)PrimalAPI.BlockMaterials.SMOKE));
            RegistryHelper.registerFluidBlock((IForgeRegistry<Block>)registry, PrimalAPI.Fluids.SMOKE);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registryFluidItems(RegistryEvent.Register<Item> event) {
            PrimalAPI.logger(1, "Registering Fluid Items");
            IForgeRegistry registry = event.getRegistry();
            RegistryHelper.registerFluidItems((IForgeRegistry<Item>)registry, FLUID_BLOCKS);
        }
    }
}

