/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.fluids.custom.PrimalFluid;
import nmd.primal.core.common.init.ModInfo;

public class RegistryHelper {
    private static int ENTITY_ID = 0;

    public static String formatUnlocalizedName(String mod, String name) {
        return mod + "." + name;
    }

    public static String formatUnlocalizedName(String name) {
        return RegistryHelper.formatUnlocalizedName("primal", name);
    }

    public static String formatRecipeName(String name) {
        return name.replace(".", "_").toLowerCase();
    }

    public static <BLOCK extends Block> BLOCK addBlock(String name, BLOCK block, @Nullable Function<BLOCK, ItemBlock> itemFactory, String ... dictionary_names) {
        block.setRegistryName(name);
        block.func_149663_c(RegistryHelper.formatUnlocalizedName(name));
        block.func_149647_a(ModInfo.TAB_PRIMAL);
        if (block instanceof IDictionaryName) {
            ((IDictionaryName)block).setDictionaryNames(dictionary_names);
        }
        PrimalCore.BLOCKS.add(block);
        PrimalCore.ITEM_BLOCKS.add((Object)(itemFactory != null ? itemFactory.apply(block) : (ItemBlock)Item.func_150898_a(block)));
        return block;
    }

    public static <BLOCK extends Block> BLOCK addBlock(String name, BLOCK block, String ... dictionary_names) {
        return (BLOCK)RegistryHelper.addBlock(name, block, ItemBlock::new, dictionary_names);
    }

    public static void registerTileEntity(Class<? extends TileEntity> tile_class, String baseName) {
        GameRegistry.registerTileEntity(tile_class, (String)("primal:tile." + baseName));
    }

    public static <ITEM extends Item> ITEM addItem(String name, ITEM item, CreativeTabs tab, String ... dictionary_names) {
        item.setRegistryName(name);
        item.func_77655_b(RegistryHelper.formatUnlocalizedName(name));
        item.func_77637_a(tab);
        if (item instanceof IDictionaryName) {
            ((IDictionaryName)item).setDictionaryNames(dictionary_names);
        }
        PrimalCore.ITEMS.add(item);
        return item;
    }

    public static void registerFluidBlock(IForgeRegistry<Block> registry, Fluid fluid) {
        Block block = fluid.getBlock();
        block.setRegistryName(fluid.getName());
        block.func_149663_c(RegistryHelper.formatUnlocalizedName(fluid.getUnlocalizedName()));
        registry.register((IForgeRegistryEntry)block);
    }

    public static void registerFluidItems(IForgeRegistry<Item> registry, Set<IFluidBlock> list) {
        for (IFluidBlock fluidBlock : list) {
            Block block = (Block)fluidBlock;
            ItemBlock itemBlock = new ItemBlock(block);
            ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName());
            itemBlock.setRegistryName(registryName);
            registry.register((IForgeRegistryEntry)itemBlock);
            FluidRegistry.addBucketForFluid((Fluid)fluidBlock.getFluid());
        }
    }

    public static <T extends Block> Fluid createFluid(String name, String mod, Set<IFluidBlock> list, int color, boolean hasFlowIcon, Consumer<Fluid> fluidPropertyApplier, Function<Fluid, T> blockFactory) {
        PrimalFluid fluid = new PrimalFluid(name, mod, color);
        if (FluidRegistry.registerFluid((Fluid)fluid)) {
            fluidPropertyApplier.accept(fluid);
            list.add((IFluidBlock)blockFactory.apply(fluid));
        } else {
            fluid = FluidRegistry.getFluid((String)name);
        }
        return fluid;
    }

    public static SoundEvent addSound(String name, String mod) {
        ResourceLocation location = new ResourceLocation(mod, name);
        SoundEvent sound = new SoundEvent(location);
        sound.setRegistryName(location);
        return sound;
    }

    public static <E extends Entity> EntityEntryBuilder<E> createEntity(String name, String mod) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        ResourceLocation registryName = new ResourceLocation(mod, name);
        return builder.id(registryName, ENTITY_ID++).name(registryName.toString()).tracker(64, 1, true);
    }

    public static void copySpawns(Class<? extends EntityLiving> entityClass, EnumCreatureType entityType, Class<? extends EntityLiving> classToCopy, EnumCreatureType creatureTypeToCopy) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            biome.func_76747_a(creatureTypeToCopy).stream().filter(entry -> entry.field_76300_b == classToCopy).findFirst().ifPresent(spawnListEntry -> biome.func_76747_a(entityType).add(new Biome.SpawnListEntry(entityClass, spawnListEntry.field_76292_a, spawnListEntry.field_76301_c, spawnListEntry.field_76299_d)));
        }
    }

    public static void addSpawn(Class<? extends EntityLiving> entityClass, EnumCreatureType entityType, int spawnWeight, int min, int max, Biome ... biomes) {
        if (spawnWeight > 0) {
            EntityRegistry.addSpawn(entityClass, (int)spawnWeight, (int)min, (int)max, (EnumCreatureType)entityType, (Biome[])biomes);
        }
    }

    public static void registerDictionaryNames(String dictionary_name, ItemStack ... stacks) {
        if (dictionary_name != null && !dictionary_name.isEmpty()) {
            for (ItemStack stack : stacks) {
                if (stack.func_190926_b()) continue;
                PrimalAPI.logger(2, "ore dict", "REGISTRY_NAME: " + dictionary_name + ", stack: " + stack);
                OreDictionary.registerOre((String)dictionary_name, (ItemStack)stack);
            }
        }
    }

    public static void registerDictionaryNames(ItemStack stack, String ... dictionary_names) {
        if (dictionary_names != null && dictionary_names.length > 0 && !stack.func_190926_b()) {
            for (String dictionary_name : dictionary_names) {
                if (dictionary_name.isEmpty()) continue;
                PrimalAPI.logger(2, "ore dict", "REGISTRY_NAME: " + dictionary_name + ", stack: " + stack);
                OreDictionary.registerOre((String)dictionary_name, (ItemStack)stack);
            }
        }
    }

    public static void registerDictionaryNames(@Nullable Item item, String ... dictionary_names) {
        if (item != null) {
            RegistryHelper.registerDictionaryNames(new ItemStack(item), dictionary_names);
        }
    }

    public static void registerDictionaryNames(@Nullable Block block, String ... dictionary_names) {
        if (block != null) {
            RegistryHelper.registerDictionaryNames(new ItemStack(block), dictionary_names);
        }
    }

    public static void registerNameToName(String newName, String oldName) {
        NonNullList list = OreDictionary.getOres((String)oldName);
        for (ItemStack stack : list) {
            OreDictionary.registerOre((String)newName, (ItemStack)stack);
        }
    }
}

