/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.AbstractTank;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.helper.checks.MaterialMultiplexer;
import nmd.primal.core.common.init.ModCompat;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.tiles.AbstractTileTank;

public class BlockHelper {
    public static void preInit() {
    }

    public static void init() {
    }

    public static void postInit() {
        PrimalAPI.Predicates.STABILIZING_BLOCKS = BlockMultiplexer.forBlock(PrimalAPI.Blocks.SOUL_GLASS, PrimalAPI.Blocks.SOUL_STONE, PrimalAPI.Blocks.NETHER_STONE, PrimalAPI.Blocks.DESICCATED_STONE, PrimalAPI.Blocks.NIGHT_STONE);
        PrimalAPI.Predicates.INSULATING_BLOCKS = BlockMultiplexer.forBlock(PrimalAPI.Blocks.LOGS_STACKED, PrimalAPI.Blocks.LOGS_STACKED_CORYPHA, PrimalAPI.Blocks.CHARCOAL_STACK, PrimalAPI.Blocks.MUD_DRIED, PrimalAPI.Blocks.TERRACOTTA_BLOCK, PrimalAPI.Blocks.CINISCOTTA_BLOCK, PrimalAPI.Blocks.FERRO_STONE, PrimalAPI.Blocks.ADOBE_BRICK, PrimalAPI.Blocks.IRON_GLASS, Blocks.field_150385_bj);
        PrimalAPI.Predicates.SPREAD_INTERDICTION = BlockMultiplexer.forBlock(PrimalAPI.Blocks.NETHER_FARMLAND, PrimalAPI.Blocks.NIGHT_STONE, ModCompat.NEX_TILLED_SOUL_SAND);
        PrimalAPI.Predicates.SPREAD_RESISTANT = BlockMultiplexer.forBlock(PrimalAPI.Blocks.NIGHT_STONE, PrimalAPI.Blocks.CINISCOTTA_BLOCK, PrimalAPI.Blocks.SOUL_STONE);
        PrimalAPI.Predicates.SPREAD_NETHER_GROWTH = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150354_m, Blocks.field_150348_b, Blocks.field_150347_e});
        PrimalAPI.Predicates.SPREAD_NETHER_MYCELIUM = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150424_aL, PrimalAPI.Blocks.DESICCATED_STONE, ModCompat.NEX_NETHERRACK});
        PrimalAPI.Predicates.SPREAD_STONE_DESICCATED = BlockMultiplexer.forBlock(Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_150424_aL, PrimalAPI.Blocks.DESICCATED_STONE, ModCompat.NEX_NETHERRACK);
        PrimalAPI.Predicates.SPREAD_MUD = BlockMultiplexer.forBlock(Blocks.field_150346_d);
        PrimalAPI.Predicates.SOIL_NETHER_FARMING = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150391_bh, PrimalAPI.Blocks.NETHER_FARMLAND, PrimalAPI.Blocks.NETHER_MYCELIUM, PrimalAPI.Blocks.NETHER_GROWTH, ModCompat.NEX_TILLED_SOUL_SAND});
        PrimalAPI.Predicates.SOIL_NETHER_COMMON = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150424_aL, Blocks.field_150425_aM, Blocks.field_150426_aN, Blocks.field_150351_n, Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150391_bh, PrimalAPI.Blocks.NETHER_EARTH, PrimalAPI.Blocks.NETHER_FARMLAND, PrimalAPI.Blocks.NETHER_MYCELIUM, PrimalAPI.Blocks.NETHER_GROWTH, PrimalAPI.Blocks.DESICCATED_STONE, PrimalAPI.Blocks.CINIS_BLOCK, PrimalAPI.Blocks.CALCIFIED_PARAFFIN, PrimalAPI.Blocks.SATETSU, PrimalAPI.Blocks.MUD_DRIED, PrimalAPI.Blocks.ORE_SALT, PrimalAPI.Blocks.ORE_SALT_FLAT, ModCompat.NEX_TILLED_SOUL_SAND, ModCompat.NEX_NETHERRACK});
        PrimalAPI.Predicates.SOIL_SURFACE_COMMON = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150391_bh, PrimalAPI.Blocks.NETHER_EARTH, PrimalAPI.Blocks.NETHER_FARMLAND, PrimalAPI.Blocks.LOAM_BLOCK, PrimalAPI.Blocks.MUD_WET, PrimalAPI.Blocks.MUD_DRIED, PrimalAPI.Blocks.TERRA_BLOCK, PrimalAPI.Blocks.CINIS_BLOCK, PrimalAPI.Blocks.SATETSU});
        PrimalAPI.Predicates.SOIL_DIRT = BlockMultiplexer.forBlock(new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, PrimalAPI.Blocks.NETHER_EARTH, PrimalAPI.Blocks.NETHER_FARMLAND, PrimalAPI.Blocks.MUD_WET});
        for (Block block : CommonUtils.getBlockList(ModConfig.Flammability.FIRE_SOURCE_BLOCKS)) {
            PrimalAPI.logger(15, "adding fire sources", block.func_149739_a());
            FireHelper.FIRE_SOURCE_BLOCKS.add(block);
        }
        for (Block block : CommonUtils.getBlockList(ModConfig.Flammability.HEAT_SOURCE_BLOCKS)) {
            PrimalAPI.logger(15, "adding heat sources", block.func_149739_a());
            FireHelper.HEAT_SOURCE_BLOCKS.add(block);
        }
        PrimalAPI.Predicates.SOFT_FALL_BLOCKS = BlockHelper.getBlockPredicate(ModConfig.Features.LANDING_BLOCKS_SAFE);
        PrimalAPI.Predicates.FURNACE = BlockMultiplexer.forBlock(Blocks.field_150460_al, Blocks.field_150470_am);
        PrimalAPI.Predicates.LOOTING_2_BLOCKS = BlockMultiplexer.forBlock(Blocks.field_150451_bX, Blocks.field_150368_y, Blocks.field_150371_ca);
        PrimalAPI.Predicates.LOOTING_3_BLOCKS = BlockMultiplexer.forBlock(Blocks.field_150484_ah, Blocks.field_150475_bE, Blocks.field_150340_R);
        PrimalAPI.Predicates.FIRE_HEAT_SOURCE_MATERIALS.add(Material.field_151581_o);
        PrimalAPI.Predicates.FIRE_HEAT_SOURCE_MATERIALS.add(Material.field_151587_i);
        PrimalAPI.Predicates.DESPAWN_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.SOUL_GLASS);
        PrimalAPI.Predicates.DESPAWN_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.SLAB_SOUL_GLASS);
        PrimalAPI.Predicates.DESPAWN_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.THIN_SLAB_SOULGLASS);
        if (ModConfig.Plants.CINERIS_CARPET_PREVENTS_DESPAWN) {
            PrimalAPI.Predicates.DESPAWN_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.THATCH_CINERIS);
            PrimalAPI.Predicates.DESPAWN_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.CARPET_CINERIS);
        }
        PrimalAPI.Predicates.TELEPORT_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.NIGHT_STONE);
        PrimalAPI.Predicates.TELEPORT_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.STAIRS_NIGHT_STONE);
        PrimalAPI.Predicates.TELEPORT_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.SOUL_STONE);
        PrimalAPI.Predicates.TELEPORT_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.SOUL_GLASS);
        PrimalAPI.Predicates.TELEPORT_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.SLAB_SOUL_GLASS);
        PrimalAPI.Predicates.TELEPORT_INTERDICTION_BLOCKS.add(PrimalAPI.Blocks.THIN_SLAB_SOULGLASS);
        PrimalAPI.Predicates.COOLING_SOURCE = MaterialMultiplexer.forMaterial(Material.field_151586_h, Material.field_151588_w, Material.field_151598_x, Material.field_151597_y, Material.field_151596_z);
        PrimalAPI.Predicates.FIRE_HEAT_SOURCE = MaterialMultiplexer.forMaterial(PrimalAPI.Predicates.FIRE_HEAT_SOURCE_MATERIALS);
        PrimalAPI.Predicates.TELEPORT_INTERDICTION = BlockMultiplexer.forBlock(PrimalAPI.Predicates.TELEPORT_INTERDICTION_BLOCKS);
        PrimalAPI.Predicates.DESPAWN_INTERDICTION = BlockMultiplexer.forBlock(PrimalAPI.Predicates.DESPAWN_INTERDICTION_BLOCKS);
        PrimalAPI.Predicates.FIRE_HEAT_SOURCE_MATERIALS.clear();
        PrimalAPI.Predicates.TELEPORT_INTERDICTION_BLOCKS.clear();
        PrimalAPI.Predicates.DESPAWN_INTERDICTION_BLOCKS.clear();
    }

    public static boolean hasStabilizingBlock(IBlockAccess world, BlockPos pos, EnumFacing ... facings) {
        for (EnumFacing facing : facings) {
            if (!PrimalAPI.Predicates.STABILIZING_BLOCKS.apply((Object)world.func_180495_p(pos.func_177972_a(facing)))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSafeFallBlock(ArrayList<IBlockState> states) {
        for (IBlockState state : states) {
            if (MaterialMultiplexer.forMaterial(Material.field_151584_j, Material.field_151597_y, Material.field_151579_a).apply(state) || PrimalAPI.Predicates.SOFT_FALL_BLOCKS.apply((Object)state)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFireSource(IBlockAccess world, BlockPos pos, IBlockState state, List<Block> blocks) {
        Block block;
        FluidStack fluidStack;
        AbstractTileTank tile;
        if (state.func_185904_a() == Material.field_151587_i || state.func_185904_a() == Material.field_151581_o) {
            return true;
        }
        for (Block block2 : blocks) {
            if (block2 != state.func_177230_c()) continue;
            return true;
        }
        if (state.func_177230_c() instanceof AbstractTank && (tile = (AbstractTileTank)world.func_175625_s(pos)) != null && !tile.func_145837_r() && !tile.isCovered() && (fluidStack = tile.getContainedFluid()) != null && fluidStack.amount >= 250 && (block = fluidStack.getFluid().getBlock()) != null) {
            return block.func_176223_P().func_185904_a() == Material.field_151587_i;
        }
        return false;
    }

    public static Predicate<IBlockState> getBlockPredicate(String[] block_names) {
        ArrayList<Block> list = new ArrayList<Block>();
        for (String name : block_names) {
            Block block;
            if (name == null || name.isEmpty() || (block = Block.func_149684_b((String)name)) == null) continue;
            list.add(block);
        }
        return BlockMultiplexer.forBlock(list);
    }
}

