/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.events;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.plants.IInvasive;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.plants.thatch.CarpetCineris;
import nmd.primal.core.common.blocks.plants.thatch.ThatchNether;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.init.ModPlants;

@Mod.EventBusSubscriber
public final class ItemEvents {
    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=false)
    public static void onItemExpire(ItemExpireEvent event) {
        if (event.getEntityItem().func_92059_d().func_190926_b()) {
            return;
        }
        EntityItem entity = event.getEntityItem();
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_180425_c();
        ItemStack stack = entity.func_92059_d();
        Item item = stack.func_77973_b();
        for (int i = 0; i <= 2; ++i) {
            IBlockState state = world.func_180495_p(pos.func_177979_c(i));
            if (!PrimalAPI.Predicates.DESPAWN_INTERDICTION.apply((Object)state)) continue;
            if (state.func_177230_c() == PrimalAPI.Blocks.SOUL_GLASS && stack.func_77973_b() == Items.field_151110_aK) {
                for (int j = 0; j < stack.func_190916_E(); ++j) {
                    CommonUtils.spawnChicken(world, pos);
                }
                entity.func_70106_y();
                return;
            }
            event.setCanceled(true);
            return;
        }
        if (PrimalAPI.randomCheck(ModConfig.Plants.PLANT_AUTO_MAGIC_CHANCE) && !CommonUtils.matchItemList(ModConfig.Plants.PLANT_AUTO_MAGIC_BLACKLIST, stack)) {
            IBlockState plant_state = ModPlants.getPlantState(world, pos, stack);
            if (plant_state != null) {
                Block plant = plant_state.func_177230_c();
                Block ground = world.func_180495_p(pos.func_177977_b()).func_177230_c();
                if ((plant instanceof IInvasive && ((IInvasive)plant).canSpreadTo(world, pos, pos) || plant instanceof IPlantable && !world.func_180495_p(pos).func_185904_a().func_76224_d() && ground.canSustainPlant(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)plant) && plant.func_176196_c(world, pos)) && world.func_180501_a(pos, plant_state, 2)) {
                    PrimalAPI.logger(5, "schedule", "@" + pos + ", EntityEvents#PLANT_AUTO_MAGICALLY");
                    PrimalAPI.scheduleBlock(world, pos, plant_state);
                }
            }
        } else if (item instanceof UniversalBucket) {
            FluidStack fluidStack = ((UniversalBucket)item).getFluid(stack);
            if (fluidStack != null && fluidStack.getFluid() == PrimalAPI.Fluids.PARAFFIN) {
                FireHelper.explode(world, pos, (Entity)entity, PrimalCore.RANDOM.nextInt(3, 7), 1.0f, true, true);
            }
        } else if (item == PrimalAPI.Items.BOTTLE_PARAFFIN) {
            FireHelper.explode(world, pos, (Entity)entity, PrimalCore.RANDOM.nextInt(2, 5), 1.0f, true, true);
        } else if (item == PrimalAPI.Items.ARROW_PARAFFIN) {
            FireHelper.explode(world, pos, (Entity)entity, PrimalCore.RANDOM.nextInt(2, 3), 1.0f, true, true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onItemPickup(EntityItemPickupEvent event) {
        World world = event.getEntity().func_130014_f_();
        EntityItem entityItem = event.getItem();
        BlockPos pos = entityItem.func_180425_c();
        if (world.field_72995_K) {
            return;
        }
        if (ModConfig.Plants.CINERIS_CARPET_PREVENTS_PICKUP && !event.getEntityPlayer().func_70093_af()) {
            for (int i = 0; i <= 1; ++i) {
                Block base = world.func_180495_p(pos.func_177979_c(i)).func_177230_c();
                if (!(base instanceof CarpetCineris) && !(base instanceof ThatchNether)) continue;
                event.setCanceled(true);
            }
        }
    }

    static {
        PrimalAPI.logger(1, "Registering Item Entity Events");
    }
}

