/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.living;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.compat.ModLoot;
import nmd.primal.core.common.entities.ai.AIEatFoodItems;
import nmd.primal.core.common.entities.ai.AIEatPrimalGrass;
import nmd.primal.core.common.entities.ai.AIFleeRain;
import nmd.primal.core.common.entities.ai.AIRestrictRain;
import nmd.primal.core.common.entities.ai.AITempt;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.CompatHelper;
import nmd.primal.core.common.helper.DamageHelper;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModCompat;
import nmd.primal.core.common.init.ModConfig;

public class EntityOvisAtre
extends EntityAnimal
implements IShearable {
    private static final DataParameter<Float> HEALTH = EntityDataManager.func_187226_a(EntityOvisAtre.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntityOvisAtre.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityOvisAtre.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(EntityOvisAtre.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final List<Item> FOOD_BLACKLIST = CommonUtils.getItemList(ModConfig.Monsters.OVIS_ATRE_FOOD_BLACKLIST);
    private static final List<String> FOOD_NAMES = Arrays.asList(ModConfig.Monsters.OVIS_ATRE_FOOD_DICTIONARY_NAMES);
    private AIEatPrimalGrass eatGrass;
    private int sheepTimer;
    private int angryTimer;
    private FluidTank tank = new FluidTank(1000){

        public boolean canFill() {
            return false;
        }
    };

    public EntityOvisAtre(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        this.field_70178_ae = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
    }

    public ItemStack getWool() {
        return new ItemStack(PrimalAPI.Blocks.OVIS_ATRE_WOOL);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ModConfig.Monsters.OVIS_ATRE_STATS[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getSaddled() ? ModConfig.Monsters.OVIS_ATRE_STATS[1] * 2.0 : ModConfig.Monsters.OVIS_ATRE_STATS[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ModConfig.Monsters.OVIS_ATRE_STATS[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(ModConfig.Monsters.OVIS_ATRE_STATS[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(ModConfig.Monsters.OVIS_ATRE_STATS[4]);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(ANGRY, (Object)false);
        this.field_70180_af.func_187214_a(HEALTH, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByTarget());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, true, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, true, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIRestrictRain((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIFleeRain((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.eatGrass = new AIEatPrimalGrass((EntityLiving)this);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.eatGrass);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIEatFoodItems(this, 1.2));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new AITempt(this, 1.1, false));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
    }

    public boolean func_70686_a(Class target) {
        return EntityOvisAtre.class != target && EntityPigZombie.class != target && !CompatHelper.isModEntityMatch(target, "quark", ModCompat.QUARK_WRAITH);
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(HEALTH, (Object)Float.valueOf(this.func_110143_aJ()));
        this.sheepTimer = this.eatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        World world = this.func_130014_f_();
        BlockPos pos = this.func_180425_c();
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
            if (!this.getSheared() && CommonUtils.isExposedToSun(world, pos.func_177984_a())) {
                FXHelper.smokeParticles(world, pos, 4, 16, 0.9, 0.0);
            }
        }
        if (!world.field_72995_K) {
            if (this.getAngry()) {
                PrimalAPI.logger(60, "angry: " + this.angryTimer);
                if (this.func_70638_az() == null || this.angryTimer == 0) {
                    this.setAngry(false);
                    this.angryTimer = 0;
                } else {
                    this.angryTimer = Math.max(0, this.angryTimer - 1);
                }
            }
            if (this.func_70644_a(MobEffects.field_82731_v)) {
                this.func_184596_c(MobEffects.field_82731_v);
            }
            if (this.func_70644_a(MobEffects.field_76436_u)) {
                this.func_184596_c(MobEffects.field_76436_u);
            }
        }
        super.func_70636_d();
    }

    public void func_70110_aj() {
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean canTrample(World world, Block block, BlockPos pos, float fallDistance) {
        return block != PrimalAPI.Blocks.NETHER_FARMLAND && super.canTrample(world, block, pos, fallDistance);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.getAngry() && super.func_184652_a(player);
    }

    public EntityOvisAtre createChild(EntityAgeable ageable) {
        return new EntityOvisAtre(this.func_130014_f_());
    }

    public boolean func_70877_b(ItemStack stack) {
        return !stack.func_190926_b() && !FOOD_BLACKLIST.contains(stack.func_77973_b()) && RecipeHelper.isOreName(stack, FOOD_NAMES);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        ItemStack milkStack = this.getMilkBottle();
        if (!heldStack.func_190926_b() && this.canMilk()) {
            if (heldStack.func_77973_b() == Items.field_151069_bo && this.drainMilk(250)) {
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187564_an, SoundCategory.PLAYERS, 1.0f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
                heldStack.func_190918_g(1);
                if (heldStack.func_190926_b()) {
                    player.func_184611_a(hand, milkStack);
                } else if (!player.field_71071_by.func_70441_a(milkStack)) {
                    player.func_71019_a(milkStack, false);
                }
                return true;
            }
            if (FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)heldStack, (int)1)) != null) {
                IFluidHandler handler = (IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (handler != null) {
                    FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)handler);
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public boolean getAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.field_70180_af.func_187227_b(ANGRY, (Object)(angry && !this.func_70631_g_() && !this.getSaddled() ? 1 : 0));
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        super.func_70624_b(target);
        if (target == null) {
            this.setAngry(false);
        } else if (!this.getSaddled()) {
            this.setAngry(true);
            this.angryTimer = 160;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return flag;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_82727_n || source == DamageSource.field_76379_h || source == DamageSource.field_76367_g || source == DamageHelper.DAUCUS || source == DamageHelper.ACONITE || source == DamageHelper.YEW;
    }

    public boolean isSaddleable() {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public boolean getSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)(saddled && this.isSaddleable() ? 1 : 0));
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public boolean getSheared() {
        return (Boolean)this.field_70180_af.func_187225_a(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.field_70180_af.func_187227_b(SHEARED, (Object)sheared);
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        int base_amount = Math.max(1, ModConfig.Monsters.OVIS_ATRE_WOOL_SHEAR_AMOUNT);
        int true_amount = base_amount > 1 ? 1 + PrimalCore.RANDOM.nextInt(base_amount) : base_amount;
        this.setSheared(true);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < true_amount; ++j) {
            ret.add(this.getWool());
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public void func_70615_aA() {
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        } else {
            this.setSheared(false);
            this.fillMilk(1000);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean canMilk() {
        return !this.func_70631_g_() && !this.func_70880_s() && !this.func_184207_aI();
    }

    public FluidStack getMilk(int amount) {
        return new FluidStack(PrimalAPI.Fluids.OVIS_ATRE_MILK, amount);
    }

    public ItemStack getMilkBottle() {
        return new ItemStack(PrimalAPI.Items.OVIS_MILK_BOTTLE);
    }

    public int getMilkAmount() {
        return this.getTank().getFluidAmount();
    }

    public void fillMilk(int amount) {
        this.getTank().fillInternal(this.getMilk(amount), true);
    }

    public boolean drainMilk(int amount) {
        FluidStack stack = this.getTank().drain(amount, true);
        return stack != null && stack.amount == amount;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.canMilk() && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.canMilk() && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getTank();
        }
        return (T)super.getCapability(capability, facing);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Sheared", this.getSheared());
        nbt.func_74757_a("Saddled", this.getSaddled());
        nbt.func_74757_a("Angry", this.getAngry());
        this.getTank().writeToNBT(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSheared(nbt.func_74767_n("Sheared"));
        this.setSaddled(nbt.func_74767_n("Saddled"));
        this.setAngry(nbt.func_74767_n("Angry"));
        this.getTank().setCapacity(1000);
        this.getTank().readFromNBT(nbt);
    }

    protected ResourceLocation func_184647_J() {
        return this.getSheared() ? ModLoot.ENTITIES_OVIS_ATRE : ModLoot.ENTITIES_OVIS_ATRE_WOOL;
    }

    protected SoundEvent func_184639_G() {
        return this.getAngry() ? PrimalAPI.Sounds.SOUND_ENTITY_OVIS_ANGRY : PrimalAPI.Sounds.SOUND_ENTITY_OVIS_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return PrimalAPI.Sounds.SOUND_ENTITY_OVIS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return PrimalAPI.Sounds.SOUND_ENTITY_OVIS_ANGRY;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public float func_70047_e() {
        return 0.95f * this.field_70131_O;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float tilt) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - tilt) / 4.0f : -((float)(this.sheepTimer - 40) - tilt) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float tilt) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - tilt) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.getTank().fillInternal(this.getMilk(1000), true);
        return livingdata;
    }

    public boolean func_70601_bi() {
        PrimalAPI.logger(60, "spawning ovis atre");
        return true;
    }

    public int func_70641_bl() {
        return 8;
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityOvisAtre.this, false, new Class[0]);
        }

        public void func_75249_e() {
            if (EntityOvisAtre.this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                super.func_75249_e();
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_179446_a(EntityCreature creature, EntityLivingBase entity) {
            if (creature != null && creature instanceof EntityOvisAtre && !((EntityOvisAtre)creature).func_70631_g_()) {
                super.func_179446_a(creature, entity);
            }
        }
    }
}

