/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.living;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSnowBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.enums.EnumArmorSet;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.compat.ModLoot;
import nmd.primal.core.common.entities.ai.AIEatFoodItems;
import nmd.primal.core.common.entities.living.EntityBlackBear;
import nmd.primal.core.common.entities.living.EntityBrownBear;
import nmd.primal.core.common.entities.living.EntityNetherCreeper;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;

public class EntityCanisCampestris
extends EntityAnimal
implements IMob {
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityCanisCampestris.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> INFECTED = EntityDataManager.func_187226_a(EntityCanisCampestris.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final List<Item> FOOD_BLACKLIST = CommonUtils.getItemList(ModConfig.Monsters.STEPPE_WOLF_FOOD_BLACKLIST);
    private static final List<String> FOOD_NAMES = Arrays.asList(ModConfig.Monsters.STEPPE_WOLF_FOOD_DICTIONARY_NAMES);
    private boolean isInfected;
    private boolean isWet;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private float headRotationCourse;
    private float headRotationCourseOld;

    public EntityCanisCampestris(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.85f);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -0.0f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ModConfig.Monsters.STEPPE_WOLF_STATS[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ModConfig.Monsters.STEPPE_WOLF_STATS[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ModConfig.Monsters.STEPPE_WOLF_STATS[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(ModConfig.Monsters.STEPPE_WOLF_STATS[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(ModConfig.Monsters.STEPPE_WOLF_STATS[4]);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(INFECTED, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityBlackBear.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityBrownBear.class, 12.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityNetherCreeper.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityGolem.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.5f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AIHurtByTarget());
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCaveSpider.class, 5, false, false, IMob.field_175450_e));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 5, false, false, IMob.field_175450_e));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, 5, false, false, IMob.field_175450_e));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, 5, false, false, IMob.field_175450_e));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 30, false, false, IMob.field_175450_e));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 60, false, false, IMob.field_175450_e));
        this.field_70715_bh.func_75776_a(6, new AISpecialTarget<EntityPlayer>(this, EntityPlayer.class));
        this.field_70715_bh.func_75776_a(6, new AISpecialTarget<EntityAnimal>(this, EntityAnimal.class));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIEatFoodItems(this, 1.2));
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public boolean isAngry() {
        return true;
    }

    public boolean isInfected() {
        return (Boolean)this.field_70180_af.func_187225_a(INFECTED);
    }

    public boolean getInfected() {
        if (PrimalAPI.randomCheck(10)) {
            PrimalAPI.logger(2, "canis", "infected wolf spawned");
            this.isInfected = true;
        }
        return this.isInfected;
    }

    public void setInfected(byte infected) {
        if (infected > 0) {
            PrimalAPI.logger(2, "canis", "infected wolf created");
            this.isInfected = true;
            this.field_70180_af.func_187227_b(INFECTED, (Object)this.getInfected());
        }
    }

    public boolean func_70686_a(Class attack) {
        return EntityCanisCampestris.class != attack && EntityCreeper.class != attack && EntityFlying.class != attack && EntityWaterMob.class != attack;
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !this.func_180431_b(source) && super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.func_130014_f_().func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70636_d() {
        super.func_70636_d();
        World world = this.func_130014_f_();
        if (!world.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.func_130014_f_().func_72960_a((Entity)this, (byte)8);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        World world = this.func_130014_f_();
        this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f;
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
        } else if (!world.field_72995_K && PrimalAPI.randomCheck(1600) && !world.func_72935_r() && !world.func_72896_J() && world.func_175678_i(this.func_180425_c()) && world.func_130001_d() == 1.0f && world.func_175636_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 16.0) && !world.func_175636_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0)) {
            this.func_184185_a(this.getHowlSound(), this.getHowlVolume(), (PrimalCore.RANDOM.nextFloat() - PrimalCore.RANDOM.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    public boolean func_70601_bi() {
        IBlockState ground = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        if (ground.func_189884_a((Entity)this)) {
            BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
            if (this.func_180484_a(blockPos) >= 0.0f) {
                BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v));
                Block block = this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c();
                return WorldHelper.isMobLightLevel((EntityLivingBase)this) && (block instanceof BlockGrass || block instanceof BlockGrassPath || block instanceof BlockSnow || block instanceof BlockSnowBlock);
            }
        }
        return false;
    }

    public int func_70641_bl() {
        return 5;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70877_b(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            return !FOOD_BLACKLIST.contains(item) && (item instanceof ItemFood && ((ItemFood)item).func_77845_h() || RecipeHelper.isOreName(stack, FOOD_NAMES));
        }
        return false;
    }

    public EntityCanisCampestris createChild(EntityAgeable ageable) {
        return new EntityCanisCampestris(this.func_130014_f_());
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityCanisCampestris)) {
            return false;
        }
        EntityCanisCampestris canis = (EntityCanisCampestris)otherAnimal;
        return this.func_70880_s() && canis.func_70880_s();
    }

    protected ResourceLocation func_184647_J() {
        return ModLoot.ENTITIES_CANIS_CAMPRESTRIS;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return this.isAngry() ? SoundEvents.field_187861_gG : (PrimalAPI.randomCheck(3) ? (((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 10.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI) : SoundEvents.field_187857_gE);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected SoundEvent getHowlSound() {
        return PrimalAPI.Sounds.SOUND_ENTITY_WOLF_HOWL;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    private float getHowlVolume() {
        return 0.9f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isWolfWet() {
        return this.isWet;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileWet(float p_70915_1_) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70915_1_) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70923_1_ + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float p_70917_1_) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * p_70917_1_) * 0.15f * (float)Math.PI;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        return super.func_70646_bf();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return 0.62831855f;
    }

    static class AISpecialTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AISpecialTarget(EntityCanisCampestris canis, Class<T> classTarget) {
            super((EntityCreature)canis, classTarget, true);
        }

        public boolean func_75250_a() {
            World world = this.field_75299_d.func_130014_f_();
            if (world.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                float attack_weight = 0.15f;
                float attack_range = 5.0f;
                if (this.field_75309_a != null && !(this.field_75299_d.func_70013_c() >= 0.5f)) {
                    return PrimalAPI.randomCheck(attack_weight) && super.func_75250_a();
                }
                List list = world.func_175647_a(this.field_75307_b, this.func_188511_a(attack_range), this.field_82643_g);
                if (!list.isEmpty()) {
                    list.sort(this.field_75306_g);
                    this.field_75309_a = (EntityLivingBase)list.get(0);
                    return !PlayerHelper.isFullArmor(this.field_75309_a, EnumArmorSet.WOLF) && PrimalAPI.randomCheck(attack_weight);
                }
            }
            return false;
        }
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityCanisCampestris.this, false, new Class[0]);
        }

        public void func_75249_e() {
            if (EntityCanisCampestris.this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                super.func_75249_e();
                this.func_190105_f();
            }
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            if (creatureIn != null && creatureIn instanceof EntityCanisCampestris && !((EntityCanisCampestris)creatureIn).func_70631_g_()) {
                super.func_179446_a(creatureIn, entityLivingBaseIn);
            }
        }
    }
}

