/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.mods;

import crazypants.enderio.api.teleport.TeleportEntityEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.tile.SmelterRecipe;

public class EIOCompat {
    public static final String MOD_ID = "enderio";
    @GameRegistry.ObjectHolder(value="enderio:item_alloy_nugget")
    private static final Item EIO_NUGGET;
    @GameRegistry.ObjectHolder(value="enderio:item_alloy_ingot")
    private static final Item EIO_INGOT;
    @GameRegistry.ObjectHolder(value="enderio:item_material")
    private static final Item EIO_MATERIAL;
    @GameRegistry.ObjectHolder(value="enderio:block_fused_glass")
    private static final Block EIO_FUSED_GLASS;
    @GameRegistry.ObjectHolder(value="enderio:block_fused_quartz")
    private static final Block EIO_FUSED_QUARTZ;
    @GameRegistry.ObjectHolder(value="enderio:block_enlightened_fused_quartz")
    private static final Block EIO_ENLIGHTENED_QUARTZ;

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new EIOCompat());
    }

    @Optional.Method(modid="enderio")
    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=false)
    public void onTeleportEntity(TeleportEntityEvent event) {
        World world = event.getEntity().func_130014_f_();
        if (!world.field_72995_K) {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (int i = 0; i <= 2; ++i) {
                states.add(world.func_180495_p(event.getEntity().func_180425_c().func_177979_c(i)));
                states.add(world.func_180495_p(event.getTarget().func_177979_c(i)));
            }
            for (IBlockState state : states) {
                if (!PrimalAPI.Predicates.TELEPORT_INTERDICTION.apply((Object)state)) continue;
                FXHelper.soundMagicInhibit(world, event.getEntity().func_180425_c(), 1.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void registerSmelterRecipes(RegistryEvent.Register<SmelterRecipe> event) {
        if (ModConfig.Compatibility.ENDERIO_SMELTER_RECIPES) {
            PrimalAPI.logger(7, "Registering Smelter Recipes: enderio");
            IForgeRegistry<SmelterRecipe> recipes = SmelterRecipe.REGISTRY;
            List<ItemStack> charcoal = RecipeHelper.getOreStack(1, "charcoalGood", "charcoalHigh");
            List<ItemStack> ore_flux = RecipeHelper.getOreStack(2, "slackLime");
            ItemStack slag = new ItemStack(PrimalAPI.Items.SLAG, 1);
            int smelting_time_base = 13;
            boolean ingot_amount = true;
            int extra_amount = 4;
            if (EIO_FUSED_GLASS != null) {
                recipes.register((IForgeRegistryEntry)new SmelterRecipe(10, RecipeHelper.buildList(new ItemStack(Blocks.field_150359_w)), RecipeHelper.getOreStack("charcoalMote", 2, new ItemStack[0]), new ItemStack(EIO_FUSED_GLASS, 1)).setRecipeName("enderio_fused_glass"));
            }
            if (EIO_FUSED_QUARTZ != null && EIO_ENLIGHTENED_QUARTZ != null) {
                recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.getOreStack("gemQuartz", 4, new ItemStack[0]), RecipeHelper.getOreStack("charcoalMote", 4, new ItemStack[0]), new ItemStack(EIO_FUSED_QUARTZ, 1)).setRecipeName("enderio_fused_quartz"));
                recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.getOreStack("fusedQuartz", 1, new ItemStack[0]), RecipeHelper.getOreStack("dustGlowstone", 4, new ItemStack[0]), RecipeHelper.getOreStack("charcoalMote", 2, new ItemStack[0]), new ItemStack(EIO_ENLIGHTENED_QUARTZ, 1)).setRecipeName("enderio_enlightened_fused_quartz"));
            }
            if (EIO_MATERIAL != null) {
                recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.getOreStack("gemDiamond", 1, new ItemStack[0]), RecipeHelper.getOreStack("nuggetPulsatingIron", 4, new ItemStack[0]), charcoal, new ItemStack(EIO_MATERIAL, 1, 14)).setRecipeName("enderio_pulsating_crystal"));
                recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.getOreStack("gemEmerald", 1, new ItemStack[0]), RecipeHelper.getOreStack("nuggetVibrantAlloy", 4, new ItemStack[0]), charcoal, new ItemStack(EIO_MATERIAL, 1, 15)).setRecipeName("enderio_vibrant_crystal"));
                recipes.register((IForgeRegistryEntry)new SmelterRecipe(13, RecipeHelper.getOreStack("itemBinderComposite", 1, new ItemStack[0]), RecipeHelper.getOreStack("charcoalMote", 2, new ItemStack[0]), new ItemStack(EIO_MATERIAL, 2, 4)).setRecipeName("enderio_conduit_binder"));
            }
            if (EIO_NUGGET != null && EIO_INGOT != null) {
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack("ingotIron", 1, new ItemStack[0]), RecipeHelper.getOreStack("dustCoal", 1, new ItemStack[0]), RecipeHelper.getOreStack("itemSilicon", 1, new ItemStack[0]), charcoal, new ItemStack(EIO_INGOT, 1, 0), new ItemStack(EIO_NUGGET, 4, 0)).setRecipeName("enderio_electrical_steel")).setSlag(true));
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack("ingotGold", 1, new ItemStack[0]), RecipeHelper.getOreStack("dustRedstone", 1, new ItemStack[0]), RecipeHelper.getOreStack("dustGlowstone", 1, new ItemStack[0]), charcoal, new ItemStack(EIO_INGOT, 1, 1), new ItemStack(EIO_NUGGET, 4, 1)).setRecipeName("enderio_energetic_alloy")).setSlag(true));
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack("ingotEnergeticAlloy", 1, new ItemStack[0]), RecipeHelper.getOreStack("enderpearl", 1, new ItemStack[0]), charcoal, new ItemStack(EIO_INGOT, 1, 2), new ItemStack(EIO_NUGGET, 4, 2)).setRecipeName("enderio_vibrant_alloy")).setSlag(true));
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack("dustRedstone", 1, new ItemStack[0]), RecipeHelper.getOreStack("itemSilicon", 1, new ItemStack[0]), charcoal, new ItemStack(EIO_INGOT, 1, 3), new ItemStack(EIO_NUGGET, 4, 3)).setRecipeName("enderio_redstone_alloy")).setSlag(true));
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack("ingotIron", 1, new ItemStack[0]), RecipeHelper.getOreStack("dustRedstone", 1, new ItemStack[0]), charcoal, new ItemStack(EIO_INGOT, 1, 4), new ItemStack(EIO_NUGGET, 4, 4)).setRecipeName("enderio_conductive_alloy")).setSlag(true));
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack("ingotIron", 1, new ItemStack[0]), RecipeHelper.getOreStack("enderpearl", 1, new ItemStack[0]), charcoal, new ItemStack(EIO_INGOT, 1, 5), new ItemStack(EIO_NUGGET, 4, 5)).setRecipeName("enderio_pulsating_alloy")).setSlag(true));
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack("ingotSteel", 1, new ItemStack[0]), RecipeHelper.getOreStack("dustObsidian", 1, new ItemStack[0]), RecipeHelper.getOreStack("ashBone", 2, new ItemStack[0]), RecipeHelper.getOreStack("charcoalHigh", 2, new ItemStack[0]), new ItemStack(EIO_INGOT, 1, 6), new ItemStack(EIO_NUGGET, 4, 6)).setRecipeName("enderio_dark_steel")).setSlag(true));
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack("ingotGold", 1, new ItemStack[0]), RecipeHelper.getOreStack("soulsand", 1, new ItemStack[0]), RecipeHelper.getOreStack("ashBone", 1, new ItemStack[0]), RecipeHelper.getOreStack("charcoalHigh", 1, new ItemStack[0]), new ItemStack(EIO_INGOT, 1, 7), new ItemStack(EIO_NUGGET, 4, 7)).setRecipeName("enderio_soularium")).setSlag(true));
                recipes.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(13, RecipeHelper.getOreStack("ingotDarkSteel", 1, new ItemStack[0]), RecipeHelper.getOreStack("endstone", 1, new ItemStack[0]), RecipeHelper.getOreStack("obsidian", 1, new ItemStack[0]), RecipeHelper.getOreStack("charcoalHigh", 2, new ItemStack[0]), new ItemStack(EIO_INGOT, 1, 8), new ItemStack(EIO_NUGGET, 4, 8)).setRecipeName("enderio_end_steel")).setSlag(true));
            }
        }
    }

    static {
        PrimalAPI.logger(1, "Mod Integration: enderio");
        EIO_NUGGET = null;
        EIO_INGOT = null;
        EIO_MATERIAL = null;
        EIO_FUSED_GLASS = null;
        EIO_FUSED_QUARTZ = null;
        EIO_ENLIGHTENED_QUARTZ = null;
    }
}

