/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.ct;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.tile.HibachiRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.primal.Hibachi")
@ModOnly(value="primal")
@ZenRegister
public class CTHibachi {
    @ZenMethod
    public static void addRecipe(String recipe_name, int cook_time, IIngredient ingredients, IItemStack output_success) {
        CraftTweakerAPI.apply((IAction)new Add(recipe_name, cook_time, ingredients, (ItemStack)output_success.getInternal()));
    }

    @ZenMethod
    public static void removeRecipe(String recipe_name) {
        CraftTweakerAPI.apply((IAction)new Remove(recipe_name));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    static {
        PrimalCore.LOGGER.info("Registering CraftTweaker: hibachi");
    }

    private static class RemoveAll
    implements IAction {
        public void apply() {
            for (HibachiRecipe recipe : HibachiRecipe.RECIPES) {
                if (recipe.isHidden()) continue;
                recipe.setDisabled(true);
            }
            for (HibachiRecipe recipe : HibachiRecipe.FURNACE_RECIPES) {
                if (recipe.isHidden()) continue;
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for:hibachi";
        }
    }

    private static class Remove
    implements IAction {
        private String recipe_name;

        public Remove(String recipe_name) {
            this.recipe_name = recipe_name;
        }

        public void apply() {
            HibachiRecipe recipe = (HibachiRecipe)HibachiRecipe.REGISTRY.getValue(HibachiRecipe.getFullRecipeName(this.recipe_name));
            if (recipe != null && !recipe.isHidden()) {
                PrimalCore.LOGGER.info("Remove CraftTweaker Recipe: " + this.recipe_name);
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for:hibachi";
        }
    }

    private static class Add
    implements IAction {
        private final String recipe_name;
        private final List<ItemStack> ingredients;
        private final ItemStack output;
        private final int cook_time;
        private boolean is_disabled;
        private boolean is_hidden;

        public Add(String recipe_name, int cook_time, IIngredient ingredients, ItemStack output) {
            this.recipe_name = recipe_name;
            this.cook_time = cook_time;
            this.ingredients = RecipeHelper.getIIngredientStacks(ingredients);
            this.output = output;
            this.is_disabled = false;
            this.is_hidden = false;
        }

        public void apply() {
            PrimalCore.LOGGER.info("Add CraftTweaker Recipe: " + this.recipe_name);
            HibachiRecipe.REGISTRY.register((IForgeRegistryEntry)new HibachiRecipe(this.cook_time, this.ingredients, this.output).setRecipeName(this.recipe_name));
        }

        public String describe() {
            return "[PrimalCore] Adding Crafting Tweaker recipe for: hibachi";
        }
    }
}

