/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.saxum;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IPhased;
import nmd.primal.core.api.interfaces.types.ITypeBrick;
import nmd.primal.core.common.blocks.AbstractBlock;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;

public class BrickType
extends AbstractBlock
implements ITypeBrick,
IPhased {
    public BrickType(Material material, SoundType sound, MapColor mapColor, int tool_level, String tool_type) {
        super(material, mapColor);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeBrick.EnumType.NORMAL)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)IPhased.PHASED, (Comparable)Boolean.valueOf(false)));
        this.setHarvestLevel(tool_type, tool_level);
        this.func_149672_a(sound);
    }

    public BrickType(MapColor mapColor, int tool_level) {
        this(Material.field_151576_e, SoundType.field_185851_d, mapColor, tool_level, "pickaxe");
    }

    public BrickType(MapColor mapColor) {
        this(Material.field_151576_e, SoundType.field_185851_d, mapColor, 1, "pickaxe");
    }

    @Override
    public boolean isPhasedAccessible(IBlockAccess world, BlockPos pos, IBlockState state, @Nullable Entity entity) {
        return this.isPhased(state);
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return state.func_177229_b((IProperty)TYPE) == ITypeBrick.EnumType.NORMAL && !BlockMultiplexer.forBlock(PrimalAPI.Blocks.MUD_DRIED, PrimalAPI.Blocks.COMMON_STONE, PrimalAPI.Blocks.NETHER_STONE, PrimalAPI.Blocks.NETHER_EARTH, PrimalAPI.Blocks.SOUL_STONE).apply(state);
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ITypeBrick.EnumType.isPillar(state) ? PrimalAPI.Bounds.AABB_PILLAR : field_185505_j;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean func_176214_u(IBlockState state) {
        return !ITypeBrick.EnumType.isPillar(state) && super.func_176214_u(state);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ITypeBrick.EnumType.isPillar(state) ? 8 : state.func_185891_c();
    }

    public boolean func_149637_q(IBlockState state) {
        return !(state.func_177230_c() instanceof ITypeBrick) || ITypeBrick.EnumType.isSolid(state);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ITypeBrick.EnumType.isSolid(state) && !this.isPhased(world, pos, state);
    }

    public boolean func_149686_d(IBlockState state) {
        return ITypeBrick.EnumType.isSolid(state) && !this.isPhased(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return ITypeBrick.EnumType.isSolid(state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return ITypeBrick.EnumType.isSolid(state) ? BlockFaceShape.SOLID : BlockFaceShape.MIDDLE_POLE_THICK;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return ITypeBrick.EnumType.isPillar(state) && layer == BlockRenderLayer.CUTOUT_MIPPED || this.func_180664_k() == layer;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ITypeBrick.EnumType.isSolid(state) && !this.isPhased(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState neighbor_state = world.func_180495_p(pos.func_177972_a(side));
        return state != neighbor_state && super.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.getTypes(Item.func_150898_a((Block)this), tab, list);
    }

    public int func_180651_a(IBlockState state) {
        return ((ITypeBrick.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IPhased.PHASED, ITypeBrick.TYPE, ITypeBrick.UP, ITypeBrick.DOWN});
    }

    public IBlockState func_176203_a(int meta) {
        boolean phased = (meta & 8) > 0;
        int adjusted_meta = phased ? meta - 8 : meta;
        return this.func_176223_P().func_177226_a(ITypeBrick.TYPE, (Comparable)((Object)ITypeBrick.EnumType.byMetadata(adjusted_meta))).func_177226_a((IProperty)IPhased.PHASED, (Comparable)Boolean.valueOf(phased));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((ITypeBrick.EnumType)((Object)state.func_177229_b(ITypeBrick.TYPE))).getMetadata();
        if (((Boolean)state.func_177229_b((IProperty)IPhased.PHASED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean up = ITypeBrick.EnumType.canConnectTo(state, world, pos.func_177984_a());
        boolean down = ITypeBrick.EnumType.canConnectTo(state, world, pos.func_177977_b());
        return state.func_177226_a((IProperty)ITypeBrick.UP, (Comparable)Boolean.valueOf(up)).func_177226_a((IProperty)ITypeBrick.DOWN, (Comparable)Boolean.valueOf(down));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        PrimalAPI.logger(3, "getStateForPlacement", "meta: " + meta);
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeBrick.EnumType.byMetadata(placer != null ? placer.func_184586_b(hand).func_77952_i() : meta))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)IPhased.PHASED, (Comparable)Boolean.valueOf(false));
    }
}

