/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.thatch;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.common.blocks.AbstractBlock;
import nmd.primal.core.common.entities.living.EntityOvisAtre;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;

public class CarpetCineris
extends AbstractBlock
implements IFace {
    public CarpetCineris() {
        super(Material.field_151593_r);
        this.func_149672_a(SoundType.field_185850_c);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)"tooltip.info.primal.cineris_carpet"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_environment"));
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    private double getSpeed(World world, BlockPos pos) {
        double[] speeds = ModConfig.Plants.CINERIS_CARPET_SPEED_MODIFIERS;
        IBlockState base_state = world.func_180495_p(pos.func_177977_b());
        Block base_block = base_state.func_177230_c();
        if (base_block instanceof BlockSlime) {
            return speeds[0];
        }
        if (base_block == Blocks.field_150339_S || RecipeHelper.isOreName(base_block, "blockCopper", "blockTin")) {
            return speeds[2];
        }
        if (PrimalAPI.Predicates.LOOTING_2_BLOCKS.apply((Object)base_state)) {
            return speeds[3];
        }
        if (PrimalAPI.Predicates.LOOTING_3_BLOCKS.apply((Object)base_state)) {
            return speeds[4];
        }
        return speeds[1];
    }

    private void collideWithCineris(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase && entity.field_70122_E && !(entity instanceof EntityOvisAtre) && !(entity instanceof EntityMagmaCube) && !PlayerHelper.isNetherCapable((EntityLivingBase)entity) || entity instanceof EntityItem) {
            double factor = this.getSpeed(world, pos);
            double movement = (double)RANDOM.nextFloat() * factor;
            double x = 0.0;
            double z = 0.0;
            EnumFacing facing = this.getFacing(state);
            switch (facing) {
                case NORTH: {
                    z = entity.func_70093_af() ? -movement : movement;
                    break;
                }
                case SOUTH: {
                    z = entity.func_70093_af() ? movement : -movement;
                    break;
                }
                case EAST: {
                    x = entity.func_70093_af() ? movement : -movement;
                    break;
                }
                case WEST: {
                    x = entity.func_70093_af() ? -movement : movement;
                    break;
                }
                default: {
                    x += (double)RANDOM.nextFloat() * factor - (double)RANDOM.nextFloat() * factor;
                    z += (double)RANDOM.nextFloat() * factor - (double)RANDOM.nextFloat() * factor;
                }
            }
            entity.func_70024_g(x, 0.0, z);
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        this.collideWithCineris(world, pos, state, entity);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_CARPET;
    }

    public MapColor getMapColor(IBlockState state) {
        return MapColor.field_151646_E;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos.func_177977_b());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? true : (blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? true : super.func_176225_a(blockState, blockAccess, pos, side));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)this.getHorizontalFacingFromIndex(this.getFacingIndexFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return this.getHorizontalIndexFromState(state);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)this.getPlacementFacing(placer));
        return state;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

