/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.invasive;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IInvasive;
import nmd.primal.core.api.interfaces.plants.IPerennial;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlantInvasive;
import nmd.primal.core.common.entities.living.EntityOvisAtre;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.TeleportHelper;
import nmd.primal.core.common.init.ModConfig;

public class InanisGrass
extends AbstractPlantInvasive
implements IShearable,
IPerennial,
ISchedule {
    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isMature(state) ? PrimalAPI.Bounds.AABB_BUSH_LARGE : (this.getAge(state) == 0 ? PrimalAPI.Bounds.AABB_EMPTY : PrimalAPI.Bounds.AABB_BUSH);
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Plants.PLANT_BASE_TICK_RATE / 2, ModConfig.Plants.PLANT_BASE_TICK_RATE);
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.VOID;
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.INANIS_SEED);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.INANIS_FIBER);
    }

    @Override
    public ItemStack getStalk(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.INANIS_ROOT);
    }

    @Override
    public boolean isMature(IBlockState state) {
        return this.getAge(state) == 3;
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return super.getGrowChance(world, pos, state);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid(world, pos, EnumFacing.UP) || PrimalAPI.Predicates.SOIL_NETHER_COMMON.apply((Object)state);
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.25f;
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return CommonUtils.isValueMatch(this.getAge(state), 3);
    }

    @Override
    public boolean shouldSpread(World world, BlockPos pos, IBlockState state) {
        PrimalAPI.logger(8, "void grass", "shouldSpread: " + this.isBlooming(state));
        return world.field_73011_w.func_186058_p() != DimensionType.THE_END && !CommonUtils.isValueMatch(this.getAge(world.func_180495_p(pos)), 3) && !PrimalAPI.Predicates.SPREAD_INTERDICTION.apply((Object)world.func_180495_p(pos.func_177977_b()));
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos source_pos, BlockPos spread_pos) {
        return !world.func_175727_C(spread_pos) && !PrimalAPI.Predicates.SPREAD_RESISTANT.apply((Object)world.func_180495_p(source_pos.func_177977_b()));
    }

    @Override
    public float getSpreadChance(World word, BlockPos source_pos, IBlockState source_state) {
        return 0.25f;
    }

    @Override
    public int getSpreadChecks(World word, BlockPos source_pos, IBlockState source_state) {
        return 16;
    }

    @Override
    public int getSpreadRange(World word, BlockPos source_pos, IBlockState source_state) {
        return 6;
    }

    @Override
    public IBlockState getNewPlant() {
        return this.func_176223_P();
    }

    @Override
    public boolean canNewGrow(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public void updatePlant(World world, BlockPos pos, IBlockState state, Random rand, int age) {
        if (world.func_175727_C(pos) && PrimalAPI.randomCheck(ModConfig.Plants.PLANT_RAIN_SENSITIVITY)) {
            world.func_175655_b(pos, false);
            return;
        }
        if (this.isBlooming(state) && PrimalAPI.randomCheck(3)) {
            this.bloomPlant(world, pos, state, RANDOM, true);
            return;
        }
        switch (age) {
            case 3: {
                this.bloomPlant(world, pos, state, RANDOM, true);
                break;
            }
            default: {
                world.func_180501_a(pos, this.increaseAge(state, 1), 2);
            }
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        ((IInvasive)PrimalAPI.Blocks.INANIS_GRASS).spreadPlant(world, pos, PrimalAPI.Blocks.INANIS_GRASS.func_176223_P());
        super.onBlockExploded(world, pos, explosion);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && PrimalAPI.randomCheck(ModConfig.Plants.INERIS_TELEPORT_CHANCE)) {
            if (this.isBlooming(state) && entity.func_184222_aU() && entity instanceof EntityLivingBase && !(entity instanceof EntityEnderman) && !(entity instanceof EntityEndermite) && !(entity instanceof EntityShulker) && !(entity instanceof EntityOvisAtre) && !entity.func_70026_G()) {
                TeleportHelper.teleportRandomly((EntityLivingBase)entity);
            } else if (PrimalAPI.randomCheck(ModConfig.Worldgen.GEN_INERIS_BLOOM_CHANCE * 0.25) && entity instanceof EntityPlayer && !this.isScheduled(world, pos)) {
                PrimalAPI.logger(8, "ineris", "bloom triggered");
                world.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 0.2f, ((RANDOM.nextFloat() - RANDOM.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.scheduleUpdate(world, pos, state);
            }
        }
    }

    @Override
    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, @Nullable ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        if (this.isBlooming(state)) {
            TeleportHelper.teleportRandomly((EntityLivingBase)player);
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots && PrimalAPI.randomCheck(ModConfig.Survival.DROPS_VOID_FIBERS)) {
            InanisGrass.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getCrop(state));
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack drop = this.isMature(state) ? this.getStalk(state) : this.getCrop(state);
        return Arrays.asList(drop);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isBlooming(state) ? 8 : 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isBlooming(state)) {
            FXHelper.makeParticles(world, pos, EnumParticleTypes.PORTAL, 4, 6, 0.425f);
        }
    }
}

