/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.invasive;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IInflictedDamage;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IPerennial;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlantGrowing;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.init.ModConfig;

public class CinerisBloom
extends AbstractPlantGrowing
implements IShearable,
IPerennial,
ISchedule,
IInflictedDamage,
ILit {
    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getAge(state) == 0 ? PrimalAPI.Bounds.AABB_EMPTY : PrimalAPI.Bounds.AABB_BUSH;
    }

    @Override
    public boolean isLit(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.isMature(state) && this.isBlooming(state);
    }

    @Override
    public boolean canLite(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean doExtinguish(World world, BlockPos pos, IBlockState state, EnumFacing face, @Nullable EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean shouldDamage(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && this.isMature(state) && this.isBlooming(state);
    }

    @Override
    public DamageSource getSource(World world, BlockPos pos) {
        return DamageSource.field_76372_a;
    }

    @Override
    public float getDamage(World world, BlockPos pos) {
        return 0.5f;
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Plants.PLANT_BASE_TICK_RATE / 2, ModConfig.Plants.PLANT_BASE_TICK_RATE);
    }

    @Override
    public IBlockState getNewPlant() {
        return this.func_176223_P();
    }

    @Override
    public boolean canNewGrow(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.NETHER;
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.SEARING_EMBER);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.CINERIS_FIBER);
    }

    @Override
    public ItemStack getStalk(IBlockState state) {
        return new ItemStack(PrimalAPI.Blocks.CINERIS_BLOOM);
    }

    @Override
    public boolean isMature(IBlockState state) {
        return this.getAge(state) == 4;
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return super.getGrowChance(world, pos, state);
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.65f;
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state) && CommonUtils.isValueMatch(this.getAge(state), 4);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return !BlockMultiplexer.forBlock(PrimalAPI.Blocks.NIGHT_STONE).apply(state) && (state.isSideSolid(world, pos, EnumFacing.UP) || PrimalAPI.Predicates.SOIL_NETHER_COMMON.apply((Object)state));
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.isBlooming(state) && PrimalAPI.randomCheck(260)) {
            entity.func_70015_d(3);
        }
    }

    @Override
    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, @Nullable ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots && (double)RANDOM.nextFloat() <= ModConfig.Survival.DROPS_CINERIS_FIBERS) {
            ItemStack seeds = this.getSeed(state);
            int amount = PrimalAPI.randomCheck(8) ? 2 : 1;
            seeds.func_190920_e(amount);
            CinerisBloom.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getCrop(state));
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack drop = this.isMature(state) ? this.getStalk(state) : this.getCrop(state);
        return Arrays.asList(drop);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isBlooming(state) ? 6 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isBlooming(state)) {
            EnumParticleTypes smoke = world.func_175727_C(pos) ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL;
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.7;
            double z = (double)pos.func_177952_p() + 0.5;
            world.func_175688_a(smoke, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            if (!CommonUtils.isExposedToSun(world, pos)) {
                world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IPrimalPlants.PLANT_AGE, IPrimalPlants.PLANT_BLOOM, ILit.LIT});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        boolean bloom = (meta & 8) > 0;
        int age = bloom ? meta - 8 : meta;
        return this.func_176223_P().func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(age)).func_177226_a((IProperty)IPrimalPlants.PLANT_BLOOM, (Comparable)Boolean.valueOf(bloom));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = this.getAge(state);
        if (this.isBlooming(state)) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)IPrimalPlants.PLANT_BLOOM, (Comparable)Boolean.valueOf(true));
    }
}

