/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.crops;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IColouredBlock;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IPerennial;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.BlockColours;
import nmd.primal.core.common.blocks.plants.AbstractPlantGrowing;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.init.ModConfig;

public class Rushes
extends AbstractPlantGrowing
implements IShearable,
IPerennial,
ISchedule,
IColouredBlock {
    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return BlockColours.RUSH_COLOUR;
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state) && !CommonUtils.isValueMatch(this.getAge(state), 3);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Plants.PLANT_BASE_TICK_RATE / 2, ModConfig.Plants.PLANT_BASE_TICK_RATE);
    }

    @Override
    public IBlockState getNewPlant() {
        return this.func_176223_P();
    }

    @Override
    public boolean canNewGrow(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.NORMAL;
    }

    @Override
    public ItemStack getStalk(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.RUSH_STEMS);
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.RUSH_SEEDS);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.RUSH_STEMS);
    }

    @Override
    public int getMaxHeight() {
        return 2;
    }

    @Override
    public boolean isMature(IBlockState state) {
        return CommonUtils.isValueMatch(this.getAge(state), 3, 4);
    }

    @Override
    public void growFullPlant(World world, BlockPos pos, IBlockState state, int update_flag) {
        super.growFullPlant(world, pos, state, update_flag);
        if (world.field_72995_K) {
            return;
        }
        PrimalAPI.logger(8, "Rushes#growFullPlant");
        if (this.isValidSoil((IBlockAccess)world, pos.func_177977_b())) {
            world.func_180501_a(pos, this.getAgedPlant(state, 3), 2);
            world.func_180501_a(pos.func_177984_a(), this.getBloomingPlant(state, 4, RANDOM.nextBoolean()), 2);
        }
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return super.getGrowChance(world, pos, state);
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.45f;
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state) && CommonUtils.isValueMatch(this.getAge(state), 4);
    }

    public void func_176224_k(World world, BlockPos pos) {
        PrimalAPI.logger(2, "rushes", "are getting rained on");
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        int age = this.getAge(world.func_180495_p(pos));
        if (age > 3) {
            entity.field_70159_w *= ModConfig.Plants.RUSH_MOVEMENT;
            entity.field_70179_y *= ModConfig.Plants.RUSH_MOVEMENT;
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            float seeds = 0.25f;
            if (this.isBlooming(state)) {
                ItemStack seed = this.getSeed(state);
                if (PrimalAPI.randomCheck(seeds)) {
                    seed.func_190920_e(2);
                }
                Rushes.func_180635_a((World)world, (BlockPos)pos, (ItemStack)seed);
            }
            if (this.getAge(state) > 1) {
                Rushes.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getCrop(state));
            } else if (PrimalAPI.randomCheck(seeds)) {
                Rushes.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getSeed(state));
            }
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        IBlockState state = world.func_180495_p(pos);
        float seeds = 0.25f;
        if (this.isBlooming(state)) {
            ItemStack seed = this.getSeed(state);
            if (PrimalAPI.randomCheck(seeds)) {
                seed.func_190920_e(2);
            }
            drops.add(this.getSeed(state));
        }
        if (this.getAge(state) > 1) {
            drops.add(this.getCrop(state));
        } else if (PrimalAPI.randomCheck(seeds)) {
            drops.add(this.getSeed(state));
        }
        return drops;
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = this.getSoil((IBlockAccess)world, pos);
        if (state.func_177230_c() == this && this.getAge(state) < 4) {
            return (world.func_175699_k(pos) >= 8 || world.func_175678_i(pos)) && this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
        }
        return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant_state = plantable.getPlant(world, pos.func_177972_a(direction));
        Block plant = plant_state.func_177230_c();
        Block soil = state.func_177230_c();
        if (plant == this) {
            int age = this.getAge(plant_state);
            if (age > 3) {
                return soil == this && ((IPrimalPlants)soil).isMature(state) || this.isValidSoil(world, pos);
            }
            return this.isValidSoil(world, pos);
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        return PrimalAPI.Predicates.SOIL_SURFACE_COMMON.apply((Object)world.func_180495_p(pos));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getAge(state) == 0 ? PrimalAPI.Bounds.AABB_EMPTY : PrimalAPI.Bounds.AABB_BUSH_LARGE;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }
}

