/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.plants.IInvasive;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlantGrowing;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.init.ModConfig;

public abstract class AbstractPlantInvasive
extends AbstractPlantGrowing
implements IInvasive {
    public AbstractPlantInvasive(Material material, MapColor mapcolor) {
        super(material, mapcolor);
    }

    public AbstractPlantInvasive(Material material) {
        this(material, material.func_151565_r());
    }

    public AbstractPlantInvasive(MapColor mapcolor) {
        this(Material.field_151585_k, mapcolor);
    }

    public AbstractPlantInvasive() {
        this(Material.field_151585_k, Material.field_151585_k.func_151565_r());
    }

    @Override
    public IBlockState getSpreadPlant(World world, BlockPos pos) {
        return this.func_176223_P();
    }

    @Override
    public float getSpreadChance(World word, BlockPos source_pos, IBlockState source_state) {
        return (float)ModConfig.Plants.PLANT_BASE_SPREAD_CHANCE;
    }

    @Override
    public boolean spreadPlant(World world, BlockPos pos, IBlockState state, IInvasive plant, float chance, int iteration, int range) {
        if (!ModConfig.Plants.INVASIVE_PLANTS_SPREAD) {
            return false;
        }
        if (!world.func_175697_a(pos, 3)) {
            return false;
        }
        if (!(state.func_177230_c() instanceof IPrimalPlants)) {
            return false;
        }
        if (!PrimalAPI.randomCheck(plant.getSpreadChance(world, pos, state))) {
            return false;
        }
        if (!plant.shouldSpread(world, pos, state)) {
            return false;
        }
        for (int i = 0; i < plant.getSpreadChecks(world, pos, state); ++i) {
            BlockPos spread_pos = new BlockPos((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)range, (double)pos.func_177956_o() + RANDOM.nextGaussian() * (double)(range * 2), (double)pos.func_177952_p() + RANDOM.nextGaussian() * (double)range);
            if (world.func_189509_E(spread_pos) || !world.func_175623_d(spread_pos) || !plant.canSpreadTo(world, pos, spread_pos) || !plant.isValidSoil((IBlockAccess)world, spread_pos.func_177977_b())) continue;
            IBlockState spread_plant = plant.getSpreadPlant(world, pos);
            world.func_180501_a(spread_pos, spread_plant, CommonUtils.updateFlag(world));
            PrimalAPI.logger(5, "schedule", "@" + pos + ", AbstractPlantInvasive#spreadPlant");
            PrimalAPI.scheduleBlock(world, spread_pos, spread_plant);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMature(state);
    }

    @Override
    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getAge(state) == 0 ? PrimalAPI.Bounds.AABB_EMPTY : PrimalAPI.Bounds.AABB_BUSH;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }
}

