/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IHarvest;
import nmd.primal.core.api.interfaces.plants.IInvasive;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlant;
import nmd.primal.core.common.init.ModConfig;

public abstract class AbstractPlantGrowing
extends AbstractPlant
implements IGrowable {
    public AbstractPlantGrowing(Material material, MapColor mapcolor) {
        super(material, mapcolor);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)IPrimalPlants.PLANT_BLOOM, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(false);
    }

    public AbstractPlantGrowing(Material material) {
        this(material, material.func_151565_r());
    }

    public AbstractPlantGrowing(MapColor mapcolor) {
        this(Material.field_151585_k, mapcolor);
    }

    public AbstractPlantGrowing() {
        this(Material.field_151585_k, Material.field_151585_k.func_151565_r());
    }

    public boolean isFullHeight(World world, BlockPos pos, IBlockState state) {
        return this.getCurrentHeight(world, pos) == this.getMaxHeight();
    }

    public boolean isBelowHeight(World world, BlockPos pos, IBlockState state) {
        return this.getCurrentHeight(world, pos) < this.getMaxHeight();
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        if (this instanceof ISchedule) {
            return (float)ModConfig.Plants.PLANT_BASE_GROWTH_CHANCE;
        }
        return 0.005f;
    }

    public static float getGrowthChance(Block block, World world, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = world.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)world, blockpos.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)block)) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(world, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = block == world.func_180495_p(blockpos3).func_177230_c() || block == world.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = block == world.func_180495_p(blockpos1).func_177230_c() || block == world.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = block == world.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || block == world.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || block == world.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || block == world.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public static float getGrowthChance(World world, BlockPos pos, Block block) {
        return 0.0f;
    }

    @Override
    public boolean isFertile(World world, BlockPos pos) {
        return super.isFertile(world, pos.func_177979_c(this.getCurrentHeight(world, pos)));
    }

    @Override
    public void updatePlant(World world, BlockPos pos, IBlockState state, Random rand, int age) {
        if (this.isMature(state)) {
            float bloom_chance = this.getBloomChance(world, pos, state) + (float)ModConfig.Plants.PLANT_BLOOM_MODIFIER;
            PrimalAPI.logger(8, "plant updatePlant", "bloom chance: " + bloom_chance);
            if (this.canBloom(world, pos, state) && PrimalAPI.randomCheck(bloom_chance)) {
                world.func_180501_a(pos, state.func_177231_a((IProperty)PLANT_BLOOM), 2);
            }
        } else {
            IBlockState aged = this.increaseAge(state, 1);
            PrimalAPI.logger(8, "growing", "age: " + this.getAge(state) + ":" + this.getAge(aged));
            if (world.func_180501_a(pos, aged, 2) && this.isMature(aged) && this.isBelowHeight(world, pos, state)) {
                PrimalAPI.placeScheduledBlock(world, pos.func_177984_a(), this.increaseAge(aged, 1), 2);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        PrimalAPI.logger(8, "plant updateTick", this.getName() + "@" + pos + ", can bloom: " + this.canBloom(world, pos, state) + ", is mature: " + this.isMature(state) + ", height: " + this.getCurrentHeight(world, pos) + ":" + this.getMaxHeight() + ", grow chance: " + this.getGrowChance(world, pos, state));
        if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)PrimalAPI.randomCheck(this.getGrowChance(world, pos, state)))) {
            this.updatePlant(world, pos, state, RANDOM, this.getAge(state));
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
        }
        if (this instanceof IInvasive) {
            ((IInvasive)((Object)this)).spreadPlant(world, pos, state);
        }
        if (this instanceof ISchedule) {
            PrimalAPI.logger(5, "schedule", this.getName() + "@" + pos + ":" + world.field_73011_w.getDimension() + ", AbstractPlantGrowing#updateTick");
            PrimalAPI.scheduleBlock(world, pos, world.func_180495_p(pos));
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        if (pos.func_177984_a() == fromPos && this.isMature(state) && this.getCurrentHeight(world, pos) < this.getMaxHeight()) {
            PrimalAPI.logger(5, "schedule", "@" + pos + ", AbstractPlantGrowing#neighborChanged");
            PrimalAPI.scheduleBlock(world, pos, state);
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMature(state);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
    }

    public boolean harvestPlant(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand, int amount) {
        IBlockState harvested_state = state.func_177231_a((IProperty)PLANT_BLOOM);
        ItemStack stack = this.getCrop(state);
        stack.func_190920_e(amount);
        if (PrimalAPI.placeScheduledBlock(world, pos, harvested_state, 2)) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack.func_77946_l());
            return true;
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (this instanceof IHarvest && ((IHarvest)((Object)this)).canHarvest(state)) {
            if (this.harvestPlant(world, pos, state, face, player, hand, ((IHarvest)((Object)this)).harvestAmount())) {
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187571_bR, SoundCategory.PLAYERS, 0.2f, ((RANDOM.nextFloat() - RANDOM.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isBlooming(state) ? this.getCrop(state).func_77973_b() : null;
    }

    public int func_149745_a(Random random) {
        return 1 + RANDOM.nextInt(2);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ThreadLocalRandom rand = RANDOM;
        if (this.isBlooming(state)) {
            int count = this.quantityDropped(state, fortune, rand);
            for (int i = 0; i < count; ++i) {
                Item item = this.func_180660_a(state, rand, fortune);
                if (item == null) continue;
                drops.add(new ItemStack(item, 1, this.func_180651_a(state)));
            }
        }
        return drops;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (this == world.func_180495_p(pos.func_177977_b())) {
            PrimalAPI.logger(5, "schedule", "@" + pos + ", AbstractPlantGrowing#removedByPlayer");
            PrimalAPI.scheduleBlock(world, pos.func_177977_b(), state);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
    }

    @Override
    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return this.getAge(world.func_180495_p(pos)) == 0;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_BUSH;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IPrimalPlants.PLANT_AGE, IPrimalPlants.PLANT_BLOOM});
    }

    public IBlockState func_176203_a(int meta) {
        boolean bloom = (meta & 8) > 0;
        int age = bloom ? meta - 8 : meta;
        return this.func_176223_P().func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(age)).func_177226_a((IProperty)IPrimalPlants.PLANT_BLOOM, (Comparable)Boolean.valueOf(bloom));
    }

    public int func_176201_c(IBlockState state) {
        int meta = this.getAge(state);
        if (this.isBlooming(state)) {
            meta |= 8;
        }
        return meta;
    }

    public void debugAges(World world, BlockPos pos, IBlockState state, int max_age) {
        int age = this.getAge(state);
        if (age < max_age) {
            state = state.func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(age + 1));
            world.func_180501_a(pos, state, 2);
        } else {
            state = state.func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(0));
            world.func_180501_a(pos, state, 2);
        }
    }
}

