/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.ores;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.ores.AbstractOre;

public class Zinc
extends AbstractOre {
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);

    public Zinc() {
        super(Material.field_151576_e, SoundType.field_185851_d, "pickaxe", 1);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return PrimalAPI.Items.ORE_CLUSTER_ZINC;
    }

    @Override
    public ItemStack getSecondaryItem(IBlockState state, Random rand, int fortune) {
        switch ((Type)((Object)state.func_177229_b(TYPE))) {
            case NETHER: {
                return new ItemStack(PrimalAPI.Items.ROCK_NETHERRACK);
            }
            case END: {
                return new ItemStack(PrimalAPI.Items.ROCK_END);
            }
        }
        return new ItemStack(PrimalAPI.Items.CARBONATE_SLACK);
    }

    @Override
    public int func_149745_a(Random random) {
        return RANDOM.nextInt(2, 6);
    }

    @Override
    public int quantitySecondary(Random random) {
        return RANDOM.nextInt(1, 4);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (Type blocks$enumtype : Type.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blocks$enumtype.getMetadata()));
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.byMetadata(placer.func_184586_b(hand).func_77952_i())));
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(TYPE))).getMapColor();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(TYPE))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return ((Type)((Object)world.func_180495_p(pos).func_177229_b(TYPE))).getHardness() / 5.0f;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    public static enum Type implements IStringSerializable
    {
        CARBONATE("carbonate", MapColor.field_193561_M, PrimalAPI.Items.CARBONATE_SLACK, 3.0f, 10.0f),
        NETHER("nether", MapColor.field_151655_K, PrimalAPI.Items.ROCK_NETHERRACK, 0.6f, 2.0f),
        END("end", MapColor.field_151658_d, PrimalAPI.Items.ROCK_END, 3.0f, 15.0f);

        private static final Type[] META_LOOKUP;
        private final String name;
        private final MapColor mapColor;
        private final Item slag;
        private final float hardness;
        private final float resistance;

        private Type(String name, MapColor mapColor, Item slag, float hardness, float resistance) {
            this.name = name;
            this.mapColor = mapColor;
            this.slag = slag;
            this.hardness = hardness;
            this.resistance = resistance;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public Item getSlag() {
            return this.slag;
        }

        public float getHardness() {
            return this.hardness;
        }

        public float getResistance() {
            return this.resistance;
        }

        public int getMetadata() {
            return this.ordinal();
        }

        public static Type byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type blocks$enumtype;
                Type.META_LOOKUP[blocks$enumtype.getMetadata()] = blocks$enumtype = typeArray[i];
            }
        }
    }
}

