/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.IInflictedDamage;
import nmd.primal.core.common.blocks.AbstractBlock;
import nmd.primal.core.common.helper.DamageHelper;
import nmd.primal.core.common.helper.FireHelper;

public class PitFall
extends AbstractBlock
implements IFace,
IInflictedDamage {
    public PitFall() {
        super(Material.field_151573_f);
        this.func_149711_c(20.0f);
        this.func_149752_b(50.0f);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)EnumFacing.UP));
    }

    public DamageSource getDamageSource(EntityLivingBase target) {
        return DamageHelper.PITFALL;
    }

    public boolean shouldDamage(World world, BlockPos pos, EntityLivingBase target) {
        return target.func_184222_aU() && (this.getSupportBlock(world, pos).func_185904_a() != Material.field_151580_n || target.func_110143_aJ() > 0.5f);
    }

    public IBlockState getSupportBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177972_a(this.getFacing(world.func_180495_p(pos)).func_176734_d()));
    }

    public float getCollisionDamage(World world, BlockPos pos) {
        float base = 0.5f;
        return this.getSupportBlock(world, pos).func_185904_a() == Material.field_151580_n ? base : (float)RANDOM.nextDouble(1.5, 3.5) + base;
    }

    public float getFallDamage(World world, BlockPos pos, float fallDistance) {
        return this.getSupportBlock(world, pos).func_185904_a() == Material.field_151580_n ? 0.5f : 6.5f * fallDistance;
    }

    @Override
    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)IFace.FACING_FULL);
    }

    @Override
    public boolean shouldDamage(World world, BlockPos pos) {
        return true;
    }

    @Override
    public DamageSource getSource(World world, BlockPos pos) {
        return DamageHelper.PITFALL;
    }

    @Override
    public float getDamage(World world, BlockPos pos) {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"tooltip.info.primal.pitfall_falldamage"));
        tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"tooltip.info.primal.pitfall_collision"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_environment"));
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return false;
    }

    @Override
    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.WALKABLE;
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING_FULL);
        switch (facing) {
            case NORTH: {
                return new AxisAlignedBB(0.0625, 0.0625, 0.9375, 0.9375, 0.9375, 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 0.0625);
            }
            case EAST: {
                return new AxisAlignedBB(0.0, 0.0625, 0.0625, 0.0625, 0.9375, 0.9375);
            }
            case WEST: {
                return new AxisAlignedBB(0.9375, 0.0625, 0.0625, 1.0, 0.9375, 0.9375);
            }
            case DOWN: {
                return new AxisAlignedBB(0.0625, 0.9375, 0.0625, 0.9375, 1.0, 0.9375);
            }
        }
        return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING_FULL);
        switch (facing) {
            case NORTH: {
                return new AxisAlignedBB(0.0625, 0.0625, 0.675, 0.9375, 0.9375, 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 0.325);
            }
            case EAST: {
                return new AxisAlignedBB(0.0, 0.0625, 0.0625, 0.325, 0.9375, 0.9375);
            }
            case WEST: {
                return new AxisAlignedBB(0.675, 0.0625, 0.0625, 1.0, 0.9375, 0.9375);
            }
            case DOWN: {
                return new AxisAlignedBB(0.0625, 0.675, 0.0625, 0.9375, 1.0, 0.9375);
            }
        }
        return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.325, 0.9375);
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        if (entity != null && !(entity instanceof EntityItem)) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, p_185477_7_);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (entity instanceof EntityLivingBase && this.shouldDamage(world, pos, (EntityLivingBase)entity)) {
            PrimalAPI.logger(12, "pitfall", "distance: " + fallDistance + ", amount: " + 6.5f * fallDistance);
            this.playSoundFall(world, pos);
            entity.func_70097_a(this.getDamageSource((EntityLivingBase)entity), this.getFallDamage(world, pos, fallDistance));
        }
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase && this.shouldDamage(world, pos, (EntityLivingBase)entity)) {
            entity.func_70097_a(this.getDamageSource((EntityLivingBase)entity), this.getCollisionDamage(world, pos));
            if (PrimalAPI.randomCheck(8) && FireHelper.hasDirectHeat(world, pos, this.getFacing(state).func_176734_d())) {
                entity.func_70015_d(4);
            }
        }
        super.func_180634_a(world, pos, state, entity);
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return true;
    }

    private void playSoundFall(World world, BlockPos pos) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_SPIKES_FALL, SoundCategory.BLOCKS, 1.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return PitFall.canPlaceBlock(world, pos, face.func_176734_d()) ? this.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)face) : this.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)EnumFacing.DOWN);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return PitFall.canPlaceBlock(world, pos, side.func_176734_d());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!PitFall.canPlaceBlock(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private static boolean canPlaceBlock(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(blockpos);
        return state.isSideSolid((IBlockAccess)world, pos, facing.func_176734_d()) || state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IFace.FACING_FULL});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing;
        switch (meta & 7) {
            case 0: {
                enumfacing = EnumFacing.DOWN;
                break;
            }
            case 1: {
                enumfacing = EnumFacing.EAST;
                break;
            }
            case 2: {
                enumfacing = EnumFacing.WEST;
                break;
            }
            case 3: {
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                enumfacing = EnumFacing.NORTH;
                break;
            }
            default: {
                enumfacing = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING_FULL, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        int i;
        switch ((EnumFacing)state.func_177229_b((IProperty)IFace.FACING_FULL)) {
            case EAST: {
                i = 1;
                break;
            }
            case WEST: {
                i = 2;
                break;
            }
            case SOUTH: {
                i = 3;
                break;
            }
            case NORTH: {
                i = 4;
                break;
            }
            default: {
                i = 5;
                break;
            }
            case DOWN: {
                i = 0;
            }
        }
        return i;
    }
}

