/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.blocks.AbstractBlockType;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.tile.DryingRecipe;
import nmd.primal.core.common.tiles.machines.TileDryingRack;

public class DryingRack
extends AbstractBlockType<TileDryingRack>
implements ITypeWood,
IFace,
ISchedule {
    public DryingRack() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149713_g(0);
        this.func_149711_c(0.5f);
        this.func_149752_b(0.0f);
        this.setHarvestLevel("axe", 0);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileDryingRack();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.drying_rack_crafting"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_environment"));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_DRYING_RACK;
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && !tile.func_145837_r() && tile instanceof TileDryingRack && ((TileDryingRack)tile).hasCraftingItems();
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return false;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt((int)Math.floor((float)ModConfig.Machines.DRYING_RACK_TICK_RATE * 0.75f), ModConfig.Machines.DRYING_RACK_TICK_RATE);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r() || !(tile instanceof TileDryingRack)) {
            return;
        }
        PrimalAPI.logger(21, "scheduled update", "drying rack");
        ((TileDryingRack)tile).dryItems(world, pos);
        this.scheduleUpdate(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileDryingRack tile = (TileDryingRack)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        if (face != EnumFacing.UP) {
            return false;
        }
        ItemStack held_stack = player.func_184614_ca();
        int slot = this.getSlot(state, hitX, hitY, hitZ);
        if (slot > -1) {
            ItemStackHandler handler = tile.getCraftingHandler();
            ItemStack shelf_stack = handler.getStackInSlot(slot);
            if (!shelf_stack.func_190926_b()) {
                int stack_size;
                int n = stack_size = player.func_70093_af() ? shelf_stack.func_190916_E() : 1;
                if (stack_size > 0) {
                    ItemStack take_stack = handler.extractItem(slot, stack_size, false);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)take_stack.func_77946_l());
                }
                tile.resetSlotCount(slot);
            } else {
                DryingRecipe recipe = tile.matchRecipe(held_stack);
                if (recipe != null && !recipe.isDisabled() && CommonUtils.addStack(handler, player, held_stack, slot)) {
                    SoundType soundtype = held_stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)held_stack.func_77973_b()).func_179223_d().func_185467_w() : SoundType.field_185848_a;
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                }
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    private int getSlot(IBlockState state, float hitX, float hitY, float hitZ) {
        return this.getHorizontalRackIndex(state, hitX, hitZ) + this.getVerticalRackIndex(state, hitX, hitZ);
    }

    private int getHorizontalRackIndex(IBlockState state, float hitX, float hitZ) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return hitZ < 0.5f ? 0 : 2;
            }
            case EAST: {
                return hitX > 0.5f ? 0 : 2;
            }
            case SOUTH: {
                return hitZ > 0.5f ? 0 : 2;
            }
            case WEST: {
                return hitX < 0.5f ? 0 : 2;
            }
        }
        return -10;
    }

    private int getVerticalRackIndex(IBlockState state, float hitX, float hitZ) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return hitX < 0.5f ? 0 : 1;
            }
            case EAST: {
                return hitZ < 0.5f ? 0 : 1;
            }
            case SOUTH: {
                return hitX > 0.5f ? 0 : 1;
            }
            case WEST: {
                return hitZ > 0.5f ? 0 : 1;
            }
        }
        return -10;
    }

    @Override
    public void dropItemsAndBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileDryingRack) {
            float offset = 0.7f;
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileDryingRack)tile).getCraftingHandler());
            PlayerHelper.spawnItemOnGround(world, pos, this.func_185473_a(world, pos, state));
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileDryingRack tile = (TileDryingRack)world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r()) {
            tile.setRotation((byte)placer.func_174811_aO().func_176736_b());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ITypeWood.EnumType blocks$enumtype : ITypeWood.EnumType.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, blocks$enumtype.getMetadata());
            NBTHelper.setString(stack, "type", blocks$enumtype.func_176610_l());
            list.add((Object)stack);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            ItemStack stack = new ItemStack((Block)this, 1, ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getMetadata());
            NBTHelper.setString(stack, "type", ((ITypeNBT)tile).getType());
            return stack;
        }
        return super.func_185473_a(world, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)this.getHorizontalFacingFromIndex(this.getFacingIndexFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return this.getHorizontalIndexFromState(state);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeWood.EnumType.byName(((ITypeNBT)tile).getType())));
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

