/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.IRotation;
import nmd.primal.core.api.interfaces.types.IType;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.blocks.AbstractContainer;
import nmd.primal.core.common.helper.NBTHelper;

public abstract class AbstractBlockType<TILE extends TileEntity>
extends AbstractContainer<TILE>
implements IType {
    public AbstractBlockType(Material material) {
        super(material);
        this.func_149713_g(1);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r()) {
            if (tile instanceof ITypeNBT) {
                ((ITypeNBT)tile).setType(NBTHelper.getString(stack, "type"));
            }
            if (tile instanceof IRotation) {
                ((IRotation)tile).setRotation((byte)placer.func_174811_aO().func_176736_b());
            }
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.getTypeHardness((IBlockAccess)world, pos, state);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getTypeResistance((IBlockAccess)world, pos, world.func_180495_p(pos));
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeFlammability(world, pos, world.func_180495_p(pos)) > 0;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeFlammability(world, pos, world.func_180495_p(pos));
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeEncouragement(world, pos, world.func_180495_p(pos));
    }

    @Override
    public float getTypeHardness(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITypeNBT) {
            return ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getHardness();
        }
        return 0.0f;
    }

    @Override
    public float getTypeResistance(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITypeNBT) {
            return ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getResistance();
        }
        return 0.0f;
    }

    @Override
    public int getTypeFlammability(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITypeNBT) {
            return ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getFlammability();
        }
        return 0;
    }

    @Override
    public int getTypeEncouragement(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITypeNBT) {
            return ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getEncouragement();
        }
        return 0;
    }

    @Override
    public String[] getTypeDictionaryNames(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITypeNBT) {
            return ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getOreNames();
        }
        return new String[0];
    }
}

