/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.common.blocks.AbstractContainer;
import nmd.primal.core.common.tiles.AbstractTile;

public abstract class AbstractBed
extends AbstractContainer<AbstractTile> {
    public static final AxisAlignedBB AABB_NORMAL_BED = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);

    public AbstractBed(Material material, MapColor map_color) {
        super(material, map_color);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT).func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)));
        this.func_149649_H();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_NORMAL_BED;
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, Entity player) {
        return true;
    }

    public static boolean isHead(IBlockState state) {
        return state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD;
    }

    public static boolean isFoot(IBlockState state) {
        return state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT;
    }

    public IBlockState getBedHead(EnumFacing facing) {
        return this.func_176223_P().func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)facing).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD);
    }

    public IBlockState getBedFoot(EnumFacing facing) {
        return this.func_176223_P().func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)facing).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT);
    }

    public static boolean hasRoomForPlayer(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    @Nullable
    public static BlockPos getSafeExitLocation(World worldIn, BlockPos pos, int tries) {
        EnumFacing enumfacing = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - enumfacing.func_82601_c() * l - 1;
            int j1 = k - enumfacing.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    if (!AbstractBed.hasRoomForPlayer(worldIn, blockpos)) continue;
                    if (tries <= 0) {
                        return blockpos;
                    }
                    --tries;
                }
            }
        }
        return null;
    }

    @Nullable
    private EntityPlayer getPlayerInBed(World worldIn, BlockPos pos) {
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            if (!entityplayer.func_70608_bn() || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
    }

    public void func_176216_a(World world, Entity entity) {
        super.func_176216_a(world, entity);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (state.func_177229_b((IProperty)BlockBed.field_176472_a) != BlockBed.EnumPartType.HEAD && (state = world.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)))).func_177230_c() != this) {
            return true;
        }
        WorldProvider.WorldSleepResult sleepResult = world.field_73011_w.canSleepAt(player, pos);
        if (sleepResult != WorldProvider.WorldSleepResult.BED_EXPLODES) {
            EntityPlayer.SleepResult entityplayer$sleepresult;
            if (sleepResult == WorldProvider.WorldSleepResult.DENY) {
                return true;
            }
            if (((Boolean)state.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue()) {
                EntityPlayer entityplayer = this.getPlayerInBed(world, pos);
                if (entityplayer != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]), true);
                    return true;
                }
                state = state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false));
                world.func_180501_a(pos, state, 4);
            }
            if ((entityplayer$sleepresult = player.func_180469_a(pos)) == EntityPlayer.SleepResult.OK) {
                state = state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(true));
                world.func_180501_a(pos, state, 4);
                return true;
            }
            if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_SAFE) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.TOO_FAR_AWAY) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.tooFarAway", new Object[0]), true);
            }
            return true;
        }
        world.func_175698_g(pos);
        BlockPos blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176734_d());
        if (world.func_180495_p(blockpos).func_177230_c() == this) {
            world.func_175698_g(blockpos);
        }
        world.func_72885_a((Entity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, true);
        return true;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return AbstractBed.isFoot(state) ? Items.field_190931_a : Items.field_151104_aV;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        BlockPos blockpos = pos;
        if (AbstractBed.isFoot(state)) {
            blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D));
        }
        EnumDyeColor enumdyecolor = (tileentity = worldIn.func_175625_s(blockpos)) instanceof TileEntityBed ? ((TileEntityBed)tileentity).func_193048_a() : EnumDyeColor.RED;
        return new ItemStack(Items.field_151104_aV, 1, enumdyecolor.func_176765_a());
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        if (AbstractBed.isFoot(state)) {
            if (world.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
                world.func_175698_g(pos);
            }
        } else if (world.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
            if (!world.field_72995_K) {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos;
        if (player.field_71075_bZ.field_75098_d && AbstractBed.isFoot(state) && world.func_180495_p(blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D))).func_177230_c() == this) {
            world.func_175698_g(blockpos);
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (AbstractBed.isHead(state) && te instanceof TileEntityBed) {
            TileEntityBed tileentitybed = (TileEntityBed)te;
            ItemStack itemstack = tileentitybed.func_193049_f();
            AbstractBed.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(world, player, pos, state, (TileEntity)null, stack);
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (AbstractBed.isHead(state)) {
            TileEntity tile = world.func_175625_s(pos);
            EnumDyeColor enumdyecolor = tile instanceof TileEntityBed ? ((TileEntityBed)tile).func_193048_a() : EnumDyeColor.RED;
            AbstractBed.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151104_aV, 1, enumdyecolor.func_176765_a()));
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileentity;
        if (AbstractBed.isFoot(state) && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityBed) {
            EnumDyeColor enumdyecolor = ((TileEntityBed)tileentity).func_193048_a();
            return MapColor.func_193558_a((EnumDyeColor)enumdyecolor);
        }
        return MapColor.field_151659_e;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isHeadPiece(int metadata) {
        return (metadata & 8) != 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D, BlockBed.field_176472_a, BlockBed.field_176471_b});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate;
        if (AbstractBed.isFoot(state) && (iblockstate = worldIn.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)))).func_177230_c() == this) {
            state = state.func_177226_a((IProperty)BlockBed.field_176471_b, iblockstate.func_177229_b((IProperty)BlockBed.field_176471_b));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b();
        if (AbstractBed.isHead(state)) {
            i |= 8;
            if (((Boolean)state.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)enumfacing).func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf((meta & 4) > 0)) : this.func_176223_P().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)));
    }
}

