/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.client.render.tiles;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.client.render.tiles.AbstractTESR;
import nmd.primal.core.client.render.tiles.TileRenderHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.tiles.machines.TileWorkTableShelf;

@SideOnly(value=Side.CLIENT)
public class RenderWorkTableShelf
extends AbstractTESR<TileWorkTableShelf> {
    @Override
    public boolean shouldRender(TileWorkTableShelf tile, World world, BlockPos pos, IBlockState state) {
        return tile.getStorageHandler() != null && tile.getCraftingHandler() != null;
    }

    @Override
    public void renderTile(TileWorkTableShelf tile, World world, BlockPos pos, IBlockState state, double x, double y, double z, float partialTicks, int destroyStage) {
        float rotation;
        boolean is_block;
        ItemStack stack;
        TileRenderHelper.initRenderAndRotate(state, x, y + 0.375, z);
        if (world.func_180495_p(pos).func_185894_c((IBlockAccess)world, pos, EnumFacing.UP) && ModConfig.Development.ENABLE_WORKTABLE_RENDERING) {
            for (int craft_column = 0; craft_column < 3; ++craft_column) {
                for (int craft_row = 0; craft_row < 3; ++craft_row) {
                    stack = tile.getCraftingHandler().getStackInSlot(craft_row * 3 + craft_column);
                    if (stack.func_190926_b()) continue;
                    is_block = stack.func_77973_b() instanceof ItemBlock;
                    rotation = is_block ? 180.0f : 90.0f;
                    float height = is_block ? 0.75f : 0.52f;
                    TileRenderHelper.renderItemWeird(world, this.renderItem, stack, rotation, 0.5f, (float)craft_column * 0.75f, (float)craft_row * 0.75f, height, 0.25f);
                }
            }
        }
        if (world.func_180495_p(pos).func_185894_c((IBlockAccess)world, pos, ((EnumFacing)state.func_177229_b((IProperty)IFace.FACING)).func_176734_d())) {
            for (int shelf_column = 0; shelf_column < 2; ++shelf_column) {
                for (int shelf_row = 0; shelf_row < 2; ++shelf_row) {
                    stack = tile.getStorageHandler().getStackInSlot(shelf_row * 2 + shelf_column);
                    if (stack.func_190926_b()) continue;
                    is_block = stack.func_77973_b() instanceof ItemBlock;
                    rotation = 180.0f;
                    float scale = is_block ? 0.8f : 1.2f;
                    float row_height = shelf_row == 0 ? -0.84f : -2.6f;
                    float row_offset = shelf_row == 0 ? 0.0f : 0.2f;
                    float ht_adjust = is_block ? 0.0f : 0.2f;
                    TileRenderHelper.renderItemWeird(world, this.renderItem, stack, rotation, scale, (float)shelf_column * 1.5f, row_offset, row_height + ht_adjust, 2.0f);
                }
            }
        }
    }
}

