/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.client.render.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import nmd.primal.core.client.render.tiles.AbstractTESR;
import nmd.primal.core.common.tiles.machines.TileCauldron;

public class RenderCauldron
extends AbstractTESR<TileCauldron> {
    @Override
    public boolean shouldRender(TileCauldron tile, World world, BlockPos pos, IBlockState state) {
        return !tile.isCovered() && tile.hasFluid();
    }

    @Override
    public void renderTile(TileCauldron tile, World world, BlockPos pos, IBlockState state, double x, double y, double z, float partialTicks, int destroyStage) {
        FluidStack fluid = tile.getContainedFluid();
        if (fluid != null) {
            Double[][] shape;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            ResourceLocation stillLocation = fluid.getFluid().getStill(fluid);
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(stillLocation.toString());
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            double level = (3.5 + (double)fluid.amount * 4.0 / (double)tile.getTank().getCapacity()) / 10.0;
            int c = fluid.getFluid().getColor(fluid);
            int b = c & 0xFF;
            int g = c >> 8 & 0xFF;
            int r = c >> 16 & 0xFF;
            int a = c >> 24 & 0xFF;
            for (Double[] item : shape = new Double[][]{{4.0, 4.0, 6.0, 12.0}, {6.0, 4.0, 10.0, 12.0}, {10.0, 4.0, 12.0, 12.0}}) {
                Double xx1 = item[0];
                Double xx2 = item[2];
                Double zz1 = item[1];
                Double zz2 = item[3];
                Double x1 = xx1 / 16.0;
                Double x2 = xx2 / 16.0;
                Double z1 = zz1 / 16.0;
                Double z2 = zz2 / 16.0;
                buffer.func_181662_b(x1.doubleValue(), level, z1.doubleValue()).func_187315_a((double)sprite.func_94214_a(xx1.doubleValue()), (double)sprite.func_94207_b(zz1.doubleValue())).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(x1.doubleValue(), level, z2.doubleValue()).func_187315_a((double)sprite.func_94214_a(xx1.doubleValue()), (double)sprite.func_94207_b(zz2.doubleValue())).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(x2.doubleValue(), level, z2.doubleValue()).func_187315_a((double)sprite.func_94214_a(xx2.doubleValue()), (double)sprite.func_94207_b(zz2.doubleValue())).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(x2.doubleValue(), level, z1.doubleValue()).func_187315_a((double)sprite.func_94214_a(xx2.doubleValue()), (double)sprite.func_94207_b(zz1.doubleValue())).func_181669_b(r, g, b, a).func_181675_d();
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179140_f();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

