/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.interfaces.plants;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import nmd.primal.core.api.PrimalAPI;

public interface IPrimalPlants
extends IPlantable {
    public static final PropertyInteger PLANT_AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static final PropertyBool PLANT_BLOOM = PropertyBool.func_177716_a((String)"bloom");

    public ItemStack getStalk(IBlockState var1);

    public ItemStack getSeed(IBlockState var1);

    public ItemStack getCrop(IBlockState var1);

    public int getMaxHeight();

    default public int getCurrentHeight(World world, BlockPos pos) {
        int iteration = 1;
        while (world.func_180495_p(pos.func_177979_c(iteration)).func_177230_c() == this) {
            ++iteration;
        }
        return iteration;
    }

    default public IBlockState getSoil(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b());
    }

    default public IBlockState getRoof(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a());
    }

    default public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        return world.isSideSolid(pos, EnumFacing.UP, true);
    }

    public boolean isMature(IBlockState var1);

    public boolean isBlooming(IBlockState var1);

    public boolean canBloom(World var1, BlockPos var2, IBlockState var3);

    public void updatePlant(World var1, BlockPos var2, IBlockState var3, Random var4, int var5);

    public void growFullPlant(World var1, BlockPos var2, IBlockState var3, int var4);

    public float getGrowChance(World var1, BlockPos var2, IBlockState var3);

    public float getBloomChance(World var1, BlockPos var2, IBlockState var3);

    default public int getAge(IBlockState state) {
        return state.func_177230_c() instanceof IPrimalPlants ? (Integer)state.func_177229_b((IProperty)PLANT_AGE) : 0;
    }

    default public IBlockState getAgedPlant(IBlockState state, int age) {
        return state.func_177226_a((IProperty)PLANT_AGE, (Comparable)Integer.valueOf(age));
    }

    default public IBlockState increaseAge(IBlockState state, int amount) {
        return (Integer)state.func_177229_b((IProperty)PLANT_AGE) < 7 ? state.func_177226_a((IProperty)PLANT_AGE, (Comparable)Integer.valueOf(this.getAge(state) + amount)) : state;
    }

    default public IBlockState decreaseAge(IBlockState state, int amount) {
        return (Integer)state.func_177229_b((IProperty)PLANT_AGE) > 0 ? state.func_177226_a((IProperty)PLANT_AGE, (Comparable)Integer.valueOf(this.getAge(state) - amount)) : state;
    }

    default public IBlockState getBloomingPlant(IBlockState state, int age, boolean bloom) {
        return state.func_177226_a((IProperty)PLANT_AGE, (Comparable)Integer.valueOf(age)).func_177226_a((IProperty)PLANT_BLOOM, (Comparable)Boolean.valueOf(bloom));
    }

    default public boolean bloomPlant(World world, BlockPos pos, IBlockState state, Random rand, boolean useModifier) {
        return (PrimalAPI.randomCheck(this.getBloomChance(world, pos, state)) || !useModifier) && world.func_180501_a(pos, state.func_177231_a((IProperty)PLANT_BLOOM), 2);
    }

    default public boolean growPlant(World world, BlockPos pos, IBlockState state, Random rand, int age_amount, int next_age, boolean useModifer) {
        if (!PrimalAPI.randomCheck(this.getGrowChance(world, pos, state)) && useModifer) {
            return false;
        }
        if (next_age > 0 && !world.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        if (age_amount > 0) {
            world.func_180501_a(pos, this.increaseAge(state, age_amount), 2);
        }
        if (next_age > 0) {
            world.func_180501_a(pos.func_177984_a(), this.getAgedPlant(state, next_age), 2);
        }
        return true;
    }

    public EnumType getType(IBlockState var1);

    public static enum EnumType implements IStringSerializable
    {
        NORMAL("normal"),
        WATER("water"),
        LAVA("lava"),
        NETHER("nether"),
        VOID("void"),
        DARK("dark"),
        UNKNOWN("unknown");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

