/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.interfaces;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHangingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.LitTorch;

public interface IPickup {
    default public boolean canPickup(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    default public boolean canPickupItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            return !(item instanceof ItemBlock) && !(item instanceof LitTorch) && !(item instanceof ItemHangingEntity) && !CommonUtils.matchItemList(ModConfig.Compatibility.BLACKLIST_BLOCK_PICKUP, stack);
        }
        return true;
    }

    default public IBlockState getReplacementBlock(World world, BlockPos pos, IBlockState state) {
        return Blocks.field_150350_a.func_176223_P();
    }

    default public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175656_a(pos, this.getReplacementBlock(world, pos, state))) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Item.func_150898_a((Block)state.func_177230_c())));
            return true;
        }
        return false;
    }

    public static boolean doStrangePickup(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing face, ItemStack pickup) {
        if (world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P())) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)pickup);
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }
}

