/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.events;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import nmd.primal.core.common.recipes.tile.SmelterRecipe;
import nmd.primal.core.common.tiles.machines.TileSmelter;

public class SmelterEvent
extends Event {
    private final TileSmelter tile;

    protected SmelterEvent(TileSmelter tile) {
        this.tile = tile;
    }

    public TileSmelter getTile() {
        return this.tile;
    }

    public World getWorld() {
        return this.tile.func_145831_w();
    }

    public BlockPos getPos() {
        return this.tile.func_174877_v();
    }

    public int getCounter() {
        return this.getTile().getCounter();
    }

    @Cancelable
    public static class Close
    extends SmelterEvent {
        private final EntityPlayer player;
        private final SmelterRecipe recipe;

        public Close(TileSmelter tile, EntityPlayer player, @Nullable SmelterRecipe recipe) {
            super(tile);
            this.player = player;
            this.recipe = recipe;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public SmelterRecipe getRecipe() {
            return this.recipe;
        }
    }

    @Cancelable
    public static class Open
    extends SmelterEvent {
        private final EntityPlayer player;

        public Open(TileSmelter tile, EntityPlayer player) {
            super(tile);
            this.player = player;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }
    }

    @Cancelable
    public static class Check
    extends SmelterEvent {
        private final EntityPlayer player;

        public Check(TileSmelter tile, EntityPlayer player) {
            super(tile);
            this.player = player;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }
    }

    @Cancelable
    public static class Update
    extends SmelterEvent {
        private final SmelterRecipe current_recipe;
        private final boolean is_lit;

        public Update(TileSmelter tile, SmelterRecipe current_recipe, boolean is_lit) {
            super(tile);
            this.current_recipe = current_recipe;
            this.is_lit = is_lit;
        }

        public SmelterRecipe getCurrentRecipe() {
            return this.current_recipe;
        }

        public boolean isLit() {
            return this.is_lit;
        }
    }

    public static class Collide
    extends SmelterEvent {
        private final EntityLivingBase entity;

        public Collide(TileSmelter tile, EntityLivingBase entity) {
            super(tile);
            this.entity = entity;
        }

        public EntityLivingBase getEntity() {
            return this.entity;
        }
    }
}

