/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.events;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import nmd.primal.core.common.tiles.machines.TileBarrel;

public class BarrelEvent
extends Event {
    private final TileBarrel tile;

    protected BarrelEvent(TileBarrel barrel) {
        this.tile = barrel;
    }

    public TileBarrel getTile() {
        return this.tile;
    }

    public World getWorld() {
        return this.tile.func_145831_w();
    }

    public BlockPos getPos() {
        return this.tile.func_174877_v();
    }

    public FluidTank getTank() {
        return this.tile.getTank();
    }

    @Cancelable
    public static class Close
    extends BarrelEvent {
        private final EntityPlayer player;

        public Close(TileBarrel tile, EntityPlayer player) {
            super(tile);
            this.player = player;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }
    }

    @Cancelable
    public static class Open
    extends BarrelEvent {
        private final EntityPlayer player;

        public Open(TileBarrel tile, EntityPlayer player) {
            super(tile);
            this.player = player;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }
    }

    @Cancelable
    public static class Quench
    extends BarrelEvent {
        private final Entity entity;
        private final FluidStack fluidStack;
        private final Material material;

        public Quench(TileBarrel tile, Entity entity, FluidStack fluidStack, Material material) {
            super(tile);
            this.entity = entity;
            this.fluidStack = fluidStack;
            this.material = material;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public FluidStack getFluidStack() {
            return this.fluidStack;
        }

        public Material getMaterial() {
            return this.material;
        }

        public int getTemperature() {
            return this.fluidStack.getFluid().getTemperature(this.fluidStack);
        }
    }

    @Cancelable
    public static class Update
    extends BarrelEvent {
        public Update(TileBarrel tile) {
            super(tile);
        }
    }
}

