/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import nmd.primal.core.api.enums.EnumBasicFluid;
import nmd.primal.core.api.enums.EnumMoisture;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.materials.MaterialBitumen;
import nmd.primal.core.api.materials.MaterialGas;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.fluids.PrimalBucket;
import nmd.primal.core.common.fluids.custom.BitumenFluid;
import nmd.primal.core.common.fluids.custom.ParaffinFluid;
import nmd.primal.core.common.init.ModConfig;

public class PrimalAPI {
    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static boolean randomCheck(ThreadLocalRandom rand, int bound) {
        return bound == 0 || rand.nextInt(bound) == 0;
    }

    public static boolean randomCheck(int bound) {
        return bound == 0 || PrimalAPI.getRandom().nextInt(bound) == 0;
    }

    public static boolean randomCheck(float bound) {
        return PrimalAPI.getRandom().nextFloat() < bound;
    }

    public static boolean randomCheck(double bound) {
        return PrimalAPI.randomCheck((float)bound);
    }

    public static boolean randomCheckFail(int bound) {
        return bound > 0 && PrimalAPI.getRandom().nextInt(bound) == 0;
    }

    public static int randomChanceReturn(int bound, int output1, int output2) {
        return PrimalAPI.randomCheck(bound) ? output2 : output1;
    }

    public static void useStack(EntityPlayer player, ItemStack stack) {
        stack.func_190918_g(1);
        if (stack.func_190916_E() == 0) {
            player.field_71071_by.func_184437_d(stack);
        }
    }

    public static void scheduleBlock(World world, BlockPos pos, IBlockState state, int delay) {
        Block block = state.func_177230_c();
        if (block instanceof ISchedule && !world.func_184145_b(pos, block) && ((ISchedule)block).shouldSchedule(world, pos, state)) {
            world.func_175684_a(pos, block, delay > 0 ? delay : ((ISchedule)block).scheduledTicks(world, pos, state));
        }
    }

    public static void scheduleBlock(World world, BlockPos pos, IBlockState state) {
        PrimalAPI.scheduleBlock(world, pos, state, 0);
    }

    public static boolean placeScheduledBlock(World world, BlockPos pos, IBlockState state, int flag) {
        if (!world.field_72995_K && world.func_180501_a(pos, state, flag)) {
            Block newBlock = world.func_180495_p(pos).func_177230_c();
            if (newBlock instanceof ISchedule && ((ISchedule)newBlock).shouldScheduleOnPlacement()) {
                PrimalAPI.logger(5, "schedule", world.field_73011_w.getDimension() + "@" + pos + ", placeScheduledBlock");
                PrimalAPI.scheduleBlock(world, pos, state);
            }
            return true;
        }
        return false;
    }

    public static void logger(int filter, String title, String text) {
        if (ModConfig.Development.LOG_FILTER.length > 0 && (Arrays.asList(ModConfig.Development.LOG_FILTER).contains(filter) || filter == 0)) {
            String class_name = System.getSecurityManager().getClass().getName();
            PrimalCore.LOGGER.info(title + ": " + text);
        }
    }

    public static void logger(int filter, String text) {
        if (ModConfig.Development.LOG_FILTER.length > 0 && (Arrays.asList(ModConfig.Development.LOG_FILTER).contains(filter) || filter == 0)) {
            PrimalCore.LOGGER.info(text);
        }
    }

    public static class Predicates {
        public static List<String> LOG_HARVEST_NAMES = new ArrayList<String>();
        public static List<Material> FIRE_HEAT_SOURCE_MATERIALS = new ArrayList<Material>();
        public static List<Block> TELEPORT_INTERDICTION_BLOCKS = new ArrayList<Block>();
        public static List<Block> DESPAWN_INTERDICTION_BLOCKS = new ArrayList<Block>();
        public static Predicate<IBlockState> COOLING_SOURCE;
        public static Predicate<IBlockState> FIRE_HEAT_SOURCE;
        public static Predicate<IBlockState> TELEPORT_INTERDICTION;
        public static Predicate<IBlockState> DESPAWN_INTERDICTION;
        public static Predicate<IBlockState> SPREAD_INTERDICTION;
        public static Predicate<IBlockState> SPREAD_RESISTANT;
        public static Predicate<IBlockState> STABILIZING_BLOCKS;
        public static Predicate<IBlockState> INSULATING_BLOCKS;
        public static Predicate<IBlockState> SOFT_FALL_BLOCKS;
        public static Predicate<IBlockState> SPREAD_NETHER_GROWTH;
        public static Predicate<IBlockState> SPREAD_NETHER_MYCELIUM;
        public static Predicate<IBlockState> SPREAD_STONE_DESICCATED;
        public static Predicate<IBlockState> SPREAD_MUD;
        public static Predicate<IBlockState> SOIL_NETHER_FARMING;
        public static Predicate<IBlockState> SOIL_NETHER_COMMON;
        public static Predicate<IBlockState> SOIL_SURFACE_COMMON;
        public static Predicate<IBlockState> SOIL_DIRT;
        public static Predicate<IBlockState> FURNACE;
        public static Predicate<IBlockState> LOOTING_2_BLOCKS;
        public static Predicate<IBlockState> LOOTING_3_BLOCKS;
    }

    public static class Registries {
    }

    public static class Bounds {
        public static final AxisAlignedBB AABB_EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        public static final AxisAlignedBB AABB_TALL = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.5, 1.0);
        public static final AxisAlignedBB AABB_SOULSAND = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
        public static final AxisAlignedBB AABB_FARMLAND = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
        public static final AxisAlignedBB AABB_CARPET = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
        public static final AxisAlignedBB AABB_NARROW_CUBE = new AxisAlignedBB(0.26, 0.0, 0.26, 0.74, 1.0, 0.74);
        public static final AxisAlignedBB AABB_BUSH = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);
        public static final AxisAlignedBB AABB_BUSH_LARGE = new AxisAlignedBB(0.25000001192092897, 0.0, 0.25000001192092897, 0.749999988079071, 0.8000000238418579, 0.749999988079071);
        public static final AxisAlignedBB AABB_FLAT_PLANT = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.09375, 0.9375);
        public static final AxisAlignedBB AABB_LADDER_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
        public static final AxisAlignedBB AABB_LADDER_WEST = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_LADDER_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
        public static final AxisAlignedBB AABB_LADDER_NORTH = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_DRYING_RACK = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
        public static final AxisAlignedBB AABB_HIBACHI = new AxisAlignedBB(0.125, 0.1875, 0.125, 0.875, 0.865, 0.875);
        public static final AxisAlignedBB AABB_SMELTER = new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.68, 0.875);
        public static final AxisAlignedBB AABB_POT = new AxisAlignedBB(0.125, 0.2675, 0.125, 0.875, 0.815, 0.875);
        public static final AxisAlignedBB AABB_BRICK_MOLD = new AxisAlignedBB(0.1875, 0.0, 0.125, 0.8125, 0.815, 0.875);
        public static final AxisAlignedBB AABB_WATTLE_NORTH = new AxisAlignedBB(0.0, 0.0, 0.38, 1.0, 1.0, 0.62);
        public static final AxisAlignedBB AABB_WATTLE_EAST = new AxisAlignedBB(0.38, 0.0, 0.0, 0.62, 1.0, 1.0);
        public static final AxisAlignedBB AABB_DAUB_1_NORTH = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 0.75);
        public static final AxisAlignedBB AABB_DAUB_1_EAST = new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 1.0);
        public static final AxisAlignedBB AABB_DAUB_2_NORTH = new AxisAlignedBB(0.0, 0.0, 0.13, 1.0, 1.0, 0.87);
        public static final AxisAlignedBB AABB_DAUB_2_EAST = new AxisAlignedBB(0.13, 0.0, 0.0, 0.87, 1.0, 1.0);
        public static final AxisAlignedBB AABB_DAUB_3_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_DAUB_3_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_FISH_TRAP = new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.5, 0.85);
        public static final AxisAlignedBB AABB_LANTERN_UP = new AxisAlignedBB(0.32, 0.0, 0.32, 0.68, 0.75, 0.68);
        public static final AxisAlignedBB AABB_LANTERN = new AxisAlignedBB(0.32, 0.07, 0.32, 0.68, 0.93, 0.68);
        public static final AxisAlignedBB AABB_SLAT_TOP_FULL = new AxisAlignedBB(0.0, 0.815, 0.0, 1.0, 0.935, 1.0);
        public static final AxisAlignedBB AABB_SLAT_BOTTOM_FULL = new AxisAlignedBB(0.0, 0.065, 0.0, 1.0, 0.185, 1.0);
        public static final AxisAlignedBB AABB_SLAT_TOP_EAST = new AxisAlignedBB(0.0, 0.815, 0.0, 0.875, 0.935, 1.0);
        public static final AxisAlignedBB AABB_SLAT_BOTTOM_EAST = new AxisAlignedBB(0.0, 0.065, 0.0, 0.875, 0.185, 1.0);
        public static final AxisAlignedBB AABB_SLAT_TOP_WEST = new AxisAlignedBB(0.125, 0.815, 0.0, 1.0, 0.935, 1.0);
        public static final AxisAlignedBB AABB_SLAT_BOTTOM_WEST = new AxisAlignedBB(0.125, 0.065, 0.0, 1.0, 0.185, 1.0);
        public static final AxisAlignedBB AABB_SLAT_TOP_NORTH = new AxisAlignedBB(0.0, 0.815, 0.125, 1.0, 0.935, 1.0);
        public static final AxisAlignedBB AABB_SLAT_BOTTOM_NORTH = new AxisAlignedBB(0.0, 0.065, 0.125, 1.0, 0.185, 1.0);
        public static final AxisAlignedBB AABB_SLAT_TOP_SOUTH = new AxisAlignedBB(0.0, 0.815, 0.0, 1.0, 0.935, 0.875);
        public static final AxisAlignedBB AABB_SLAT_BOTTOM_SOUTH = new AxisAlignedBB(0.0, 0.065, 0.0, 1.0, 0.185, 0.875);
        public static final AxisAlignedBB AABB_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        public static final AxisAlignedBB AABB_SLAB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_SLAB_TOP_SHALLOW = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 0.875, 1.0);
        public static final AxisAlignedBB AABB_SLAB_BOTTOM_SHALLOW = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
        public static final AxisAlignedBB AABB_SLAB_VERTICAL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
        public static final AxisAlignedBB AABB_SLAB_VERTICAL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_SLAB_VERTICAL_WEST = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_SLAB_VERTICAL_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
        public static final AxisAlignedBB AABB_THIN_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
        public static final AxisAlignedBB AABB_THIN_SLAB_TOP = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_THIN_LOG = new AxisAlignedBB(0.32, 0.0, 0.32, 0.68, 1.0, 0.68);
        public static final AxisAlignedBB AABB_IGNIS_FATUUS = new AxisAlignedBB(0.5, 0.3, 0.5, 0.6, 0.5, 0.6);
        public static final AxisAlignedBB AABB_STRIPPED_LOG_X = new AxisAlignedBB(0.0, 0.0625, 0.0625, 1.0, 0.9375, 0.9375);
        public static final AxisAlignedBB AABB_STRIPPED_LOG_Z = new AxisAlignedBB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 1.0);
        public static final AxisAlignedBB AABB_STRIPPED_LOG_Y = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
        public static final AxisAlignedBB AABB_LOG_STACK_COLLISION = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.875, 0.875);
        public static final AxisAlignedBB AABB_LOG_STACK = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.982, 0.875);
        public static final AxisAlignedBB AABB_BRICKFORM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
        public static final AxisAlignedBB AABB_BARREL = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
        public static final AxisAlignedBB AABB_THIN_SLAB_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
        public static final AxisAlignedBB AABB_THIN_SLAB_WEST = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_THIN_SLAB_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
        public static final AxisAlignedBB AABB_THIN_SLAB_NORTH = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_PILLAR_LARGE = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
        public static final AxisAlignedBB AABB_PILLAR = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
        public static final AxisAlignedBB AABB_KILN = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
        public static final AxisAlignedBB AABB_SAPLING = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
        public static final AxisAlignedBB[] AABB_CROPS = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
        public static final AxisAlignedBB[] AABB_LAYERS = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    }

    public static class States {
        public static final PropertyBool COVERED = PropertyBool.func_177716_a((String)"covered");
        public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
        public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
        public static final PropertyInteger DENSITY = PropertyInteger.func_177719_a((String)"density", (int)0, (int)7);
        public static final PropertyInteger DAUB = PropertyInteger.func_177719_a((String)"daub", (int)0, (int)3);
        public static final PropertyInteger LAYERS = PropertyInteger.func_177719_a((String)"layers", (int)0, (int)15);
        public static final PropertyInteger CRACKED = PropertyInteger.func_177719_a((String)"layers", (int)0, (int)9);
        public static final PropertyInteger MOISTURE = PropertyInteger.func_177719_a((String)"moisture", (int)0, (int)7);
        public static final PropertyEnum<EnumMoisture> WET_DRY = PropertyEnum.func_177709_a((String)"moisture", EnumMoisture.class);
        public static final PropertyEnum<EnumBasicFluid> BASIC_FLUID = PropertyEnum.func_177709_a((String)"basic_fluid", EnumBasicFluid.class);
    }

    public static enum Particles {
        MUD,
        MUCK,
        MUCK_MOLTEN,
        ROCK,
        SMOKE,
        STEAM,
        SLAG,
        ANCIENT_ICE,
        WATER,
        IGNIS,
        TEST;

    }

    public static class Sounds {
        public static SoundType POTTERY;
        public static SoundType ICE;
        public static SoundType ORGANIC;
        public static SoundType SOULGLASS;
        public static SoundEvent SOUND_OF_SILENCE;
        public static SoundEvent SOUND_BLOCK_CAULDRON_EMPTY;
        public static SoundEvent SOUND_BLOCK_CAULDRON_FILLED;
        public static SoundEvent SOUND_BLOCK_CAULDRON_LID;
        public static SoundEvent SOUND_BLOCK_CAULDRON_ADD;
        public static SoundEvent SOUND_BLOCK_CAULDRON_TAKE;
        public static SoundEvent SOUND_BLOCK_CAULDRON_MATCH;
        public static SoundEvent SOUND_BLOCK_CAULDRON_FINISH;
        public static SoundEvent SOUND_BLOCK_BARREL_EMPTY;
        public static SoundEvent SOUND_BLOCK_BARREL_FILLED;
        public static SoundEvent SOUND_BLOCK_BARREL_LID;
        public static SoundEvent SOUND_BLOCK_POTTERY_LID;
        public static SoundEvent SOUND_BLOCK_POTTERY_HIT;
        public static SoundEvent SOUND_BLOCK_POTTERY_STEP;
        public static SoundEvent SOUND_BLOCK_POTTERY_BREAK;
        public static SoundEvent SOUND_BLOCK_POTTERY_PLACE;
        public static SoundEvent SOUND_BLOCK_POTTERY_ACTIVE;
        public static SoundEvent SOUND_BLOCK_SPIKES_FALL;
        public static SoundEvent SOUND_BLOCK_ICE_FREEZE;
        public static SoundEvent SOUND_BLOCK_ICE_BREAK;
        public static SoundEvent SOUND_BLOCK_ICE_PLACE;
        public static SoundEvent SOUND_BLOCK_OOZE;
        public static SoundEvent SOUND_EFFECT_MAGIC_INHIBIT;
        public static SoundEvent SOUND_MISC_STEAM;
        public static SoundEvent SOUND_MISC_PLACEMENT;
        public static SoundEvent SOUND_CRAFT_FLAKE;
        public static SoundEvent SOUND_TOOL_SAW_WOOD;
        public static SoundEvent SOUND_TOOL_AXE_WOOD;
        public static SoundEvent SOUND_TOOL_BLADE_SCRAPE;
        public static SoundEvent SOUND_FLUID_SWISH;
        public static SoundEvent SOUND_FLUID_SPLASH;
        public static SoundEvent SOUND_ENTITY_OVIS_SAY;
        public static SoundEvent SOUND_ENTITY_OVIS_HURT;
        public static SoundEvent SOUND_ENTITY_OVIS_ANGRY;
        public static SoundEvent SOUND_ENTITY_GATOR_SAY;
        public static SoundEvent SOUND_ENTITY_GATOR_HURT;
        public static SoundEvent SOUND_ENTITY_GATOR_DEATH;
        public static SoundEvent SOUND_ENTITY_WOLF_HOWL;
    }

    public static class BlockMaterials {
        public static final Material ASH = new Material(MapColor.field_151670_w);
        public static final MaterialLiquid SMOKE = new MaterialGas(MapColor.field_151670_w);
        public static final Material BITUMEN = new MaterialBitumen();
    }

    public static class ArmorMaterials {
        public static ItemArmor.ArmorMaterial ARMOR_HIDE = EnumHelper.addArmorMaterial((String)"hide", (String)"", (int)16, (int[])new int[]{2, 3, 4, 2}, (int)15, (SoundEvent)SoundEvents.field_187728_s, (float)0.45f);
        public static ItemArmor.ArmorMaterial ARMOR_HIDE_HARDENED = EnumHelper.addArmorMaterial((String)"hide_boiled", (String)"", (int)24, (int[])new int[]{2, 3, 4, 2}, (int)10, (SoundEvent)SoundEvents.field_187728_s, (float)0.65f);
        public static ItemArmor.ArmorMaterial ARMOR_PADDED = EnumHelper.addArmorMaterial((String)"padded", (String)"", (int)16, (int[])new int[]{1, 2, 2, 1}, (int)5, (SoundEvent)SoundEvents.field_187728_s, (float)0.25f);
        public static ItemArmor.ArmorMaterial ARMOR_BRONZE = EnumHelper.addArmorMaterial((String)"bronze", (String)"", (int)20, (int[])new int[]{2, 4, 5, 2}, (int)12, (SoundEvent)SoundEvents.field_187725_r, (float)1.0f);
        public static ItemArmor.ArmorMaterial ARMOR_WROUGHT_IRON = EnumHelper.addArmorMaterial((String)"wrought_iron", (String)"", (int)25, (int[])new int[]{2, 5, 5, 2}, (int)8, (SoundEvent)SoundEvents.field_187725_r, (float)1.25f);
        public static ItemArmor.ArmorMaterial ARMOR_CLEAN_IRON = EnumHelper.addArmorMaterial((String)"clean_iron", (String)"", (int)30, (int[])new int[]{2, 5, 6, 2}, (int)9, (SoundEvent)SoundEvents.field_187725_r, (float)1.5f);
        public static ItemArmor.ArmorMaterial ARMOR_STEEL = EnumHelper.addArmorMaterial((String)"steel", (String)"", (int)40, (int[])new int[]{3, 6, 6, 3}, (int)10, (SoundEvent)SoundEvents.field_187725_r, (float)2.0f);
        public static ItemArmor.ArmorMaterial ARMOR_DAMASCUS = EnumHelper.addArmorMaterial((String)"damascus", (String)"", (int)45, (int[])new int[]{3, 6, 6, 3}, (int)15, (SoundEvent)SoundEvents.field_187725_r, (float)2.2f);
        public static ItemArmor.ArmorMaterial ARMOR_MITHRIL = EnumHelper.addArmorMaterial((String)"mithril", (String)"", (int)40, (int[])new int[]{3, 7, 7, 4}, (int)25, (SoundEvent)SoundEvents.field_187725_r, (float)4.0f);
        public static ItemArmor.ArmorMaterial ARMOR_DRAGON_SKIN = EnumHelper.addArmorMaterial((String)"dragonskin", (String)"", (int)50, (int[])new int[]{4, 8, 8, 5}, (int)22, (SoundEvent)SoundEvents.field_187713_n, (float)2.6f);
        public static ItemArmor.ArmorMaterial ARMOR_DRAGON_SCALE = EnumHelper.addArmorMaterial((String)"dragonscale", (String)"", (int)70, (int[])new int[]{5, 9, 9, 5}, (int)20, (SoundEvent)SoundEvents.field_187713_n, (float)2.8f);
        public static ItemArmor.ArmorMaterial ARMOR_OBSIDIAN = EnumHelper.addArmorMaterial((String)"obsidian", (String)"", (int)26, (int[])new int[]{2, 4, 6, 3}, (int)18, (SoundEvent)SoundEvents.field_187716_o, (float)2.0f);
        public static ItemArmor.ArmorMaterial ARMOR_FLESH = EnumHelper.addArmorMaterial((String)"flesh", (String)"", (int)20, (int[])new int[]{1, 1, 1, 1}, (int)16, (SoundEvent)SoundEvents.field_187728_s, (float)0.5f);
        public static ItemArmor.ArmorMaterial ARMOR_MUMMIFIED = EnumHelper.addArmorMaterial((String)"mummified", (String)"", (int)30, (int[])new int[]{1, 2, 3, 1}, (int)20, (SoundEvent)SoundEvents.field_187728_s, (float)1.0f);
        public static ItemArmor.ArmorMaterial ARMOR_FRAME = EnumHelper.addArmorMaterial((String)"frame", (String)"", (int)40, (int[])new int[]{1, 1, 2, 1}, (int)0, (SoundEvent)SoundEvents.field_187716_o, (float)2.0f);
        public static ItemArmor.ArmorMaterial ARMOR_SINUOUS = EnumHelper.addArmorMaterial((String)"sinuous", (String)"", (int)60, (int[])new int[]{2, 2, 2, 2}, (int)22, (SoundEvent)SoundEvents.field_187728_s, (float)3.0f);
        public static ItemArmor.ArmorMaterial ARMOR_VITRIFIED = EnumHelper.addArmorMaterial((String)"vitrified", (String)"", (int)80, (int[])new int[]{2, 6, 8, 2}, (int)25, (SoundEvent)SoundEvents.field_187716_o, (float)4.0f);
        public static ItemArmor.ArmorMaterial ARMOR_ADAMANT = EnumHelper.addArmorMaterial((String)"adamant", (String)"", (int)90, (int[])new int[]{4, 6, 8, 5}, (int)0, (SoundEvent)SoundEvents.field_187725_r, (float)4.0f);
        public static ItemArmor.ArmorMaterial ARMOR_SHIBUICHI = EnumHelper.addArmorMaterial((String)"shibuichi", (String)"", (int)50, (int[])new int[]{3, 6, 6, 3}, (int)18, (SoundEvent)SoundEvents.field_187725_r, (float)4.0f);
    }

    public static class ToolMaterials {
        public static Item.ToolMaterial TOOL_YEW = EnumHelper.addToolMaterial((String)"yew", (int)0, (int)600, (float)2.0f, (float)1.0f, (int)16);
        public static Item.ToolMaterial TOOL_IRONWOOD = EnumHelper.addToolMaterial((String)"ironwood", (int)0, (int)600, (float)2.0f, (float)1.0f, (int)18);
        public static Item.ToolMaterial TOOL_CORYPHA = EnumHelper.addToolMaterial((String)"corypha", (int)0, (int)600, (float)2.0f, (float)1.0f, (int)16);
        public static Item.ToolMaterial TOOL_BONE = EnumHelper.addToolMaterial((String)"bone", (int)0, (int)360, (float)2.0f, (float)1.0f, (int)16);
        public static Item.ToolMaterial TOOL_FLINT = EnumHelper.addToolMaterial((String)"flint", (int)ModConfig.Features.FLINT_TOOL_HARVEST_LEVEL, (int)260, (float)4.0f, (float)1.5f, (int)6);
        public static Item.ToolMaterial TOOL_QUARTZ = EnumHelper.addToolMaterial((String)"quartz", (int)ModConfig.Features.QUARTZ_TOOL_HARVEST_LEVEL, (int)360, (float)6.0f, (float)2.0f, (int)12);
        public static Item.ToolMaterial TOOL_OBSIDIAN = EnumHelper.addToolMaterial((String)"obsidian", (int)3, (int)1200, (float)8.5f, (float)2.5f, (int)16);
        public static Item.ToolMaterial TOOL_EMERALD = EnumHelper.addToolMaterial((String)"emerald", (int)3, (int)1561, (float)7.0f, (float)3.0f, (int)8);
        public static Item.ToolMaterial TOOL_OPAL = EnumHelper.addToolMaterial((String)"opal", (int)3, (int)1600, (float)8.0f, (float)4.0f, (int)16);
        public static Item.ToolMaterial TOOL_SILVER = EnumHelper.addToolMaterial((String)"silver", (int)1, (int)400, (float)3.0f, (float)1.5f, (int)16);
        public static Item.ToolMaterial TOOL_COPPER = EnumHelper.addToolMaterial((String)"copper", (int)2, (int)500, (float)4.0f, (float)2.0f, (int)14);
        public static Item.ToolMaterial TOOL_BRONZE = EnumHelper.addToolMaterial((String)"bronze", (int)2, (int)600, (float)5.0f, (float)3.0f, (int)12);
        public static Item.ToolMaterial TOOL_CRUDE_IRON = EnumHelper.addToolMaterial((String)"crude_iron", (int)2, (int)400, (float)4.0f, (float)2.0f, (int)10);
        public static Item.ToolMaterial TOOL_WROUGHT_IRON = EnumHelper.addToolMaterial((String)"wrought_iron", (int)2, (int)500, (float)4.0f, (float)2.0f, (int)0);
        public static Item.ToolMaterial TOOL_CLEAN_IRON = EnumHelper.addToolMaterial((String)"clean_iron", (int)2, (int)700, (float)6.0f, (float)3.0f, (int)0);
        public static Item.ToolMaterial TOOL_BASIC_STEEL = EnumHelper.addToolMaterial((String)"basic_steel", (int)3, (int)900, (float)8.0f, (float)5.0f, (int)0);
        public static Item.ToolMaterial TOOL_WOOTZ_STEEL = EnumHelper.addToolMaterial((String)"wootz_steel", (int)3, (int)1200, (float)8.0f, (float)7.0f, (int)16);
        public static Item.ToolMaterial TOOL_SHIBUICHI = EnumHelper.addToolMaterial((String)"shibuichi", (int)3, (int)1600, (float)8.0f, (float)10.0f, (int)18);
        public static Item.ToolMaterial TOOL_MUMMIFIED = EnumHelper.addToolMaterial((String)"mummified", (int)4, (int)1600, (float)9.0f, (float)2.0f, (int)20);
        public static Item.ToolMaterial TOOL_VITRIFIED = EnumHelper.addToolMaterial((String)"vitrified", (int)6, (int)2400, (float)9.0f, (float)6.0f, (int)25);
        public static Item.ToolMaterial TOOL_ADAMANT = EnumHelper.addToolMaterial((String)"adamant", (int)6, (int)2600, (float)12.0f, (float)8.0f, (int)0);
    }

    public static class Fluids {
        public static final int BOTTLE_VOLUME = 250;
        public static final int BOTTLE_TENTH = 25;
        public static final FluidStack WATER_BUCKET = new FluidStack(FluidRegistry.WATER, 1000);
        public static Fluid SMOKE;
        public static Fluid STEAM;
        public static Fluid RAIN_WATER;
        public static Fluid WASTE;
        public static Fluid TANNIN;
        public static Fluid URUSHI;
        public static Fluid BRINE;
        public static Fluid MAGMA;
        public static Fluid OVIS_ATRE_MILK;
        public static ParaffinFluid PARAFFIN;
        public static BitumenFluid BITUMEN;
        public static BitumenFluid BITUMEN_BOILING;
    }

    public static class Items {
        public static Item TATAMI_BED_ITEM;
        public static Item ACONITE_PETAL;
        public static Item ACONITE_ROOT;
        public static Item ACONITE_SPRIG;
        public static Item ADOBE_BRICK_DRY;
        public static Item ADOBE_CLUMP;
        public static Item ADOBE_BRICK_WET;
        public static Item ANIMAL_FUR;
        public static Item ARROW_GOLD;
        public static Item ARROW_QUARTZ;
        public static Item ARROW_SILVER;
        public static Item ARROW_TORCH_NETHER;
        public static Item ARROW_TORCH_REDSTONE;
        public static Item ARROW_TORCH_WOOD;
        public static Item ARROW_IRONWOOD;
        public static Item ARROW_WATER;
        public static Item ARROW_PARAFFIN;
        public static Item ARROW_BITUMEN;
        public static Item BARK_ACACIA;
        public static Item BARK_DARK_OAK;
        public static Item BARK_BIRCH;
        public static Item BARK_CORYPHA;
        public static Item BARK_IRONWOOD;
        public static Item BARK_JUNGLE;
        public static Item BARK_OAK;
        public static Item BARK_SPRUCE;
        public static Item BARK_YEW;
        public static Item MEAT_COOKED_BAT;
        public static Item MEAT_DRIED_BAT;
        public static Item MEAT_RAW_BAT;
        public static Item MEAT_ROTTEN_BAT;
        public static Item ANIMAL_FAT;
        public static Item ANIMAL_FAT_NETHER;
        public static Item TALLOW;
        public static Item MEAT_COOKED_BEAR;
        public static Item MEAT_DRIED_BEAR;
        public static Item MEAT_RAW_BEAR;
        public static Item MEAT_ROTTEN_BEAR;
        public static Item MEAT_SALTED_BEAR;
        public static Item BOAT_IRONWOOD;
        public static Item BOAT_CORYPHA;
        public static Item BOAT_LACQUER;
        public static Item BOAT_YEW;
        public static Item BONE_FLAKE;
        public static Item BONE_POINT;
        public static Item BONE_HATCHET;
        public static Item BONE_PICKAXE;
        public static Item BONE_SHOVEL;
        public static Item BONE_HOE;
        public static Item BONE_SAW;
        public static Item BONE_SHEARS;
        public static Item BARREL_TRAP;
        public static Item BARREL_LID_OAK;
        public static Item BARREL_LID_SPRUCE;
        public static Item BARREL_LID_BIRCH;
        public static Item BARREL_LID_JUNGLE;
        public static Item BARREL_LID_ACACIA;
        public static Item BARREL_LID_DARK_OAK;
        public static Item BARREL_LID_YEW;
        public static Item BARREL_LID_IRONWOOD;
        public static Item BARREL_LID_CORYPHA;
        public static Item BARREL_LID_LACQUER;
        public static Item WAX_RESIDUE;
        public static Item SOUL_RESIDUE;
        public static Item SLIME_RESIDUE;
        public static Item FERMENTED_JUNGLE;
        public static Item ANCIENT_ICE_CHUNK;
        public static Item BITUMIN_CLUMP;
        public static Item SLAG;
        public static Item CAULDRON_LID;
        public static Item CARBONATE_FERRO_SLACK;
        public static Item CARBONATE_SLACK;
        public static Item CHARCOAL_MOTE;
        public static Item CHARCOAL_FAIR;
        public static Item CHARCOAL_GOOD;
        public static Item CHARCOAL_HIGH;
        public static Item CHARCOAL_PURE;
        public static Item CHEESE_WHITE;
        public static Item CHEESE_RED;
        public static Item CHUM;
        public static Item CINIS_CLUMP;
        public static Item CINIS_BRICK_WET;
        public static Item CINIS_BRICK_DRY;
        public static Item COPPER_SAW;
        public static Item COPPER_STRAND;
        public static Item CORN_BREAD;
        public static Item CORN_COB;
        public static Item CORN_COB_COOKED;
        public static Item CORN_GROUND;
        public static Item CORN_SEEDS;
        public static Item CORN_STALK_DRY;
        public static Item CORN_STALK_WET;
        public static Item BOW_YEW;
        public static Item BOW_CORYPHA;
        public static Item CORYPHA_PIN;
        public static Item CORYPHA_SEED;
        public static Item CORYPHA_STICK;
        public static Item DAUB_BASIC;
        public static Item DAUB_BLACK;
        public static Item DAUB_BLUE;
        public static Item DAUB_BROWN;
        public static Item DAUB_CYAN;
        public static Item DAUB_GRAY;
        public static Item DAUB_GREEN;
        public static Item DAUB_LIGHTBLUE;
        public static Item DAUB_LIME;
        public static Item DAUB_MAGENTA;
        public static Item DAUB_ORANGE;
        public static Item DAUB_PINK;
        public static Item DAUB_PURPLE;
        public static Item DAUB_RED;
        public static Item DAUB_SILVER;
        public static Item DAUB_WHITE;
        public static Item DAUB_YELLOW;
        public static Item DAUCUS_MURN_FRONDS;
        public static Item DAUCUS_MURN_WITHERED;
        public static Item DAUCUS_MURN_ROOT;
        public static Item DAUCUS_MURN_ROOT_COOKED;
        public static Item DAUCUS_MURN_SEEDS;
        public static Item DEVILS_TONGUE_SEPALS;
        public static Item DEVILS_TONGUE_TENDRIL;
        public static Item DIAMOND_AXE;
        public static Item DIAMOND_HATCHET;
        public static Item DIAMOND_HOE;
        public static Item DIAMOND_KNAPP;
        public static Item DIAMOND_PICKAXE;
        public static Item DIAMOND_POINT;
        public static Item DIAMOND_SAW;
        public static Item DIAMOND_SHOVEL;
        public static Item DIAMOND_WORKBLADE;
        public static Item DRY_GRASS_ROOT;
        public static Item DRY_GRASS_SEED;
        public static Item PARAFFIN_CLUMP;
        public static Item EGG_BOILED;
        public static Item EGG_DEATH;
        public static Item EMERALD_AXE;
        public static Item EMERALD_HATCHET;
        public static Item EMERALD_HOE;
        public static Item EMERALD_KNAPP;
        public static Item EMERALD_PICKAXE;
        public static Item EMERALD_POINT;
        public static Item EMERALD_SAW;
        public static Item EMERALD_SHOVEL;
        public static Item EMERALD_WORKBLADE;
        public static Item FIRE_BOW;
        public static Item FISHING_ROD_CORYPHA;
        public static Item FISH_CLOWN_CURED;
        public static Item FISH_CLOWN_DRIED;
        public static Item FISH_CLOWN_ROTTEN;
        public static Item FISH_CLOWN_SALTED;
        public static Item FISH_COD_CURED;
        public static Item FISH_COD_DRIED;
        public static Item FISH_COD_ROTTEN;
        public static Item FISH_COD_SALTED;
        public static Item FISH_LAVA_CRAWDAD_CURED;
        public static Item FISH_LAVA_CRAWDAD_DRIED;
        public static Item FISH_LAVA_CRAWDAD_RAW;
        public static Item FISH_LAVA_CRAWDAD_ROTTEN;
        public static Item FISH_LAVA_CRAWDAD_SALTED;
        public static Item FISH_LAVA_WORM_CURED;
        public static Item FISH_LAVA_WORM_DRIED;
        public static Item FISH_LAVA_WORM_RAW;
        public static Item FISH_LAVA_WORM_ROTTEN;
        public static Item FISH_LAVA_WORM_SALTED;
        public static Item FISH_CLOWN_COOKED;
        public static Item FISH_PUFFER_COOKED;
        public static Item FISH_PUFFER_CURED;
        public static Item FISH_PUFFER_DRIED;
        public static Item FISH_PUFFER_ROTTEN;
        public static Item FISH_PUFFER_SALTED;
        public static Item FISH_SALMON_CURED;
        public static Item FISH_SALMON_DRIED;
        public static Item FISH_SALMON_ROTTEN;
        public static Item FISH_SALMON_SALTED;
        public static Item FLINT_AXE;
        public static Item FLINT_HATCHET;
        public static Item FLINT_HOE;
        public static Item FLINT_FLAKE;
        public static Item FLINT_PICKAXE;
        public static Item FLINT_POINT;
        public static Item FLINT_SAW;
        public static Item FLINT_SHEARS;
        public static Item FLINT_SHOVEL;
        public static Item FLINT_WORKBLADE;
        public static Item MEAT_COOKED_GATOR;
        public static Item MEAT_CURED_GATOR;
        public static Item MEAT_RAW_GATOR;
        public static Item MEAT_ROTTEN_GATOR;
        public static Item MEAT_SALTED_GATOR;
        public static Item GLASS_STICK;
        public static Item GOLDEN_STICK;
        public static Item DIRT_STICK;
        public static Item LADLE_IRONWOOD;
        public static Item LADLE_CORYPHA;
        public static Item LADLE_LACQUER;
        public static Item LADLE_YEW;
        public static Item LADLE_BONE;
        public static Item HIDE_DRIED;
        public static Item HIDE_RAW;
        public static Item HIDE_SALTED;
        public static Item HIDE_SPOILED;
        public static Item HIDE_TANNED;
        public static Item MEAT_COOKED_HORSE;
        public static Item MEAT_DRIED_HORSE;
        public static Item MEAT_RAW_HORSE;
        public static Item MEAT_ROTTEN_HORSE;
        public static Item BOW_IRONWOOD;
        public static Item YEW_SEED;
        public static Item YEW_ARIL;
        public static Item YEW_ARIL_SEEDLESS;
        public static Item YEW_STICK;
        public static Item IRONWOOD_STICK;
        public static Item IRON_CLIPPERS;
        public static Item IRON_GALLAGHER;
        public static Item IRON_MESH;
        public static Item IRON_PIN;
        public static Item IRON_RING;
        public static Item IRON_SAW;
        public static Item IRON_STRAND;
        public static Item IRON_WORKBLADE;
        public static Item LACQUER_STICK;
        public static Item LEATHER_BOILED;
        public static Item LEATHER_CORDAGE;
        public static Item LEATHER_STRIP;
        public static Item MEAT_CURED_LLAMA;
        public static Item MEAT_CURED_WOLF;
        public static Item MEAT_CURED_OVIS;
        public static Item MEAT_CURED_BAT;
        public static Item MEAT_CURED_HORSE;
        public static Item MEAT_COOKED_LLAMA;
        public static Item MEAT_RAW_LLAMA;
        public static Item MEAT_ROTTEN_LLAMA;
        public static Item MEAT_SALTED_LLAMA;
        public static Item MEAT_SALTED_WOLF;
        public static Item MEAT_SALTED_OVIS;
        public static Item MEAT_SALTED_BAT;
        public static Item MEAT_SALTED_HORSE;
        public static Item LAVA_JELLY;
        public static Item LOGS_SPLIT_ACACIA;
        public static Item LOGS_SPLIT_DARK_OAK;
        public static Item LOGS_SPLIT_BIRCH;
        public static Item LOGS_SPLIT_CORYPHA;
        public static Item LOGS_SPLIT_IRONWOOD;
        public static Item LOGS_SPLIT_JUNGLE;
        public static Item LOGS_SPLIT_OAK;
        public static Item LOGS_SPLIT_SPRUCE;
        public static Item LOGS_SPLIT_YEW;
        public static Item MORTAR;
        public static Item MUCK;
        public static Item MUCK_MOLTEN;
        public static Item MUD_CLUMP;
        public static Item ORE_CLUSTER_BOG_IRON;
        public static Item ORE_CLUSTER_ZINC;
        public static Item ORE_CLUSTER_MAGNETITE;
        public static Item MAGNETITE_DUST;
        public static Item NETHERWAX_CLUMP;
        public static Item NETHER_CLOTH;
        public static Item NETHER_CORDAGE;
        public static Item CINERIS_FIBER;
        public static Item CINERIS_FIBER_PULP;
        public static Item NETHER_GALLAGHER;
        public static Item NETHER_PAPYRUS;
        public static Item CINERIS_ROOT;
        public static Item CINERIS_SEED;
        public static Item NETHER_TINDER;
        public static Item OBSIDIAN_AXE;
        public static Item OBSIDIAN_BODY;
        public static Item OBSIDIAN_FEET;
        public static Item GOGGLES_DARK_LENS;
        public static Item OBSIDIAN_HATCHET;
        public static Item OBSIDIAN_HEAD;
        public static Item OBSIDIAN_HOE;
        public static Item OBSIDIAN_FLAKE;
        public static Item OBSIDIAN_LEGS;
        public static Item OBSIDIAN_LENS;
        public static Item OBSIDIAN_PICKAXE;
        public static Item OBSIDIAN_POINT;
        public static Item OBSIDIAN_SHARD;
        public static Item OBSIDIAN_SHOVEL;
        public static Item OBSIDIAN_WORKBLADE;
        public static Item OBSIDIAN_SAW;
        public static Item OPAL;
        public static Item OPAL_AXE;
        public static Item OPAL_HATCHET;
        public static Item OPAL_HOE;
        public static Item OPAL_FLAKE;
        public static Item OPAL_PICKAXE;
        public static Item OPAL_POINT;
        public static Item OPAL_SHOVEL;
        public static Item OPAL_WORKBLADE;
        public static Item OVIS_BODY;
        public static Item OVIS_FEET;
        public static Item OVIS_HEAD;
        public static Item OVIS_LEGS;
        public static Item MEAT_COOKED_OVIS;
        public static Item MEAT_DRIED_OVIS;
        public static Item MEAT_RAW_OVIS;
        public static Item MEAT_ROTTEN_OVIS;
        public static Item OVIS_MILK_BOTTLE;
        public static Item BOTTLE_PARAFFIN;
        public static Item BOTTLE_BITUMEN;
        public static Item PELT_ANIMAL;
        public static Item PELT_ANIMAL_LARGE;
        public static Item PELT_BEAR_BLACK;
        public static Item PELT_BEAR_BROWN;
        public static Item PELT_BEAR_POLAR;
        public static Item PELT_DEER;
        public static Item PELT_COW;
        public static Item PELT_DOG;
        public static Item PELT_DONKEY;
        public static Item PELT_GATOR;
        public static Item PELT_HORSE;
        public static Item PELT_LLAMA;
        public static Item PELT_MOOSHROOM;
        public static Item PELT_MULE;
        public static Item PELT_ATRE;
        public static Item PELT_PIG;
        public static Item PELT_SHARK;
        public static Item PELT_SHEEP;
        public static Item PIGMAN_HIDE_DRIED;
        public static Item PIGMAN_HIDE_RAW;
        public static Item PIGMAN_HIDE_SALTED;
        public static Item PIGMAN_HIDE_SPOILED;
        public static Item PIGMAN_HIDE_TANNED;
        public static Item PIGMAN_LEATHER;
        public static Item MEAT_COOKED_PIGMAN;
        public static Item MEAT_CURED_PIGMAN;
        public static Item MEAT_DRIED_PIGMAN;
        public static Item MEAT_RAW_PIGMAN;
        public static Item MEAT_ROTTEN_PIGMAN;
        public static Item MEAT_SALTED_PIGMAN;
        public static Item PLANT_CLOTH;
        public static Item PLANT_CORDAGE;
        public static Item PLANT_FIBER;
        public static Item PLANT_FIBER_PULP;
        public static Item PLANT_PAPYRUS;
        public static Item PLANT_TINDER;
        public static Item POTATO_BOILED;
        public static Item POTATO_ROTTEN;
        public static Item PUMPKIN_PIECE;
        public static Item SWORD_CRUDE_BONE;
        public static Item SWORD_CRUDE_FLINT;
        public static Item SWORD_CRUDE_QUARTZ;
        public static Item SWORD_CRUDE_IRON;
        public static Item SWORD_CRUDE_WOOTZ;
        public static Item QUARTZ_AXE;
        public static Item QUARTZ_CLIPPERS;
        public static Item QUARTZ_GALLAGHER;
        public static Item QUARTZ_HATCHET;
        public static Item QUARTZ_HOE;
        public static Item QUARTZ_FLAKE;
        public static Item QUARTZ_PICKAXE;
        public static Item QUARTZ_POINT;
        public static Item QUARTZ_VITRIFIED;
        public static Item QUARTZ_VITRIFIED_LENS;
        public static Item QUARTZ_SAW;
        public static Item QUARTZ_SHEARS;
        public static Item QUARTZ_SHOVEL;
        public static Item QUARTZ_WORKBLADE;
        public static Item ROCK_ANDESITE;
        public static Item ROCK_DIORITE;
        public static Item ROCK_GRANITE;
        public static Item ROCK_NETHERRACK;
        public static Item ROCK_END;
        public static Item ROCK_STONE;
        public static Item ROT;
        public static Item RUSH_SEEDS;
        public static Item RUSH_STEMS;
        public static Item RUSH_SEEDS_COOKED;
        public static Item SALO;
        public static Item SALT_DUST_FIRE;
        public static Item SALT_DUST_ROCK;
        public static Item SALT_DUST_NETJRY;
        public static Item SALT_DUST_VOID;
        public static Item SEARING_EMBER;
        public static Item SEARING_SPRIG;
        public static Item SHARK_FIN;
        public static Item MEAT_COOKED_SHARK;
        public static Item MEAT_CURED_SHARK;
        public static Item MEAT_DRIED_SHARK_MEAT;
        public static Item MEAT_RAW_SHARK;
        public static Item MEAT_ROTTEN_SHARK;
        public static Item MEAT_SALTED_SHARK;
        public static Item MUD_BRICK_WET;
        public static Item MUD_BRICK_DRY;
        public static Item SHARK_TOOTH;
        public static Item SHARP_BONE;
        public static Item SILK_CORDAGE;
        public static Item SILK_CORDAGE_COILED;
        public static Item SINUOUS_CORDAGE;
        public static Item SINUOUS_FIBER;
        public static Item SINUOUS_RESIN;
        public static Item SINUOUS_SPORE;
        public static Item SPAWNEGG_BLACKBEAR;
        public static Item SPAWNEGG_BROWNBEAR;
        public static Item SPAWNEGG_CANIS;
        public static Item SPAWNEGG_CREEPER;
        public static Item SPAWNEGG_GATOR;
        public static Item SPAWNEGG_HAMMERHEAD;
        public static Item SPAWNEGG_OVIS;
        public static Item STONE_BASIN;
        public static Item STONE_GALLAGHER;
        public static Item SMELTERY_LID_MUD;
        public static Item SMELTERY_LID_ADOBE;
        public static Item SMELTERY_LID_TERRA;
        public static Item SMELTERY_LID_CINIS;
        public static Item TALL_GRASS_SEEDS;
        public static Item TANNIN_BOTTLE;
        public static Item TANNIN_GROUND;
        public static Item TERRA_CLUMP;
        public static Item TERRA_BRICK_WET;
        public static Item TERRA_BRICK_DRY;
        public static Item THATCHING_DRY;
        public static Item THATCHING_NETHER;
        public static Item THATCHING_WET;
        public static Item TORCH_NETHER_LIT;
        public static Item URUSHI_BOTTLE;
        public static Item URUSHI_GROUND;
        public static Item INFERUM_GROUND;
        public static Item VALUS_BREAD;
        public static Item VALUS_FIBER;
        public static Item VALUS_MELON;
        public static Item VALUS_SEED;
        public static Item VALUS_SEPALS;
        public static Item VALUS_STALK_FRESH;
        public static Item VALUS_STALK_WITHERED;
        public static Item INANIS_CORDAGE;
        public static Item INANIS_FIBER;
        public static Item INANIS_SEED;
        public static Item INANIS_ROOT;
        public static Item WHEAT_GROUND;
        public static Item ASH_BONE;
        public static Item ASH_WOLF;
        public static Item WOLF_BODY;
        public static Item WOLF_FEET;
        public static Item WOLF_HEAD;
        public static Item WOLF_HEAD_ITEM;
        public static Item WOLF_LEGS;
        public static Item MEAT_COOKED_WOLF;
        public static Item MEAT_DRIED_WOLF;
        public static Item MEAT_RAW_WOLF;
        public static Item MEAT_ROTTEN_WOLF;
        public static Item PELT_WOLF;
        public static Item FLETCHING;
        public static Item WOOD_PIN;
        public static Item MUSHROOM_COOKED;
        public static Item NETHER_WART_COOKED;
        public static Item VANADIUM_DUST;
        public static Item VANADIUM_INGOT;
        public static Item VANADIUM_NUGGET;
        public static Item VANADIUM_PLATE;
        public static Item IRON_BLOOM;
        public static Item CRUDE_IRON_DUST;
        public static Item CRUDE_IRON_NUGGET;
        public static Item CRUDE_IRON_INGOT;
        public static Item CRUDE_IRON_PLATE;
        public static Item STEEL_NUGGET;
        public static Item TAMAHAGANE_BLOOM;
        public static Item TAMAHAGANE_DUST;
        public static Item TAMAHAGANE_INGOT;
        public static Item TAMAHAGANE_NUGGET;
        public static Item TAMAHAGANE_PLATE;
        public static Item TAMAHAGENE;
        public static Item SHIBUICHI_NUGGET;
        public static Item SHIBUICHI_DUST;
        public static Item SHIBUICHI_INGOT;
        public static Item SHIBUICHI_PLATE;
        public static Item ADAMANT_NUGGET;
        public static Item ADAMANT_DUST;
        public static Item ADAMANT_INGOT;
        public static Item ADAMANT_PLATE;
        public static Item WOOTZ_DUST;
        public static Item WOOTZ_INGOT;
        public static Item WOOTZ_NUGGET;
        public static Item WOOTZ_PLATE;
        public static Item DIAMOND_PLATE;
        public static Item OBSIDIAN_PLATE;
        public static Item CARBON_PLATE;
        public static Item IRON_DUST;
        public static Item IRON_PLATE;
        public static Item GOLD_DUST;
        public static Item GOLD_PLATE;
        public static Item STEEL_INGOT;
        public static Item STEEL_PLATE;
        public static Item COPPER_DUST;
        public static Item COPPER_INGOT;
        public static Item COPPER_NUGGET;
        public static Item COPPER_PLATE;
        public static Item TIN_DUST;
        public static Item TIN_INGOT;
        public static Item TIN_NUGGET;
        public static Item TIN_PLATE;
        public static Item BRONZE_DUST;
        public static Item BRONZE_INGOT;
        public static Item BRONZE_NUGGET;
        public static Item BRONZE_PLATE;
        public static Item BRASS_DUST;
        public static Item BRASS_INGOT;
        public static Item BRASS_NUGGET;
        public static Item BRASS_PLATE;
        public static Item SILVER_DUST;
        public static Item SILVER_INGOT;
        public static Item SILVER_NUGGET;
        public static Item SILVER_PLATE;
        public static Item LEAD_DUST;
        public static Item LEAD_INGOT;
        public static Item LEAD_NUGGET;
        public static Item LEAD_PLATE;
        public static Item ALUMINUM_DUST;
        public static Item ALUMINUM_INGOT;
        public static Item ALUMINUM_NUGGET;
        public static Item ALUMINUM_PLATE;
        public static Item NICKEL_DUST;
        public static Item NICKEL_INGOT;
        public static Item NICKEL_NUGGET;
        public static Item NICKEL_PLATE;
        public static Item PLATINUM_DUST;
        public static Item PLATINUM_INGOT;
        public static Item PLATINUM_NUGGET;
        public static Item PLATINUM_PLATE;
        public static Item ZINC_DUST;
        public static Item ZINC_INGOT;
        public static Item ZINC_NUGGET;
        public static Item ZINC_PLATE;
        public static Item BUCKET_CLAY_SOFT;
        public static Item BUCKET_CLAY_MILK;
        public static PrimalBucket BUCKET_CLAY;
        public static Item BUCKET_TERRA_SOFT;
        public static Item BUCKET_TERRA_MILK;
        public static PrimalBucket BUCKET_TERRA;
        public static Item BUCKET_CINIS_SOFT;
        public static Item BUCKET_CINIS_MILK;
        public static PrimalBucket BUCKET_CINIS;
    }

    public static class Blocks {
        public static Block TATAMI_BED;
        public static Block ACONITE;
        public static Block ADOBE_BRICK;
        public static Block ANCIENT_ICE;
        public static Block ANVIL_ANDESITE;
        public static Block ANVIL_DIORITE;
        public static Block ANVIL_GRANITE;
        public static Block ANVIL_NETHER;
        public static Block ASH_COMMON;
        public static Block ASH_YEW;
        public static Block ASH_IRONWOOD;
        public static Block BARREL;
        public static Block BLUE_STONE;
        public static Block BRICK_FORM;
        public static Block CARBONATE_STONE;
        public static Block CARPET_CINERIS;
        public static Block CARPET_INANIS;
        public static Block CAULDRON;
        public static Block CHARCOAL_STACK;
        public static Block CINIS_BLOCK;
        public static Block CINISCOTTA_BLOCK;
        public static Block CORN_STALK;
        public static Block CORYPHA_STALK;
        public static Block DAUCUS_MURN;
        public static Block DESICCATED_STONE;
        public static Block DEVILS_TONGUE;
        public static Block DRAIN_CARBONATE;
        public static Block DRAIN_FERRO;
        public static Block DRAIN_MUD;
        public static Block DRAIN_NETHER_EARTH;
        public static Block DRAIN_SCORIA;
        public static Block DRAIN_SCHIST_GREEN;
        public static Block DRAIN_CINISCOTTA;
        public static Block DRAIN_NETHERSTONE;
        public static Block DRAIN_STONEBRICK;
        public static Block DRAIN_THATCH;
        public static Block MUD_DRIED;
        public static Block BRICK_MOLD;
        public static Block DRYING_RACK;
        public static Block DRY_GRASS;
        public static Block DOOR_IRONWOOD;
        public static Block DOOR_CORYPHA;
        public static Block DOOR_YEW;
        public static Block DOOR_LACQUER;
        public static Block COMMON_STONE;
        public static Block CALCIFIED_PARAFFIN;
        public static Block ERODED_END_STONE;
        public static Block FENCE_WOOD;
        public static Block FERRO_STONE;
        public static Block FIRE_PIT;
        public static Block FISH_TRAP;
        public static Block GATE_IRONWOOD;
        public static Block GATE_LACQUER;
        public static Block GATE_CORYPHA;
        public static Block GATE_YEW;
        public static Block GRATED_GRAVEL;
        public static Block REDSTONE_SAND;
        public static Block GRATE_ACACIA;
        public static Block GRATE_BIGOAK;
        public static Block GRATE_BIRCH;
        public static Block GRATE_CORYPHA;
        public static Block GRATE_IRONWOOD;
        public static Block GRATE_JUNGLE;
        public static Block GRATE_LACQUER;
        public static Block GRATE_OAK;
        public static Block GRATE_SPRUCE;
        public static Block GRATE_THATCH;
        public static Block HARDENED_STONE;
        public static Block HEAD_OVIS;
        public static Block HEAD_WOLF;
        public static Block HIBACHI;
        public static Block SMELTER;
        public static Block IGNIS_FATUUS;
        public static Block IRON_GLASS;
        public static Block OBSIDIAN_TRANSPARENT;
        public static Block JACK_O_LANTERN;
        public static Block KILN;
        public static Block KILN_AIR;
        public static Block LADDER_ACACIA;
        public static Block LADDER_BIGOAK;
        public static Block LADDER_BIRCH;
        public static Block LADDER_BLOCK_ANDESITE;
        public static Block LADDER_BLOCK_COBBLESTONE;
        public static Block LADDER_BLOCK_COBBLESTONE_MOSSY;
        public static Block LADDER_BLOCK_DIORITE;
        public static Block LADDER_BLOCK_ENDBRICK;
        public static Block LADDER_BLOCK_ENDSTONE;
        public static Block LADDER_BLOCK_GRANITE;
        public static Block LADDER_BLOCK_NETHERBRICK;
        public static Block LADDER_BLOCK_NETHERRACK;
        public static Block LADDER_BLOCK_NETHERSTONE;
        public static Block LADDER_BLOCK_SMOOTH_ANDESITE;
        public static Block LADDER_BLOCK_SMOOTH_DIORITE;
        public static Block LADDER_BLOCK_SMOOTH_GRANITE;
        public static Block LADDER_BLOCK_SMOOTHSTONE;
        public static Block LADDER_BLOCK_STONEBRICK;
        public static Block LADDER_BLOCK_STONEBRICK_CRACKED;
        public static Block LADDER_BLOCK_STONEBRICK_MOSSY;
        public static Block LADDER_CORYPHA;
        public static Block LADDER_IRONWOOD;
        public static Block LADDER_JUNGLE;
        public static Block LADDER_LACQUER;
        public static Block LADDER_YEW;
        public static Block LADDER_NETHERRACK;
        public static Block LADDER_OAK;
        public static Block LADDER_SPRUCE;
        public static Block LADDER_STONE;
        public static Block LANTERN_EMPTY;
        public static Block LANTERN_IGNIS;
        public static Block LANTERN_NETHER;
        public static Block LANTERN_REDSTONE;
        public static Block LANTERN_TORCH;
        public static Block LEAVES;
        public static Block LEVER_NETHER;
        public static Block LOAM_BLOCK;
        public static Block LOGS;
        public static Block LOGS_STACKED;
        public static Block LOGS_STACKED_CORYPHA;
        public static Block LOGS_STRIPPED;
        public static Block METAL_BLOCK;
        public static Block MUD_WET;
        public static Block MUD_DRYING;
        public static Block NETHER_BUSH;
        public static Block NETHER_CREEP;
        public static Block NETHER_EARTH;
        public static Block NETHER_FARMLAND;
        public static Block CINERIS_GRASS;
        public static Block NETHER_GROWTH;
        public static Block NETHER_GROWTH_REDSTONE;
        public static Block NETHER_MYCELIUM;
        public static Block NETHER_LURKER;
        public static Block NETHER_LURKER_TENDRIL;
        public static Block NETHER_PATH;
        public static Block NETHER_STONE;
        public static Block INFERUM_VINE;
        public static Block OVIS_ATRE_WOOL;
        public static Block OVIS_ATRE_CARPET;
        public static Block NIGHT_STONE;
        public static Block OLDMANS_BEARD;
        public static Block ORE_CINIS_TIN;
        public static Block ORE_FERRO_IRON;
        public static Block ORE_IRON;
        public static Block ORE_BOG_IRON;
        public static Block ORE_MAGNETITE;
        public static Block ORE_ZINC;
        public static Block ORE_OPAL;
        public static Block ORE_SALT;
        public static Block ORE_SALT_FLAT;
        public static Block ORE_TERRA_IRON;
        public static Block ORTHO_STONE;
        public static Block PLANKS;
        public static Block PITFALL;
        public static Block PURPURITE_STONE;
        public static Block PRESSURE_BLOCK;
        public static Block PRESSURE_PLATE;
        public static Block RUSHES;
        public static Block SAPLING;
        public static Block SARSEN_STONE;
        public static Block SATETSU;
        public static Block SCHIST_BLUE_STONE;
        public static Block SCHIST_GREEN_STONE;
        public static Block CINERIS_BLOOM;
        public static Block SEA_GRASS;
        public static Block SCORIA_STONE;
        public static Block PORPHYRY_STONE;
        public static Block SHELF_HALF;
        public static Block SINUOUS_WEED;
        public static Block SLAB_CORYPHA;
        public static Block SLAB_GLASS;
        public static Block SLAB_IRONWOOD;
        public static Block SLAB_LACQUER;
        public static Block SLAB_MUD;
        public static Block SLAB_NETHERRACK;
        public static Block SLAB_NETHERSTONE;
        public static Block SLAB_NETHER_EARTH;
        public static Block SLAB_SOUL_GLASS;
        public static Block SLAB_YEW;
        public static Block SLAT_ACACIA;
        public static Block SLAT_DARK_OAK;
        public static Block SLAT_BIRCH;
        public static Block SLAT_IRON;
        public static Block SLAT_IRONWOOD;
        public static Block SLAT_JUNGLE;
        public static Block SLAT_LACQUER;
        public static Block SLAT_CORYPHA;
        public static Block SLAT_OAK;
        public static Block SLAT_SPRUCE;
        public static Block SLAT_YEW;
        public static Block SOUL_GLASS;
        public static Block SOUL_STONE;
        public static Block STAIRS_CARBONATE_STONE;
        public static Block STAIRS_DIRT;
        public static Block STAIRS_FERRO_STONE;
        public static Block STAIRS_NIGHT_STONE;
        public static Block STAIRS_GRASS;
        public static Block STAIRS_IRONWOOD;
        public static Block STAIRS_LACQUER;
        public static Block STAIRS_MUD;
        public static Block STAIRS_CORYPHA;
        public static Block STAIRS_NETHERRACK;
        public static Block STAIRS_NETHER_EARTH;
        public static Block STAIRS_NETHER_PATH;
        public static Block STAIRS_PATH;
        public static Block STAIRS_STONEBRICK_MOSSY;
        public static Block STORAGE_CRATE;
        public static Block STRANGLE_WEED;
        public static Block TALL_GRASS;
        public static Block TERRA_BLOCK;
        public static Block TERRACOTTA_BLOCK;
        public static Block THATCH;
        public static Block THATCH_CINERIS;
        public static Block THATCH_WET;
        public static Block THIN_SLAB_ACACIA;
        public static Block THIN_SLAB_DARK_OAK;
        public static Block THIN_SLAB_BIRCH;
        public static Block THIN_SLAB_CORYPHA;
        public static Block THIN_SLAB_GLASS;
        public static Block THIN_SLAB_IRONWOOD;
        public static Block THIN_SLAB_JUNGLE;
        public static Block THIN_SLAB_LACQUER;
        public static Block THIN_SLAB_YEW;
        public static Block THIN_SLAB_MUD;
        public static Block THIN_SLAB_OAK;
        public static Block THIN_SLAB_SOULGLASS;
        public static Block THIN_SLAB_SPRUCE;
        public static Block THIN_SLAB_THATCH;
        public static Block TORCH_NETHER;
        public static Block TORCH_WOOD;
        public static Block VALUS_OMNIFERUM;
        public static Block INANIS_GRASS;
        public static Block WALL_STONE;
        public static Block WORKTABLE_SHELF;
        public static Block WORKTABLE_SLAB;
        public static Block WATTLE_DAUB;
        public static Block WATTLE_ACACIA;
        public static Block WATTLE_BIGOAK;
        public static Block WATTLE_BIRCH;
        public static Block WATTLE_CORYPHA;
        public static Block WATTLE_IRONWOOD;
        public static Block WATTLE_JUNGLE;
        public static Block WATTLE_LACQUER;
        public static Block WATTLE_OAK;
        public static Block WATTLE_SPRUCE;
        public static Block DAUB_ACACIA_BASIC;
        public static Block DAUB_ACACIA_BLACK;
        public static Block DAUB_ACACIA_BLUE;
        public static Block DAUB_ACACIA_BROWN;
        public static Block DAUB_ACACIA_CYAN;
        public static Block DAUB_ACACIA_GRAY;
        public static Block DAUB_ACACIA_GREEN;
        public static Block DAUB_ACACIA_LIGHTBLUE;
        public static Block DAUB_ACACIA_LIME;
        public static Block DAUB_ACACIA_MAGENTA;
        public static Block DAUB_ACACIA_ORANGE;
        public static Block DAUB_ACACIA_PINK;
        public static Block DAUB_ACACIA_PURPLE;
        public static Block DAUB_ACACIA_RED;
        public static Block DAUB_ACACIA_SILVER;
        public static Block DAUB_ACACIA_WHITE;
        public static Block DAUB_ACACIA_YELLOW;
        public static Block DAUB_BIGOAK_BASIC;
        public static Block DAUB_BIGOAK_BLACK;
        public static Block DAUB_BIGOAK_BLUE;
        public static Block DAUB_BIGOAK_BROWN;
        public static Block DAUB_BIGOAK_CYAN;
        public static Block DAUB_BIGOAK_GRAY;
        public static Block DAUB_BIGOAK_GREEN;
        public static Block DAUB_BIGOAK_LIGHTBLUE;
        public static Block DAUB_BIGOAK_LIME;
        public static Block DAUB_BIGOAK_MAGENTA;
        public static Block DAUB_BIGOAK_ORANGE;
        public static Block DAUB_BIGOAK_PINK;
        public static Block DAUB_BIGOAK_PURPLE;
        public static Block DAUB_BIGOAK_RED;
        public static Block DAUB_BIGOAK_SILVER;
        public static Block DAUB_BIGOAK_WHITE;
        public static Block DAUB_BIGOAK_YELLOW;
        public static Block DAUB_BIRCH_BASIC;
        public static Block DAUB_BIRCH_BLACK;
        public static Block DAUB_BIRCH_BLUE;
        public static Block DAUB_BIRCH_BROWN;
        public static Block DAUB_BIRCH_CYAN;
        public static Block DAUB_BIRCH_GRAY;
        public static Block DAUB_BIRCH_GREEN;
        public static Block DAUB_BIRCH_LIGHTBLUE;
        public static Block DAUB_BIRCH_LIME;
        public static Block DAUB_BIRCH_MAGENTA;
        public static Block DAUB_BIRCH_ORANGE;
        public static Block DAUB_BIRCH_PINK;
        public static Block DAUB_BIRCH_PURPLE;
        public static Block DAUB_BIRCH_RED;
        public static Block DAUB_BIRCH_SILVER;
        public static Block DAUB_BIRCH_WHITE;
        public static Block DAUB_BIRCH_YELLOW;
        public static Block DAUB_CORYPHA_BASIC;
        public static Block DAUB_CORYPHA_BLACK;
        public static Block DAUB_CORYPHA_BLUE;
        public static Block DAUB_CORYPHA_BROWN;
        public static Block DAUB_CORYPHA_CYAN;
        public static Block DAUB_CORYPHA_GRAY;
        public static Block DAUB_CORYPHA_GREEN;
        public static Block DAUB_CORYPHA_LIGHTBLUE;
        public static Block DAUB_CORYPHA_LIME;
        public static Block DAUB_CORYPHA_MAGENTA;
        public static Block DAUB_CORYPHA_ORANGE;
        public static Block DAUB_CORYPHA_PINK;
        public static Block DAUB_CORYPHA_PURPLE;
        public static Block DAUB_CORYPHA_RED;
        public static Block DAUB_CORYPHA_SILVER;
        public static Block DAUB_CORYPHA_WHITE;
        public static Block DAUB_CORYPHA_YELLOW;
        public static Block DAUB_IRONWOOD_BASIC;
        public static Block DAUB_IRONWOOD_BLACK;
        public static Block DAUB_IRONWOOD_BLUE;
        public static Block DAUB_IRONWOOD_BROWN;
        public static Block DAUB_IRONWOOD_CYAN;
        public static Block DAUB_IRONWOOD_GRAY;
        public static Block DAUB_IRONWOOD_GREEN;
        public static Block DAUB_IRONWOOD_LIGHTBLUE;
        public static Block DAUB_IRONWOOD_LIME;
        public static Block DAUB_IRONWOOD_MAGENTA;
        public static Block DAUB_IRONWOOD_ORANGE;
        public static Block DAUB_IRONWOOD_PINK;
        public static Block DAUB_IRONWOOD_PURPLE;
        public static Block DAUB_IRONWOOD_RED;
        public static Block DAUB_IRONWOOD_SILVER;
        public static Block DAUB_IRONWOOD_WHITE;
        public static Block DAUB_IRONWOOD_YELLOW;
        public static Block DAUB_JUNGLE_BASIC;
        public static Block DAUB_JUNGLE_BLACK;
        public static Block DAUB_JUNGLE_BLUE;
        public static Block DAUB_JUNGLE_BROWN;
        public static Block DAUB_JUNGLE_CYAN;
        public static Block DAUB_JUNGLE_GRAY;
        public static Block DAUB_JUNGLE_GREEN;
        public static Block DAUB_JUNGLE_LIGHTBLUE;
        public static Block DAUB_JUNGLE_LIME;
        public static Block DAUB_JUNGLE_MAGENTA;
        public static Block DAUB_JUNGLE_ORANGE;
        public static Block DAUB_JUNGLE_PINK;
        public static Block DAUB_JUNGLE_PURPLE;
        public static Block DAUB_JUNGLE_RED;
        public static Block DAUB_JUNGLE_SILVER;
        public static Block DAUB_JUNGLE_WHITE;
        public static Block DAUB_JUNGLE_YELLOW;
        public static Block DAUB_LACQUER_BASIC;
        public static Block DAUB_LACQUER_BLACK;
        public static Block DAUB_LACQUER_BLUE;
        public static Block DAUB_LACQUER_BROWN;
        public static Block DAUB_LACQUER_CYAN;
        public static Block DAUB_LACQUER_GRAY;
        public static Block DAUB_LACQUER_GREEN;
        public static Block DAUB_LACQUER_LIGHTBLUE;
        public static Block DAUB_LACQUER_LIME;
        public static Block DAUB_LACQUER_MAGENTA;
        public static Block DAUB_LACQUER_ORANGE;
        public static Block DAUB_LACQUER_PINK;
        public static Block DAUB_LACQUER_PURPLE;
        public static Block DAUB_LACQUER_RED;
        public static Block DAUB_LACQUER_SILVER;
        public static Block DAUB_LACQUER_WHITE;
        public static Block DAUB_LACQUER_YELLOW;
        public static Block DAUB_OAK_BASIC;
        public static Block DAUB_OAK_BLACK;
        public static Block DAUB_OAK_BLUE;
        public static Block DAUB_OAK_BROWN;
        public static Block DAUB_OAK_CYAN;
        public static Block DAUB_OAK_GRAY;
        public static Block DAUB_OAK_GREEN;
        public static Block DAUB_OAK_LIGHTBLUE;
        public static Block DAUB_OAK_LIME;
        public static Block DAUB_OAK_MAGENTA;
        public static Block DAUB_OAK_ORANGE;
        public static Block DAUB_OAK_PINK;
        public static Block DAUB_OAK_PURPLE;
        public static Block DAUB_OAK_RED;
        public static Block DAUB_OAK_SILVER;
        public static Block DAUB_OAK_WHITE;
        public static Block DAUB_OAK_YELLOW;
        public static Block DAUB_SPRUCE_BASIC;
        public static Block DAUB_SPRUCE_BLACK;
        public static Block DAUB_SPRUCE_BLUE;
        public static Block DAUB_SPRUCE_BROWN;
        public static Block DAUB_SPRUCE_CYAN;
        public static Block DAUB_SPRUCE_GRAY;
        public static Block DAUB_SPRUCE_GREEN;
        public static Block DAUB_SPRUCE_LIGHTBLUE;
        public static Block DAUB_SPRUCE_LIME;
        public static Block DAUB_SPRUCE_MAGENTA;
        public static Block DAUB_SPRUCE_ORANGE;
        public static Block DAUB_SPRUCE_PINK;
        public static Block DAUB_SPRUCE_PURPLE;
        public static Block DAUB_SPRUCE_RED;
        public static Block DAUB_SPRUCE_SILVER;
        public static Block DAUB_SPRUCE_WHITE;
        public static Block DAUB_SPRUCE_YELLOW;
    }
}

