/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.control;

import java.util.ArrayList;
import java.util.List;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.control.GuiControl;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiSliderInteger
extends GuiButtonExt {
    private float sliderPosition = 1.0f;
    public boolean isMouseDown;
    private final int min;
    private int max;
    private final GuiControl responder;
    private boolean appendPlusSignLabel = true;
    private List<String> tooltip = new ArrayList<String>();

    public GuiSliderInteger(GuiControl guiResponder, int idIn, int x, int y, int widthIn, int heightIn, int minIn, int maxIn) {
        super(idIn, x, y, widthIn, heightIn, "");
        this.updateDisplay();
        this.responder = guiResponder;
        this.min = minIn;
        this.setMax(maxIn);
        this.appendPlusSignLabel = this.min < 0;
    }

    public void setSliderValue(float value, boolean notifyResponder) {
        this.sliderPosition = (value - (float)this.min) / (float)(this.getMax() - this.min);
        this.updateDisplay();
        if (notifyResponder) {
            this.notifyResponder();
        }
    }

    private void notifyResponder() {
        int val = (int)this.getSliderValue();
        this.responder.setPage(val);
    }

    public float getSliderValue() {
        float val = (float)this.min + (float)(this.getMax() - this.min) * this.sliderPosition;
        return MathHelper.func_76141_d((float)val);
    }

    private void updateDisplay() {
        int val = (int)this.getSliderValue();
        this.field_146126_j = val > 0 && this.appendPlusSignLabel ? "+" + val : "" + val;
    }

    public void setTooltip(String t) {
        ArrayList<String> remake = new ArrayList<String>();
        remake.add(StorageNetwork.lang(t));
        this.tooltip = remake;
    }

    public List<String> getTooltips() {
        return this.tooltip;
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.setSliderPosFromMouse(mouseX, mouseY);
            this.notifyResponder();
            this.isMouseDown = true;
            return true;
        }
        return false;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        super.func_146119_b(mc, mouseX, mouseY);
        if (this.field_146125_m) {
            if (this.isMouseDown) {
                this.setSliderPosFromMouse(mouseX, mouseY);
                this.updateDisplay();
                this.notifyResponder();
            }
            this.func_73729_b(this.field_146128_h, this.field_146129_i + (int)(this.sliderPosition * (float)(this.field_146121_g - 8)), 188, 69, this.field_146120_f, 8);
        }
    }

    private void setSliderPosFromMouse(int mouseX, int mouseY) {
        float relativePos;
        this.sliderPosition = relativePos = (float)(mouseY - (this.field_146129_i + 4)) / (float)(this.field_146121_g - 8);
        if (this.sliderPosition < 0.0f) {
            this.sliderPosition = 0.0f;
        }
        if (this.sliderPosition > 1.0f) {
            this.sliderPosition = 1.0f;
        }
    }

    public void func_146118_a(int mouseX, int mouseY) {
        super.func_146118_a(mouseX, mouseY);
        this.isMouseDown = false;
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

