/*
 * Decompiled with CFR 0.152.
 */
package lex.world.gen.feature;

import java.util.Map;
import java.util.Random;
import lex.config.Config;
import lex.util.StructureHelper;
import lex.world.gen.feature.Feature;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class FeatureStructure
extends Feature {
    private ResourceLocation structure;
    private Type type;
    private Mirror mirror;
    private Rotation rotation;
    private Block ignoredBlock;
    private float clearancePercentage;

    public FeatureStructure(Config config) {
        super(config);
        this.structure = config.getResource("structure");
        this.type = config.getEnum("type", Type.class, Type.GROUNDED);
        this.mirror = config.getEnum("mirror", Mirror.class, Mirror.NONE);
        this.rotation = config.getEnum("rotation", Rotation.class, Rotation.NONE);
        this.ignoredBlock = config.getBlock("ignoredBlock", Blocks.field_189881_dj.func_176223_P()).func_177230_c();
        this.clearancePercentage = config.getFloat("clearancePercentage", 0.875f);
    }

    public FeatureStructure(int genAttempts, float genProbability, boolean randomizeGenAttempts, int minGenHeight, int maxGenHeight, ResourceLocation structure, Type type, Mirror mirror, Rotation rotation, Block ignoredBlock, float clearancePercentage) {
        super(genAttempts, genProbability, randomizeGenAttempts, minGenHeight, maxGenHeight);
        this.structure = structure;
        this.type = type;
        this.mirror = mirror;
        this.rotation = rotation;
        this.ignoredBlock = ignoredBlock;
        this.clearancePercentage = clearancePercentage;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        MinecraftServer server = world.func_73046_m();
        TemplateManager manager = world.func_72860_G().func_186340_h();
        Template template = manager.func_186237_a(server, this.structure);
        PlacementSettings placementSettings = new PlacementSettings().func_186214_a(this.mirror).func_186220_a(this.rotation).func_186225_a(this.ignoredBlock).func_189950_a(rand);
        BlockPos structureSize = template.func_186257_a(this.rotation);
        BlockPos spawnPos = null;
        if (this.type == Type.GROUNDED) {
            spawnPos = StructureHelper.getGroundedPos(world, pos, structureSize, this.clearancePercentage);
        } else if (this.type == Type.FLOATING) {
            spawnPos = StructureHelper.getFloatingPos(world, pos, structureSize, this.clearancePercentage);
        } else if (this.type == Type.HANGING) {
            spawnPos = StructureHelper.getHangingPos(world, pos, structureSize, this.clearancePercentage);
        } else if (this.type == Type.BURIED) {
            spawnPos = StructureHelper.getBuriedPos(world, pos, structureSize, this.clearancePercentage);
        }
        if (spawnPos != null && spawnPos.func_177956_o() >= this.minGenHeight && spawnPos.func_177956_o() <= this.maxGenHeight) {
            template.func_186253_b(world, spawnPos, placementSettings);
            this.handleDataBlocks(world, spawnPos, template, placementSettings, rand);
            return true;
        }
        return false;
    }

    private void handleDataBlocks(World world, BlockPos pos, Template template, PlacementSettings placementSettings, Random rand) {
        Map map = template.func_186258_a(pos, placementSettings);
        for (Map.Entry entry : map.entrySet()) {
            BlockPos dataPos = (BlockPos)entry.getKey();
            String[] data = ((String)entry.getValue()).split("\\s+");
            if (data[0].equals("chest") && data.length == 2) {
                world.func_175656_a(dataPos, Blocks.field_150486_ae.func_176458_f(world, dataPos, Blocks.field_150486_ae.func_176223_P()));
                TileEntityChest chest = (TileEntityChest)world.func_175625_s(dataPos);
                if (chest == null) continue;
                chest.func_189404_a(new ResourceLocation(data[1]), rand.nextLong());
                continue;
            }
            if (data[0].equals("spawner") && data.length == 2) {
                world.func_175656_a(dataPos, Blocks.field_150474_ac.func_176223_P());
                TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(dataPos);
                if (spawner == null) continue;
                MobSpawnerBaseLogic logic = spawner.func_145881_a();
                NBTTagCompound compound = new NBTTagCompound();
                logic.func_189530_b(compound);
                compound.func_82580_o("SpawnPotentials");
                logic.func_98270_a(compound);
                logic.func_190894_a(new ResourceLocation(data[1]));
                spawner.func_70296_d();
                IBlockState state = world.func_180495_p(dataPos);
                world.func_184138_a(pos, state, state, 3);
                continue;
            }
            if (data[0].equals("entity") && data.length == 2) {
                Entity entity = EntityList.func_191304_a((Class)EntityList.getClass((ResourceLocation)new ResourceLocation(data[1])), (World)world);
                if (entity == null) continue;
                entity.func_70107_b((double)((float)dataPos.func_177958_n() + 0.5f), (double)dataPos.func_177956_o(), (double)((float)dataPos.func_177952_p() + 0.5f));
                world.func_72838_d(entity);
                continue;
            }
            world.func_175698_g(dataPos);
        }
    }

    public static enum Type {
        GROUNDED,
        FLOATING,
        HANGING,
        BURIED;

    }
}

