/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class BaseSettingsMessage
implements IMessage {
    protected BlockPos routerPos;
    protected EnumHand hand;
    protected int moduleSlotIndex;
    protected NBTTagCompound nbtData;

    public BaseSettingsMessage() {
    }

    public BaseSettingsMessage(BlockPos routerPos, EnumHand hand, int moduleSlotIndex, NBTTagCompound nbtData) {
        this.routerPos = routerPos;
        this.moduleSlotIndex = moduleSlotIndex;
        this.hand = hand;
        this.nbtData = nbtData;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.routerPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.moduleSlotIndex = buf.readByte();
        } else {
            this.hand = EnumHand.values()[buf.readByte()];
        }
        this.nbtData = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        if (this.routerPos == null) {
            buf.writeBoolean(false);
            buf.writeByte(this.hand.ordinal());
        } else {
            buf.writeBoolean(true);
            this.writePos(buf, this.routerPos);
            buf.writeByte(this.moduleSlotIndex);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbtData);
    }

    protected void writePos(ByteBuf buf, BlockPos pos) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
    }

    protected BlockPos readPos(ByteBuf buf) {
        return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public NBTTagCompound getNbtData() {
        return this.nbtData;
    }
}

