/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.item.ItemBase;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemSubTypes<T extends Enum<T>>
extends ItemBase {
    private final SubItemHandler[] handlers;
    private final Class<T> value;

    public ItemSubTypes(String name, Class<T> value) {
        super(name);
        this.value = value;
        this.handlers = new SubItemHandler[this.getSubTypes()];
        this.func_77627_a(true);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return "item." + this.getSubTypeName(stack.func_77960_j());
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < this.getSubTypes(); ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Override
    public int getSubTypes() {
        Enum[] vals = (Enum[])this.value.getEnumConstants();
        return vals.length;
    }

    @Override
    public String getSubTypeName(int meta) {
        return ((Enum[])this.value.getEnumConstants())[meta].name().toLowerCase() + "_" + this.name;
    }

    protected void register(T val, SubItemHandler handler) {
        this.handlers[((Enum)val).ordinal()] = handler;
    }

    public SubItemHandler getHandler(ItemStack stack) {
        return this.handlers[stack.func_77960_j()];
    }

    public SubItemHandler getHandler(T what) {
        return this.handlers[((Enum)what).ordinal()];
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        SubItemHandler handler = this.getHandler(itemstack);
        if (handler != null) {
            handler.addBasicInformation(itemstack, player, list, advanced);
            if (GuiScreen.func_146271_m()) {
                handler.addUsageInformation(itemstack, player, list, advanced);
            } else if (ConfigHandler.misc.alwaysShowSettings || GuiScreen.func_146272_n()) {
                handler.addExtraInformation(itemstack, player, list, advanced);
                list.add(I18n.func_135052_a((String)"itemText.misc.holdCtrl", (Object[])new Object[0]));
            } else if (!ConfigHandler.misc.alwaysShowSettings) {
                list.add(I18n.func_135052_a((String)"itemText.misc.holdShiftCtrl", (Object[])new Object[0]));
            }
        }
    }

    public static class SubItemHandler {
        @SideOnly(value=Side.CLIENT)
        public void addBasicInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        }

        @SideOnly(value=Side.CLIENT)
        public void addUsageInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
            String s = I18n.func_135052_a((String)("itemText.usage." + itemstack.func_77977_a()), (Object[])this.getExtraUsageParams());
            for (String s1 : s.split("\\\\n")) {
                list.addAll(MiscUtil.wrapString(s1));
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        }

        public EnumActionResult onItemUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float x, float y, float z) {
            return EnumActionResult.PASS;
        }

        public Object[] getExtraUsageParams() {
            return new Object[0];
        }

        @SideOnly(value=Side.CLIENT)
        public Color getItemTint() {
            return Color.WHITE;
        }
    }
}

