/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.integration.tesla.TeslaIntegration;
import net.darkhax.tesla.lib.TeslaUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemStackHandler;

public class BufferHandler
extends ItemStackHandler {
    private final TileEntityItemRouter router;
    private IFluidHandler fluidHandler;
    private boolean energyHandler;

    public BufferHandler(TileEntityItemRouter router) {
        super(router.getBufferSlotCount());
        this.router = router;
    }

    public void onContentsChanged(int slot) {
        boolean newEnergyHandler;
        IFluidHandlerItem newHandler;
        this.router.func_70296_d();
        ItemStack stack = this.getStackInSlot(slot);
        IFluidHandlerItem iFluidHandlerItem = newHandler = stack.func_190916_E() == 1 ? FluidUtil.getFluidHandler((ItemStack)stack) : null;
        if (newHandler != this.fluidHandler) {
            boolean doUpdate = newHandler == null || this.fluidHandler == null;
            this.fluidHandler = newHandler;
            if (doUpdate) {
                this.router.func_145831_w().func_175685_c(this.router.func_174877_v(), (Block)RegistrarMR.ITEM_ROUTER, true);
            }
        }
        if ((newEnergyHandler = this.canHandleEnergy(stack)) != this.energyHandler) {
            this.energyHandler = newEnergyHandler;
            this.router.func_145831_w().func_175685_c(this.router.func_174877_v(), (Block)RegistrarMR.ITEM_ROUTER, true);
        }
    }

    private boolean canHandleEnergy(ItemStack stack) {
        return stack.hasCapability(CapabilityEnergy.ENERGY, null) || TeslaIntegration.enabled && TeslaUtils.hasTeslaSupport((ICapabilityProvider)stack, null);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        ItemStack stack = this.getStackInSlot(0);
        this.fluidHandler = stack.func_190916_E() == 1 ? FluidUtil.getFluidHandler((ItemStack)stack) : null;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }
}

