/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block.tile;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.BlockItemRouter;
import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.block.tile.RouterItemHandler;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.container.handler.BufferHandler;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.event.TickEventHandler;
import me.desht.modularrouters.integration.redstoneflux.RFIntegration;
import me.desht.modularrouters.integration.tesla.TeslaIntegration;
import me.desht.modularrouters.item.module.DetectorModule;
import me.desht.modularrouters.item.module.FluidModule;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.item.upgrade.CamouflageUpgrade;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import me.desht.modularrouters.item.upgrade.Upgrade;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.RFEnergyWrapper;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.darkhax.tesla.lib.TeslaUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityItemRouter
extends TileEntity
implements ITickable,
ICamouflageable {
    private static final int N_MODULE_SLOTS = 9;
    private static final int N_UPGRADE_SLOTS = 5;
    private static final int N_BUFFER_SLOTS = 1;
    public static final int COMPILE_MODULES = 1;
    public static final int COMPILE_UPGRADES = 2;
    private static final String NBT_ACTIVE = "Active";
    private static final String NBT_ACTIVE_TIMER = "ActiveTimer";
    private static final String NBT_ECO_MODE = "EcoMode";
    private static final String NBT_SIDES = "Sides";
    private static final String NBT_PERMITTED = "Permitted";
    private static final String NBT_BUFFER = "Buffer";
    private static final String NBT_MODULES = "Modules";
    private static final String NBT_UPGRADES = "Upgrades";
    private static final String NBT_EXTRA = "Extra";
    private static final String NBT_REDSTONE_MODE = "Redstone";
    private static final String NBT_TICK_RATE = "TickRate";
    private static final String NBT_FLUID_TRANSFER_RATE = "FluidTransfer";
    private static final String NBT_ITEMS_PER_TICK = "ItemsPerTick";
    private int counter = 0;
    private int pulseCounter = 0;
    private RouterRedstoneBehaviour redstoneBehaviour = RouterRedstoneBehaviour.ALWAYS;
    private final BufferHandler bufferHandler = new BufferHandler(this);
    private final ItemStackHandler modulesHandler = new RouterItemHandler.ModuleHandler(this);
    private final ItemStackHandler upgradesHandler = new RouterItemHandler.UpgradeHandler(this);
    private final List<CompiledModule> compiledModules = new ArrayList<CompiledModule>();
    private byte recompileNeeded = (byte)3;
    private int tickRate;
    private int itemsPerTick;
    private final int[] upgradeCount;
    private int totalUpgradeCount;
    private int moduleCount;
    private int fluidTransferRate;
    private int fluidTransferRemainingIn;
    private int fluidTransferRemainingOut;
    private final int SIDES;
    private final int[] redstoneLevels;
    private final int[] newRedstoneLevels;
    private final DetectorModule.SignalType[] signalType;
    private final DetectorModule.SignalType[] newSignalType;
    private boolean canEmit;
    private boolean prevCanEmit;
    private final Map<UUID, Pair<Integer, Integer>> playerToSlot;
    private int redstonePower;
    private int lastPower;
    private boolean active;
    private int activeTimer;
    private final Set<UUID> permitted;
    private byte sidesOpen;
    private boolean ecoMode;
    private int ecoCounter;
    private boolean hasPulsedModules;
    private NBTTagCompound extData;
    private IBlockState camouflage;
    private int tunedSyncValue;
    private boolean executing;

    public TileEntityItemRouter() {
        this.tickRate = ConfigHandler.router.baseTickRate;
        this.itemsPerTick = 1;
        this.upgradeCount = new int[ItemUpgrade.UpgradeType.values().length];
        this.fluidTransferRemainingIn = 0;
        this.fluidTransferRemainingOut = 0;
        this.SIDES = EnumFacing.values().length;
        this.redstoneLevels = new int[this.SIDES];
        this.newRedstoneLevels = new int[this.SIDES];
        this.signalType = new DetectorModule.SignalType[this.SIDES];
        this.newSignalType = new DetectorModule.SignalType[this.SIDES];
        this.playerToSlot = new HashMap<UUID, Pair<Integer, Integer>>();
        this.redstonePower = -1;
        this.activeTimer = 0;
        this.permitted = Sets.newHashSet();
        this.ecoMode = false;
        this.ecoCounter = ConfigHandler.router.ecoTimeout;
        this.hasPulsedModules = false;
        this.camouflage = null;
        this.tunedSyncValue = -1;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.item_router.name", new Object[0]);
    }

    public IItemHandler getBuffer() {
        return this.bufferHandler;
    }

    public IItemHandler getModules() {
        return this.modulesHandler;
    }

    public IItemHandler getUpgrades() {
        return this.upgradesHandler;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        NBTTagList list = new NBTTagList();
        for (UUID u : this.permitted) {
            list.func_74742_a((NBTBase)new NBTTagString(u.toString()));
        }
        compound.func_74782_a(NBT_PERMITTED, (NBTBase)list);
        compound.func_74768_a("ModuleCount", this.getModuleCount());
        for (ItemUpgrade.UpgradeType type : ItemUpgrade.UpgradeType.values()) {
            compound.func_74768_a("UpgradeCount." + (Object)((Object)type), this.getUpgradeCount(type));
        }
        compound.func_74774_a(NBT_REDSTONE_MODE, (byte)this.redstoneBehaviour.ordinal());
        compound.func_74757_a(NBT_ECO_MODE, this.ecoMode);
        compound.func_74768_a(NBT_TICK_RATE, this.tickRate);
        compound.func_74768_a(NBT_ITEMS_PER_TICK, this.itemsPerTick);
        compound.func_74768_a(NBT_FLUID_TRANSFER_RATE, this.fluidTransferRate);
        compound.func_74757_a(NBT_ACTIVE, this.active);
        compound.func_74774_a(NBT_SIDES, this.sidesOpen);
        if (this.camouflage != null) {
            CamouflageUpgrade.writeToNBT(compound, this.camouflage);
        }
        return compound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.processClientSync(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.processClientSync(pkt.func_148857_g());
    }

    private void processClientSync(NBTTagCompound compound) {
        boolean rerenderNeeded = false;
        NBTTagList l = compound.func_150295_c(NBT_PERMITTED, 8);
        this.permitted.clear();
        for (int i = 0; i < l.func_74745_c(); ++i) {
            this.permitted.add(UUID.fromString(l.func_150307_f(i)));
        }
        this.moduleCount = compound.func_74762_e("ModuleCount");
        int mufflers = this.getUpgradeCount(ItemUpgrade.UpgradeType.MUFFLER);
        for (ItemUpgrade.UpgradeType type : ItemUpgrade.UpgradeType.values()) {
            this.upgradeCount[type.ordinal()] = compound.func_74762_e("UpgradeCount." + (Object)((Object)type));
        }
        if (mufflers < 3 && this.getUpgradeCount(ItemUpgrade.UpgradeType.MUFFLER) >= 3 || mufflers >= 3 && this.getUpgradeCount(ItemUpgrade.UpgradeType.MUFFLER) < 3) {
            rerenderNeeded = true;
        }
        RouterRedstoneBehaviour newRedstoneBehaviour = RouterRedstoneBehaviour.values()[compound.func_74771_c(NBT_REDSTONE_MODE)];
        this.setRedstoneBehaviour(newRedstoneBehaviour);
        this.tickRate = compound.func_74762_e(NBT_TICK_RATE);
        this.itemsPerTick = compound.func_74762_e(NBT_ITEMS_PER_TICK);
        this.fluidTransferRate = compound.func_74762_e(NBT_FLUID_TRANSFER_RATE);
        boolean newActive = compound.func_74767_n(NBT_ACTIVE);
        byte newSidesOpen = compound.func_74771_c(NBT_SIDES);
        boolean newEco = compound.func_74767_n(NBT_ECO_MODE);
        IBlockState camo = CamouflageUpgrade.readFromNBT(compound);
        this.setActive(newActive);
        this.setSidesOpen(newSidesOpen);
        this.setEcoMode(newEco);
        this.setCamouflage(camo);
        if (rerenderNeeded) {
            this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.bufferHandler.getFluidHandler() != null) {
            return true;
        }
        if (this.hasForgeEnergyCap(cap, this.getBufferItemStack())) {
            return true;
        }
        if (TeslaIntegration.enabled && this.hasTeslaCap(cap, this.getBufferItemStack())) {
            return true;
        }
        return super.hasCapability(cap, side);
    }

    private boolean hasForgeEnergyCap(Capability<?> cap, ItemStack stack) {
        return cap == CapabilityEnergy.ENERGY && (stack.hasCapability(CapabilityEnergy.ENERGY, null) || RFIntegration.enabled && stack.func_77973_b() instanceof IEnergyContainerItem);
    }

    private boolean hasTeslaCap(Capability<?> cap, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return cap == TeslaCapabilities.CAPABILITY_HOLDER && TeslaUtils.isTeslaHolder((ICapabilityProvider)stack, null) || cap == TeslaCapabilities.CAPABILITY_PRODUCER && TeslaUtils.isTeslaProducer((ICapabilityProvider)stack, null) || cap == TeslaCapabilities.CAPABILITY_CONSUMER && TeslaUtils.isTeslaConsumer((ICapabilityProvider)stack, null);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.bufferHandler);
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.bufferHandler.getFluidHandler());
        }
        ItemStack stack = this.getBufferItemStack();
        if (!stack.func_190926_b()) {
            if (cap == CapabilityEnergy.ENERGY) {
                if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                    return (T)CapabilityEnergy.ENERGY.cast(stack.getCapability(CapabilityEnergy.ENERGY, null));
                }
                if (RFIntegration.enabled && stack.func_77973_b() instanceof IEnergyContainerItem) {
                    return (T)CapabilityEnergy.ENERGY.cast((Object)new RFEnergyWrapper(stack));
                }
            }
            if (TeslaIntegration.enabled) {
                if (cap == TeslaCapabilities.CAPABILITY_HOLDER) {
                    return (T)TeslaCapabilities.CAPABILITY_HOLDER.cast((Object)TeslaUtils.getTeslaHolder((ICapabilityProvider)stack, null));
                }
                if (cap == TeslaCapabilities.CAPABILITY_CONSUMER) {
                    return (T)TeslaCapabilities.CAPABILITY_CONSUMER.cast((Object)TeslaUtils.getTeslaConsumer((ICapabilityProvider)stack, null));
                }
                if (cap == TeslaCapabilities.CAPABILITY_PRODUCER) {
                    return (T)TeslaCapabilities.CAPABILITY_PRODUCER.cast((Object)TeslaUtils.getTeslaProducer((ICapabilityProvider)stack, null));
                }
            }
        }
        return (T)super.getCapability(cap, side);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.bufferHandler.deserializeNBT(nbt.func_74775_l(NBT_BUFFER));
        this.modulesHandler.deserializeNBT(nbt.func_74775_l(NBT_MODULES));
        this.upgradesHandler.deserializeNBT(nbt.func_74775_l(NBT_UPGRADES));
        try {
            this.redstoneBehaviour = RouterRedstoneBehaviour.valueOf(nbt.func_74779_i(NBT_REDSTONE_MODE));
        }
        catch (IllegalArgumentException e) {
            this.redstoneBehaviour = RouterRedstoneBehaviour.ALWAYS;
        }
        this.active = nbt.func_74767_n(NBT_ACTIVE);
        this.activeTimer = nbt.func_74762_e(NBT_ACTIVE_TIMER);
        this.ecoMode = nbt.func_74767_n(NBT_ECO_MODE);
        NBTTagCompound ext = nbt.func_74775_l(NBT_EXTRA);
        NBTTagCompound ext1 = this.getExtData();
        for (String key : ext.func_150296_c()) {
            ext1.func_74782_a(key, ext.func_74781_a(key));
        }
        this.counter = -1;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74782_a(NBT_BUFFER, (NBTBase)this.bufferHandler.serializeNBT());
        nbt.func_74782_a(NBT_MODULES, (NBTBase)this.modulesHandler.serializeNBT());
        nbt.func_74782_a(NBT_UPGRADES, (NBTBase)this.upgradesHandler.serializeNBT());
        nbt.func_74778_a(NBT_REDSTONE_MODE, this.redstoneBehaviour.name());
        nbt.func_74757_a(NBT_ACTIVE, this.active);
        nbt.func_74768_a(NBT_ACTIVE_TIMER, this.activeTimer);
        nbt.func_74757_a(NBT_ECO_MODE, this.ecoMode);
        NBTTagCompound ext = new NBTTagCompound();
        NBTTagCompound ext1 = this.getExtData();
        for (String key : ext1.func_150296_c()) {
            ext.func_74782_a(key, ext1.func_74781_a(key));
        }
        nbt.func_74782_a(NBT_EXTRA, (NBTBase)ext);
        return nbt;
    }

    public void func_73660_a() {
        if (this.recompileNeeded != 0) {
            this.compile();
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ++this.counter;
        ++this.pulseCounter;
        if (this.getRedstoneBehaviour() == RouterRedstoneBehaviour.PULSE) {
            if (this.activeTimer > 0 && --this.activeTimer == 0) {
                this.setActive(false);
            }
        } else if (this.counter >= this.getTickRate()) {
            this.allocateFluidTransfer(this.counter);
            this.executeModules(false);
            this.counter = 0;
        }
        if (this.ecoMode) {
            if (this.active) {
                this.ecoCounter = ConfigHandler.router.ecoTimeout;
            } else if (this.ecoCounter > 0) {
                --this.ecoCounter;
            }
        }
    }

    private void executeModules(boolean pulsed) {
        boolean powered;
        this.executing = true;
        boolean newActive = false;
        boolean bl = powered = pulsed || this.getRedstonePower() > 0;
        if (this.redstoneBehaviour.shouldRun(powered, pulsed)) {
            if (this.prevCanEmit || this.canEmit) {
                Arrays.fill(this.newRedstoneLevels, 0);
                Arrays.fill((Object[])this.newSignalType, (Object)DetectorModule.SignalType.NONE);
            }
            for (CompiledModule cm : this.compiledModules) {
                if (cm == null || !cm.hasTarget() || !cm.shouldRun(powered, pulsed) || !cm.execute(this)) continue;
                newActive = true;
                if (!cm.termination()) continue;
                break;
            }
            if (this.prevCanEmit || this.canEmit) {
                this.handleRedstoneEmission();
            }
        }
        this.setActive(newActive);
        this.prevCanEmit = this.canEmit;
        this.executing = false;
    }

    public int getTickRate() {
        return this.ecoMode && this.ecoCounter == 0 ? ConfigHandler.router.lowPowerTickRate : this.tickRate;
    }

    public RouterRedstoneBehaviour getRedstoneBehaviour() {
        return this.redstoneBehaviour;
    }

    public void setRedstoneBehaviour(RouterRedstoneBehaviour redstoneBehaviour) {
        this.redstoneBehaviour = redstoneBehaviour;
        if (redstoneBehaviour == RouterRedstoneBehaviour.PULSE) {
            this.lastPower = this.getRedstonePower();
        }
        this.handleSync(false);
    }

    public boolean isActive() {
        return this.active;
    }

    private void setActive(boolean newActive) {
        if (this.active != newActive) {
            this.active = newActive;
            this.handleSync(true);
        }
    }

    public boolean isSideOpen(Module.RelativeDirection side) {
        return (this.sidesOpen & side.getMask()) != 0;
    }

    private void setSidesOpen(byte sidesOpen) {
        if (this.sidesOpen != sidesOpen) {
            this.sidesOpen = sidesOpen;
            this.handleSync(true);
        }
    }

    public void setEcoMode(boolean newEco) {
        if (newEco != this.ecoMode) {
            this.ecoMode = newEco;
            this.ecoCounter = ConfigHandler.router.ecoTimeout;
            this.handleSync(false);
        }
    }

    @Override
    public IBlockState getCamouflage() {
        return this.camouflage;
    }

    @Override
    public void setCamouflage(IBlockState newCamouflage) {
        if (newCamouflage != this.camouflage) {
            this.camouflage = newCamouflage;
            this.handleSync(true);
        }
    }

    private void handleSync(boolean renderUpdate) {
        if (!this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
        } else if (this.func_145831_w().field_72995_K && renderUpdate) {
            this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    private void compile() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.compileModules();
        this.compileUpgrades();
        if (this.tunedSyncValue >= 0) {
            this.counter = this.calculateSyncCounter();
        } else if (this.counter < 0) {
            this.counter = new Random().nextInt(this.tickRate);
        }
        if (this.recompileNeeded != 0) {
            IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
            this.func_145831_w().func_175685_c(this.field_174879_c, state.func_177230_c(), true);
            this.func_70296_d();
            this.recompileNeeded = 0;
        }
    }

    private void compileModules() {
        if ((this.recompileNeeded & 1) != 0) {
            this.setHasPulsedModules(false);
            byte newSidesOpen = 0;
            for (CompiledModule cm : this.compiledModules) {
                cm.cleanup(this);
            }
            this.compiledModules.clear();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.modulesHandler.getStackInSlot(i);
                Module m = ItemModule.getModule(stack);
                if (m == null) continue;
                CompiledModule cms = m.compile(this, stack);
                this.compiledModules.add(cms);
                cms.onCompiled(this);
                newSidesOpen = (byte)(newSidesOpen | cms.getDirection().getMask());
            }
            this.moduleCount = this.compiledModules.size();
            this.setSidesOpen(newSidesOpen);
        }
    }

    private void compileUpgrades() {
        if ((this.recompileNeeded & 2) != 0) {
            Arrays.fill(this.upgradeCount, 0);
            this.totalUpgradeCount = 0;
            this.permitted.clear();
            this.setCamouflage(null);
            this.tunedSyncValue = -1;
            for (int i = 0; i < 5; ++i) {
                ItemStack stack = this.upgradesHandler.getStackInSlot(i);
                Upgrade upgrade = ItemUpgrade.getUpgrade(stack);
                if (upgrade == null) continue;
                int n = stack.func_77952_i();
                this.upgradeCount[n] = this.upgradeCount[n] + stack.func_190916_E();
                this.totalUpgradeCount += stack.func_190916_E();
                upgrade.onCompiled(stack, this);
            }
            this.itemsPerTick = 1 << Math.min(6, this.getUpgradeCount(ItemUpgrade.UpgradeType.STACK));
            this.tickRate = Math.max(ConfigHandler.router.hardMinTickRate, ConfigHandler.router.baseTickRate - ConfigHandler.router.ticksPerUpgrade * this.getUpgradeCount(ItemUpgrade.UpgradeType.SPEED));
            this.fluidTransferRate = Math.min(ConfigHandler.router.fluidMaxTransferRate, ConfigHandler.router.fluidBaseTransferRate + this.getUpgradeCount(ItemUpgrade.UpgradeType.FLUID) * ConfigHandler.router.mBperFluidUpgrade);
        }
    }

    public void setTunedSyncValue(int newValue) {
        this.tunedSyncValue = newValue;
    }

    private int calculateSyncCounter() {
        int tuning = this.tunedSyncValue % this.tickRate;
        int compileTime = (int)TickEventHandler.TickCounter % this.tickRate;
        int delta = tuning - compileTime;
        if (delta <= 0) {
            delta += this.tickRate;
        }
        return this.tickRate - delta;
    }

    public void setAllowRedstoneEmission(boolean allow) {
        this.canEmit = allow;
        this.func_145831_w().func_175656_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockItemRouter.CAN_EMIT, (Comparable)Boolean.valueOf(this.canEmit)));
    }

    public int getModuleCount() {
        return this.moduleCount;
    }

    public int getUpgradeCount() {
        return this.totalUpgradeCount;
    }

    public int getUpgradeCount(ItemUpgrade.UpgradeType type) {
        return this.upgradeCount[type.ordinal()];
    }

    public void recompileNeeded(int what) {
        this.recompileNeeded = (byte)(this.recompileNeeded | what);
    }

    public int getItemsPerTick() {
        return this.itemsPerTick;
    }

    private void allocateFluidTransfer(int ticks) {
        int maxTransfer = ConfigHandler.router.baseTickRate * this.fluidTransferRate;
        this.fluidTransferRemainingIn = Math.min(this.fluidTransferRemainingIn + ticks * this.fluidTransferRate, maxTransfer);
        this.fluidTransferRemainingOut = Math.min(this.fluidTransferRemainingOut + ticks * this.fluidTransferRate, maxTransfer);
    }

    public int getFluidTransferRate() {
        return this.fluidTransferRate;
    }

    public int getCurrentFluidTransferAllowance(FluidModule.FluidDirection dir) {
        return dir == FluidModule.FluidDirection.IN ? this.fluidTransferRemainingIn : this.fluidTransferRemainingOut;
    }

    public void transferredFluid(int amount, FluidModule.FluidDirection dir) {
        switch (dir) {
            case IN: {
                if (this.fluidTransferRemainingIn < amount) {
                    ModularRouters.logger.warn("fluid transfer: " + this.fluidTransferRemainingIn + " < " + amount);
                }
                this.fluidTransferRemainingIn = Math.max(0, this.fluidTransferRemainingIn - amount);
                break;
            }
            case OUT: {
                if (this.fluidTransferRemainingOut < amount) {
                    ModularRouters.logger.warn("fluid transfer: " + this.fluidTransferRemainingOut + " < " + amount);
                }
                this.fluidTransferRemainingOut = Math.max(0, this.fluidTransferRemainingOut - amount);
                break;
            }
        }
    }

    public EnumFacing getAbsoluteFacing(Module.RelativeDirection direction) {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        return direction.toEnumFacing((EnumFacing)state.func_177229_b((IProperty)BlockItemRouter.FACING));
    }

    public ItemStack getBufferItemStack() {
        return this.bufferHandler.getStackInSlot(0);
    }

    public void playerConfiguringModule(EntityPlayer player, int slotIndex, int filterIndex) {
        if (slotIndex >= 0) {
            this.playerToSlot.put(player.func_110124_au(), (Pair<Integer, Integer>)Pair.of((Object)slotIndex, (Object)filterIndex));
        } else {
            this.playerToSlot.remove(player.func_110124_au());
        }
    }

    public void playerConfiguringModule(EntityPlayer player, int slotIndex) {
        this.playerConfiguringModule(player, slotIndex, -1);
    }

    public void clearConfigSlot(EntityPlayer player) {
        this.playerToSlot.remove(player.func_110124_au());
    }

    public int getModuleConfigSlot(EntityPlayer player) {
        if (this.playerToSlot.containsKey(player.func_110124_au())) {
            return (Integer)this.playerToSlot.get(player.func_110124_au()).getLeft();
        }
        return -1;
    }

    public int getFilterConfigSlot(EntityPlayer player) {
        if (this.playerToSlot.containsKey(player.func_110124_au())) {
            return (Integer)this.playerToSlot.get(player.func_110124_au()).getRight();
        }
        return -1;
    }

    public void checkForRedstonePulse() {
        this.redstonePower = this.calculateIncomingRedstonePower(this.field_174879_c);
        if (this.executing) {
            return;
        }
        if (this.redstoneBehaviour == RouterRedstoneBehaviour.PULSE || this.hasPulsedModules && this.redstoneBehaviour == RouterRedstoneBehaviour.ALWAYS) {
            if (this.redstonePower > this.lastPower && this.pulseCounter >= this.tickRate) {
                this.allocateFluidTransfer(Math.min(this.pulseCounter, ConfigHandler.router.baseTickRate));
                this.executeModules(true);
                this.pulseCounter = 0;
                if (this.active) {
                    this.activeTimer = this.tickRate;
                }
            }
            this.lastPower = this.redstonePower;
        }
    }

    public void emitRedstone(Module.RelativeDirection direction, int power, DetectorModule.SignalType signalType) {
        if (direction == Module.RelativeDirection.NONE) {
            Arrays.fill(this.newRedstoneLevels, power);
            Arrays.fill((Object[])this.newSignalType, (Object)signalType);
        } else {
            EnumFacing facing = this.getAbsoluteFacing(direction).func_176734_d();
            this.newRedstoneLevels[facing.ordinal()] = power;
            this.newSignalType[facing.ordinal()] = signalType;
        }
    }

    public int getRedstoneLevel(EnumFacing facing, boolean strong) {
        if (!this.canEmit) {
            return -1;
        }
        int i = facing.ordinal();
        if (strong) {
            return this.signalType[i] == DetectorModule.SignalType.STRONG ? this.redstoneLevels[i] : 0;
        }
        return this.signalType[i] != DetectorModule.SignalType.NONE ? this.redstoneLevels[i] : 0;
    }

    private void handleRedstoneEmission() {
        boolean notifyOwnNeighbours = false;
        EnumSet<EnumFacing> toNotify = EnumSet.noneOf(EnumFacing.class);
        if (!this.canEmit) {
            notifyOwnNeighbours = true;
            for (EnumFacing f : EnumFacing.values()) {
                if (this.signalType[f.ordinal()] != DetectorModule.SignalType.STRONG) continue;
                toNotify.add(f.func_176734_d());
            }
            Arrays.fill(this.redstoneLevels, 0);
            Arrays.fill((Object[])this.signalType, (Object)DetectorModule.SignalType.NONE);
        } else {
            for (EnumFacing facing : EnumFacing.values()) {
                int i = facing.ordinal();
                if (this.newSignalType[i] != this.signalType[i]) {
                    toNotify.add(facing.func_176734_d());
                    this.signalType[i] = this.newSignalType[i];
                }
                if (this.newRedstoneLevels[i] == this.redstoneLevels[i]) continue;
                notifyOwnNeighbours = true;
                if (this.newSignalType[i] == DetectorModule.SignalType.STRONG) {
                    toNotify.add(facing.func_176734_d());
                }
                this.redstoneLevels[i] = this.newRedstoneLevels[i];
            }
        }
        for (EnumFacing f : toNotify) {
            BlockPos pos2 = this.field_174879_c.func_177972_a(f);
            this.func_145831_w().func_175685_c(pos2, this.func_145831_w().func_180495_p(pos2).func_177230_c(), true);
        }
        if (notifyOwnNeighbours) {
            this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c(), true);
        }
    }

    public void addPermittedIds(Set<UUID> permittedIds) {
        this.permitted.addAll(permittedIds);
    }

    public boolean isPermitted(EntityPlayer player) {
        if (this.permitted.isEmpty() || this.permitted.contains(player.func_110124_au())) {
            return true;
        }
        for (EnumHand hand : EnumHand.values()) {
            if (player.func_184586_b(hand).func_77973_b() != RegistrarMR.OVERRIDE_CARD) continue;
            return true;
        }
        return false;
    }

    public boolean isBufferFull() {
        ItemStack stack = this.bufferHandler.getStackInSlot(0);
        return !stack.func_190926_b() && stack.func_190916_E() >= stack.func_77976_d();
    }

    public boolean isBufferEmpty() {
        return this.bufferHandler.getStackInSlot(0).func_190926_b();
    }

    public ItemStack peekBuffer(int amount) {
        return this.bufferHandler.extractItem(0, amount, true);
    }

    public ItemStack extractBuffer(int amount) {
        return this.bufferHandler.extractItem(0, amount, false);
    }

    public ItemStack insertBuffer(ItemStack stack) {
        return this.bufferHandler.insertItem(0, stack, false);
    }

    public void setBufferItemStack(ItemStack stack) {
        this.bufferHandler.setStackInSlot(0, stack);
    }

    public boolean getEcoMode() {
        return this.ecoMode;
    }

    public void setHasPulsedModules(boolean hasPulsedModules) {
        this.hasPulsedModules = hasPulsedModules;
    }

    public int getRedstonePower() {
        if (this.redstonePower < 0) {
            this.redstonePower = this.calculateIncomingRedstonePower(this.field_174879_c);
        }
        return this.redstonePower;
    }

    private int calculateIncomingRedstonePower(BlockPos pos) {
        int power = 0;
        for (EnumFacing facing : EnumFacing.values()) {
            if (this.getExtData().func_74762_e("ExtruderDist" + facing) > 0) continue;
            int p = this.func_145831_w().func_175651_c(pos.func_177972_a(facing), facing);
            if (p >= 15) {
                return p;
            }
            if (p <= power) continue;
            power = p;
        }
        return power;
    }

    public NBTTagCompound getExtData() {
        if (this.extData == null) {
            this.extData = new NBTTagCompound();
        }
        return this.extData;
    }

    public static TileEntityItemRouter getRouterAt(IBlockAccess world, BlockPos routerPos) {
        TileEntity te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(routerPos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(routerPos);
        return te instanceof TileEntityItemRouter ? (TileEntityItemRouter)te : null;
    }

    public void playSound(EntityPlayer player, BlockPos pos, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (this.getUpgradeCount(ItemUpgrade.UpgradeType.MUFFLER) == 0) {
            this.func_145831_w().func_184133_a(player, pos, sound, category, volume, pitch);
        }
    }

    public void notifyModules() {
        for (CompiledModule cm : this.compiledModules) {
            cm.onNeighbourChange(this);
        }
    }

    public int getModuleSlotCount() {
        return 9;
    }

    public int getUpgradeSlotCount() {
        return 5;
    }

    public int getBufferSlotCount() {
        return 1;
    }
}

