/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity;

import cd4017be.api.IAbstractTile;
import cd4017be.lib.Lib;
import cd4017be.lib.block.OrientedBlock;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.lib.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseTileEntity
extends TileEntity
implements IAbstractTile {
    private IBlockState blockState;
    private Chunk chunk;
    protected boolean unloaded = true;
    protected boolean redraw;
    public static final int SAVE = 0;
    public static final int CLIENT = 1;
    public static final int SYNC = 2;
    public static final int REDRAW = 3;
    public static final int ITEM = 4;

    public BaseTileEntity() {
    }

    public BaseTileEntity(IBlockState state) {
        this.blockState = state;
        this.field_145854_h = this.blockState.func_177230_c();
    }

    public IBlockState getBlockState() {
        if (this.blockState == null) {
            if (this.chunk == null) {
                Lib.LOG.fatal("invalid TileEntity state: chunk = null, unloaded = {}, world = {}, pos = {}", (Object)this.unloaded, (Object)this.field_145850_b, (Object)this.field_174879_c);
                if (this.field_145850_b != null) {
                    this.chunk = this.field_145850_b.func_72863_F().func_186026_b(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                }
                if (this.chunk == null) {
                    Lib.LOG.fatal("no world set or chunk not loaded -> can't provide BlockState, using air, may crash later on!");
                    return Blocks.field_150350_a.func_176223_P();
                }
            }
            this.blockState = this.chunk.func_177435_g(this.field_174879_c);
            this.field_145854_h = this.blockState.func_177230_c();
        }
        return this.blockState;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public Orientation getOrientation() {
        IBlockState state = this.getBlockState();
        if (this.field_145854_h instanceof OrientedBlock) {
            return (Orientation)((Object)state.func_177229_b((IProperty)((OrientedBlock)this.field_145854_h).orientProp));
        }
        return Orientation.N;
    }

    @Deprecated
    public void markUpdate() {
        if (this.unloaded) {
            return;
        }
        IBlockState state = this.getBlockState();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void func_70296_d() {
        if (this.chunk != null) {
            this.chunk.func_76630_e();
        }
    }

    public void markDirty(int mode) {
        if (this.unloaded) {
            return;
        }
        switch (mode) {
            case 3: {
                this.redraw = true;
            }
            case 2: {
                IBlockState state = this.getBlockState();
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
            }
            case 0: {
                this.chunk.func_76630_e();
            }
        }
    }

    protected void storeState(NBTTagCompound nbt, int mode) {
    }

    protected void loadState(NBTTagCompound nbt, int mode) {
    }

    @Deprecated
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.storeState(nbt, 0);
        return super.func_189515_b(nbt);
    }

    @Deprecated
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.loadState(nbt, 0);
    }

    @Deprecated
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.storeState(nbt, 1);
        return this.func_189515_b(nbt);
    }

    @Deprecated
    public void handleUpdateTag(NBTTagCompound nbt) {
        this.func_145839_a(nbt);
        this.loadState(nbt, 1);
    }

    @Deprecated
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.storeState(nbt, 2);
        if (nbt.func_82582_d()) {
            return null;
        }
        if (this.redraw) {
            nbt.func_74757_a("", true);
            this.redraw = false;
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    @Deprecated
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.redraw = nbt.func_74767_n("");
        this.loadState(nbt, 2);
        if (this.redraw) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K ? this instanceof ITickableServerOnly : this instanceof ITickableClientOnly) {
            this.field_145850_b.field_175730_i.remove(this);
        }
        this.chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
        this.setupData();
        this.unloaded = false;
    }

    protected void onUnload() {
        this.unloaded = true;
        this.chunk = null;
        this.clearData();
    }

    public void onChunkUnload() {
        this.onUnload();
    }

    public void func_145843_s() {
        this.field_145846_f = true;
        this.onUnload();
    }

    @Deprecated
    protected void setupData() {
    }

    @Deprecated
    protected void clearData() {
    }

    @Override
    public boolean invalid() {
        return this.unloaded;
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        if (this.chunk == null && worldIn.func_175667_e(this.field_174879_c)) {
            this.chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
        }
    }

    public TileEntity getTileOnSide(EnumFacing s) {
        return Utils.neighborTile(this, s);
    }

    public BlockPos pos() {
        return this.field_174879_c;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    protected List<ItemStack> makeDefaultDrops() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.storeState(nbt, 4);
        return this.makeDefaultDrops(nbt);
    }

    protected List<ItemStack> makeDefaultDrops(NBTTagCompound tag) {
        this.getBlockState();
        ItemStack item = new ItemStack(this.field_145854_h, 1, this.field_145854_h.func_180651_a(this.blockState));
        item.func_77982_d(tag);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(1);
        list.add(item);
        return list;
    }

    public boolean canPlayerAccessUI(EntityPlayer player) {
        return !player.field_70128_L && !this.unloaded && this.func_145835_a(player.field_70165_t, player.field_70163_u, player.field_70161_v) < 64.0;
    }

    public String getName() {
        return TooltipUtil.translate(this.func_145838_q().func_149739_a().replace("tile.", "gui.").concat(".name"));
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.blockState = null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return newState.func_177230_c() != oldState.func_177230_c();
    }

    @Override
    public boolean isClient() {
        return this.field_145850_b.field_72995_K;
    }

    public static interface ITickableClientOnly
    extends ITickable {
    }

    public static interface ITickableServerOnly
    extends ITickable {
    }
}

