/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.Lib;
import cd4017be.lib.script.Compiler;
import cd4017be.lib.script.Context;
import cd4017be.lib.script.Function;
import cd4017be.lib.script.Module;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.Script;
import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.util.Stack;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptException;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class ModelContext
extends Context {
    private static final double[] defaultVertex = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0};
    private static final String defaultFormat = "xyzuvrgba";
    private static final int maxStates = 8;
    private static final String cfNames = "BTNSWE";
    private static final boolean[][] rect = new boolean[][]{{false, false, true, true}, {false, true, true, false}};
    Stack<State> states = new Stack(8);
    List<Quad>[] quads;
    ResourceLocation loadPath;

    public ModelContext(ResourceLocation loadPath) {
        super(Lib.LOG);
        this.loadPath = loadPath;
        this.defFunc.put("add", p -> {
            State state = this.states.get();
            for (Object o : p.getArrayOrAll()) {
                Quad quadi = (Quad)o;
                this.quads[quadi.cullFace + 1].add(state.transform(quadi));
            }
            return null;
        });
        this.defFunc.put("push", p -> {
            if (this.states.isFull()) {
                throw new IllegalStateException("can't push anymore: max state depth reached!");
            }
            this.states.add(this.states.get().copy());
            return null;
        });
        this.defFunc.put("pop", p -> {
            if (this.states.getPos() <= 0) {
                throw new IllegalStateException("can't pop anymore: already at origin state!");
            }
            this.states.rem();
            return null;
        });
        this.defFunc.put("rotate", p -> {
            double[] vec = p.getVectorOrAll();
            State state = this.states.get();
            vec[3] = Math.toRadians(vec[3]);
            Matrix4d mat = new Matrix4d();
            mat.set(new AxisAngle4d(vec));
            state.mulMat(mat);
            return null;
        });
        this.defFunc.put("translate", p -> {
            double[] vec = p.getVectorOrAll();
            State state = this.states.get();
            Matrix4d mat = new Matrix4d();
            mat.set(new Vector3d(vec));
            state.mulMat(mat);
            return null;
        });
        this.defFunc.put("scale", p -> {
            double[] vec = p.getVectorOrAll();
            State state = this.states.get();
            Matrix4d mat = new Matrix4d();
            mat.setM00(vec[0]);
            mat.setM11(vec[1]);
            mat.setM22(vec[2]);
            mat.setM33(1.0);
            state.mulMat(mat);
            return null;
        });
        this.defFunc.put("offsetUV", p -> {
            double[] vec = p.getVectorOrAll();
            State state = this.states.get();
            state.oU += vec[0] * state.sU;
            state.oV += vec[1] * state.sV;
            return null;
        });
        this.defFunc.put("scaleUV", p -> {
            double[] vec = p.getVectorOrAll();
            State state = this.states.get();
            state.sU *= vec[0];
            state.sV *= vec[1];
            return null;
        });
        this.defFunc.put("color", p -> {
            double[] vec = p.getVectorOrAll();
            State state = this.states.get();
            for (int j = 0; j < vec.length; ++j) {
                state.sColor[j] = vec[j];
            }
            return null;
        });
        this.defFunc.put("texIdx", p -> {
            int val = p.getIndex(0);
            State state = this.states.get();
            state.texOfs += val;
            return null;
        });
        this.defFunc.put("quad", p -> {
            Quad quad = new Quad();
            String format = p.getString(4);
            int n = quad.tex = p.param.length > 5 ? (int)p.getNumber(5) : 0;
            if (format == null) {
                format = defaultFormat;
            }
            quad.cullFace = cfNames.indexOf(format.charAt(format.length() - 1));
            for (int i = 0; i < 4; ++i) {
                double[] vec = p.getVector(i);
                double[] vert = (double[])defaultVertex.clone();
                int n2 = 0;
                for (int j = 0; j < format.length(); ++j) {
                    int q = defaultFormat.indexOf(format.charAt(j));
                    if (q < 0) continue;
                    vert[q] = vec[n2++];
                }
                quad.vertices[i] = vert;
            }
            return quad;
        });
        this.defFunc.put("rect", p -> {
            Quad quad = new Quad();
            String format = p.getString(2);
            quad.tex = p.param.length > 3 ? (int)p.getNumber(3) : 0;
            quad.cullFace = format.length() <= 3 ? -1 : cfNames.indexOf(format.charAt(3));
            int t = format.indexOf(45);
            int tN = t < 0 ? format.indexOf(43) + 3 : t;
            boolean inv = tN >= 3;
            tN %= 3;
            t = format.indexOf(117);
            int tU = t < 0 ? format.indexOf(85) + 3 : t;
            t = format.indexOf(118);
            int tV = t < 0 ? format.indexOf(86) + 3 : t;
            double[] pos = p.getVector(0);
            double[] tex = p.getVector(1);
            for (int i = 0; i < 4; ++i) {
                double[] vert = quad.vertices[inv ? i : 3 - i];
                vert[0] = pos[(tN == 0 ? inv : rect[tN - 1][i]) ? 3 : 0];
                vert[1] = pos[(tN == 1 ? inv : rect[(tN + 1) % 3][i]) ? 4 : 1];
                vert[2] = pos[(tN == 2 ? inv : rect[tN][i]) ? 5 : 2];
                vert[3] = tex[tU >= 3 ^ rect[(5 - tU + tN) % 3][i] ? 2 : 0];
                vert[4] = tex[tV >= 3 ^ rect[(5 - tV + tN) % 3][i] ? 3 : 1];
                vert[5] = 1.0;
                vert[6] = 1.0;
                vert[7] = 1.0;
                vert[8] = 1.0;
            }
            return quad;
        });
        this.quads = new List[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
    }

    @Override
    public void reset() {
        super.reset();
        for (List<Quad> list : this.quads) {
            list.clear();
        }
        this.states.setPos(-1);
        State state = new State();
        state.matrix = new Matrix4d();
        state.matrix.setIdentity();
        state.sU = 1.0;
        state.sV = 1.0;
        state.sColor = new double[]{1.0, 1.0, 1.0, 1.0};
        this.states.add(state);
    }

    public Module getOrLoad(String name, IResourceManager manager) throws Exception {
        Function func;
        Module m = (Module)this.modules.get(name);
        if (m != null) {
            return m;
        }
        IResource res = manager.func_110536_a(new ResourceLocation(this.loadPath.toString() + name.replace('.', '/') + ".rcp"));
        Script script = Compiler.compile(this, name, new InputStreamReader(res.func_110527_b()));
        IOperand var = script.variables.remove("dependencies");
        if (var instanceof Array) {
            try {
                for (Object o : (Object[])var.value()) {
                    if (!(o instanceof String)) continue;
                    this.getOrLoad((String)o, manager);
                }
            }
            catch (Exception e) {
                throw (ScriptException)new ScriptException("failed loading dependency for script:", name, 0).initCause(e);
            }
        }
        if ((func = script.methods.remove("init")) != null) {
            func.apply(new Parameters(new IOperand[0]));
        }
        return script;
    }

    public void run(Module script, String cmd) throws NoSuchMethodException, ScriptException {
        Parameters param;
        int p = cmd.indexOf(40);
        if (p >= 0) {
            int q = cmd.indexOf(41, p);
            if (q < 0) {
                q = cmd.length();
            }
            param = this.parseParam(cmd.substring(p + 1, q), script);
            cmd = cmd.substring(0, p);
        } else {
            param = new Parameters(new IOperand[0]);
        }
        this.reset();
        script.invoke(cmd, param);
    }

    private Parameters parseParam(String s, Module m) {
        if ((s = s.trim()).isEmpty()) {
            return new Parameters(new IOperand[0]);
        }
        String[] args = s.split(",");
        IOperand[] arr = new IOperand[args.length];
        for (int i = 0; i < args.length; ++i) {
            try {
                arr[i] = new Number(Double.parseDouble(args[i]));
                continue;
            }
            catch (NumberFormatException e) {
                arr[i] = m.read(args[i]);
            }
        }
        return new Parameters(arr);
    }

    static class Quad
    implements IOperand {
        double[][] vertices = new double[4][9];
        int tex;
        int cullFace;

        Quad() {
        }

        @Override
        public boolean asBool() throws Error {
            return false;
        }

        @Override
        public Object value() {
            return this;
        }
    }

    private static class AdvancedState
    extends State {
        Matrix4d secMat;
        Point3d origin;
        Point3d dir;

        AdvancedState(State state) {
            this.matrix = new Matrix4d(state.matrix);
            this.oU = state.oU;
            this.oV = state.oV;
            this.sU = state.sU;
            this.sV = state.sV;
            this.sColor = (double[])state.sColor.clone();
            this.texOfs = state.texOfs;
        }

        @Override
        State copy() {
            AdvancedState state = new AdvancedState(this);
            state.secMat = new Matrix4d(this.secMat);
            state.origin = new Point3d(this.origin);
            state.dir = new Point3d(this.dir);
            return super.copy();
        }

        @Override
        void mulMat(Matrix4d mat) {
            this.matrix.mul(mat);
            this.secMat.mul(mat);
        }

        @Override
        Quad transform(Quad quadi) {
            Quad nQuad = new Quad();
            nQuad.tex = quadi.tex + this.texOfs;
            int i = 0;
            for (double[] vertex : quadi.vertices) {
                double[] vert2 = nQuad.vertices[i++];
                Point3d vec = new Point3d(vertex);
                Point3d vec1 = new Point3d(vec);
                this.matrix.transform(vec);
                this.secMat.transform(vec1);
                double d = (vec.x - this.origin.x) * this.dir.x + (vec.y - this.origin.y) * this.dir.y + (vec.z - this.origin.z) * this.dir.z;
                vert2[0] = vec.x + vec1.x * d;
                vert2[1] = vec.y + vec1.y * d;
                vert2[2] = vec.z + vec1.z * d;
                vert2[3] = vertex[3] * this.sU + this.oU;
                vert2[4] = vertex[4] * this.sV + this.oV;
                int k = 0;
                int j = 5;
                while (k < 4) {
                    vert2[j] = vertex[j] * this.sColor[k];
                    ++k;
                    ++j;
                }
            }
            return nQuad;
        }
    }

    private static class State {
        Matrix4d matrix;
        double oU;
        double oV;
        double sU;
        double sV;
        double[] sColor;
        int texOfs;

        private State() {
        }

        State copy() {
            State state = new State();
            state.matrix = new Matrix4d(this.matrix);
            state.oU = this.oU;
            state.oV = this.oV;
            state.sU = this.sU;
            state.sV = this.sV;
            state.sColor = (double[])this.sColor.clone();
            state.texOfs = this.texOfs;
            return state;
        }

        void mulMat(Matrix4d mat) {
            this.matrix.mul(mat);
        }

        Quad transform(Quad quadi) {
            Quad nQuad = new Quad();
            nQuad.tex = quadi.tex + this.texOfs;
            int i = 0;
            for (double[] vertex : quadi.vertices) {
                double[] vert2 = nQuad.vertices[i++];
                Point3d vec = new Point3d(vertex);
                this.matrix.transform(vec);
                vert2[0] = vec.x;
                vert2[1] = vec.y;
                vert2[2] = vec.z;
                vert2[3] = vertex[3] * this.sU + this.oU;
                vert2[4] = vertex[4] * this.sV + this.oV;
                int k = 0;
                int j = 5;
                while (k < 4) {
                    vert2[j] = vertex[j] * this.sColor[k];
                    ++k;
                    ++j;
                }
            }
            return nQuad;
        }
    }
}

