/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.render.Util;
import cd4017be.lib.render.model.ModelContext;
import cd4017be.lib.script.Module;
import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.util.Orientation;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class IntArrayModel {
    public static final VertexFormat FORMAT = DefaultVertexFormats.field_176600_a;
    private static final float EPSILON = 0.001f;
    public final int[] vertexData;
    private float ofsX = 0.0f;
    private float ofsY = 0.0f;
    private float ofsZ = 0.0f;
    private int brightness;
    private int color;

    public IntArrayModel(int[] data, int color, int brightness) {
        this.vertexData = data;
        this.color = color;
        this.brightness = brightness;
    }

    public IntArrayModel(int[] data) {
        this(data, -1, 0);
    }

    public IntArrayModel(int n) {
        this(new int[n * 28]);
    }

    public IntArrayModel(ModelContext context) {
        this(context.quads[0].size());
        int j = 0;
        for (ModelContext.Quad quad : context.quads[0]) {
            for (double[] vert : quad.vertices) {
                this.vertexData[j++] = Float.floatToRawIntBits((float)vert[0] / 16.0f);
                this.vertexData[j++] = Float.floatToRawIntBits((float)vert[1] / 16.0f);
                this.vertexData[j++] = Float.floatToRawIntBits((float)vert[2] / 16.0f);
                this.vertexData[j++] = (int)MathHelper.func_151237_a((double)(vert[5] * 255.0), (double)0.0, (double)255.0) | (int)MathHelper.func_151237_a((double)(vert[6] * 255.0), (double)0.0, (double)255.0) << 8 | (int)MathHelper.func_151237_a((double)(vert[7] * 255.0), (double)0.0, (double)255.0) << 16 | (int)MathHelper.func_151237_a((double)(vert[8] * 255.0), (double)0.0, (double)255.0) << 24;
                this.vertexData[j++] = Float.floatToRawIntBits((float)vert[3]);
                this.vertexData[j++] = Float.floatToRawIntBits((float)vert[4]);
                this.vertexData[j++] = this.brightness;
            }
        }
    }

    public static TextureAtlasSprite[] getTextures(Module script) {
        IOperand var = script.read("textures");
        if (!(var instanceof Array)) {
            return null;
        }
        Object[] names = (Object[])var.value();
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite[] textures = new TextureAtlasSprite[names.length];
        for (int i = 0; i < textures.length; ++i) {
            textures[i] = map.func_110572_b((String)names[i]);
        }
        return textures;
    }

    public IntArrayModel(ModelContext context, TextureAtlasSprite[] textures) {
        this(context.quads[0].size());
        int j = 0;
        for (ModelContext.Quad quad : context.quads[0]) {
            TextureAtlasSprite tex = textures == null ? null : textures[quad.tex];
            for (double[] vert : quad.vertices) {
                this.vertexData[j++] = Float.floatToRawIntBits((float)vert[0] / 16.0f);
                this.vertexData[j++] = Float.floatToRawIntBits((float)vert[1] / 16.0f);
                this.vertexData[j++] = Float.floatToRawIntBits((float)vert[2] / 16.0f);
                this.vertexData[j++] = (int)MathHelper.func_151237_a((double)(vert[7] * 255.0), (double)0.0, (double)255.0) | (int)MathHelper.func_151237_a((double)(vert[6] * 255.0), (double)0.0, (double)255.0) << 8 | (int)MathHelper.func_151237_a((double)(vert[5] * 255.0), (double)0.0, (double)255.0) << 16 | (int)MathHelper.func_151237_a((double)(vert[8] * 255.0), (double)0.0, (double)255.0) << 24;
                this.vertexData[j++] = Float.floatToRawIntBits(tex == null ? (float)vert[3] : tex.func_94214_a(vert[3]));
                this.vertexData[j++] = Float.floatToRawIntBits(tex == null ? (float)vert[4] : tex.func_94207_b(vert[4]));
                this.vertexData[j++] = this.brightness;
            }
        }
    }

    public IntArrayModel origin(float x, float y, float z) {
        this.ofsX = x;
        this.ofsY = y;
        this.ofsZ = z;
        return this;
    }

    public void setBrightness(int l) {
        if (l == this.brightness) {
            return;
        }
        for (int i = 6; i < this.vertexData.length; i += 7) {
            this.vertexData[i] = l;
        }
        this.brightness = l;
    }

    public void setOffset(float dx, float dy, float dz) {
        if ((dx -= this.ofsX) * dx + (dy -= this.ofsY) * dy + (dz -= this.ofsZ) * dz < 1.0000001E-6f) {
            return;
        }
        for (int i = 0; i < this.vertexData.length; i += 5) {
            this.vertexData[i] = Float.floatToIntBits(dx + Float.intBitsToFloat(this.vertexData[i]));
            this.vertexData[++i] = Float.floatToIntBits(dy + Float.intBitsToFloat(this.vertexData[i]));
            this.vertexData[++i] = Float.floatToIntBits(dz + Float.intBitsToFloat(this.vertexData[i]));
        }
        this.ofsX += dx;
        this.ofsY += dy;
        this.ofsZ += dz;
    }

    public void setOffset(float ofs, EnumFacing.Axis axis) {
        int i;
        switch (axis) {
            case X: {
                if (ofs == this.ofsX) {
                    return;
                }
                this.ofsX += (ofs -= this.ofsX);
                i = 0;
                break;
            }
            case Y: {
                if (ofs == this.ofsY) {
                    return;
                }
                this.ofsY += (ofs -= this.ofsY);
                i = 1;
                break;
            }
            case Z: {
                if (ofs == this.ofsZ) {
                    return;
                }
                this.ofsZ += (ofs -= this.ofsZ);
                i = 2;
                break;
            }
            default: {
                return;
            }
        }
        while (i < this.vertexData.length) {
            this.vertexData[i] = Float.floatToIntBits(ofs + Float.intBitsToFloat(this.vertexData[i]));
            i += 7;
        }
    }

    public void setColor(int c) {
        if (c == this.color) {
            return;
        }
        for (int i = 3; i < this.vertexData.length; i += 7) {
            this.vertexData[i] = c;
        }
        this.color = c;
    }

    public IntArrayModel withTexture(TextureAtlasSprite tex) {
        int[] data = Arrays.copyOf(this.vertexData, this.vertexData.length);
        for (int i = 4; i < data.length; i += 6) {
            data[i] = Float.floatToIntBits(tex.func_94214_a((double)Float.intBitsToFloat(data[i])));
            data[++i] = Float.floatToIntBits(tex.func_94207_b((double)Float.intBitsToFloat(data[i])));
        }
        return new IntArrayModel(data, this.color, this.brightness);
    }

    public IntArrayModel translated(float x, float y, float z) {
        x -= this.ofsX;
        y -= this.ofsY;
        z -= this.ofsZ;
        int[] data = Arrays.copyOf(this.vertexData, this.vertexData.length);
        for (int i = 0; i < data.length; i += 5) {
            data[i] = Float.floatToIntBits(x + Float.intBitsToFloat(data[i]));
            data[++i] = Float.floatToIntBits(y + Float.intBitsToFloat(data[i]));
            data[++i] = Float.floatToIntBits(z + Float.intBitsToFloat(data[i]));
        }
        return new IntArrayModel(data, this.color, this.brightness);
    }

    public IntArrayModel rotated(Orientation o) {
        ModelRotation r = o.getModelRotation();
        int[] data = Arrays.copyOf(this.vertexData, this.vertexData.length);
        for (int i = 0; i < data.length; i += 7) {
            Util.rotate(data, i, r);
        }
        return new IntArrayModel(data, this.color, this.brightness);
    }
}

