/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.property;

import cd4017be.lib.util.Orientation;
import java.util.Arrays;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.EnumFacing;

public abstract class PropertyOrientation
extends PropertyEnum<Orientation> {
    public static final PropertyOrientation XY_12_ROT = new PropertyOrientation("orient", new Orientation[]{Orientation.Bn, Orientation.Bs, Orientation.Bw, Orientation.Be, Orientation.Tn, Orientation.Ts, Orientation.Tw, Orientation.Te, Orientation.N, Orientation.S, Orientation.W, Orientation.E}){

        @Override
        public Orientation getPlacementState(boolean sneak, int y, int p, EnumFacing f, float X, float Y, float Z) {
            if (sneak) {
                if (f == EnumFacing.DOWN) {
                    return Z + X > 1.0f ? (Z > X ? Orientation.Bs : Orientation.Be) : (Z < X ? Orientation.Bn : Orientation.Bw);
                }
                if (f == EnumFacing.UP) {
                    return Z + X > 1.0f ? (Z > X ? Orientation.Ts : Orientation.Te) : (Z < X ? Orientation.Tn : Orientation.Tw);
                }
                return Orientation.fromFacing(f.func_176734_d());
            }
            return Orientation.values()[y | (p == 0 ? 0 : (p < 0 ? 4 : 12))];
        }

        @Override
        public EnumFacing[] rotations() {
            return EnumFacing.field_82609_l;
        }

        @Override
        public Orientation getRotatedState(Orientation state, EnumFacing side) {
            int o = state.ordinal();
            int ofs = side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 1 : 3;
            switch (side.func_176740_k()) {
                case Y: {
                    return Orientation.values()[o + ofs & 3 | o & 0xC];
                }
                case X: {
                    if ((o & 0xC) != 0) {
                        return (o >> 2 & 3) == ofs ? Orientation.S : Orientation.N;
                    }
                    if ((o & 1) != 0) {
                        return state;
                    }
                    return Orientation.values()[o & 3 | ((o & 3) == ofs - 1 ? 4 : 12)];
                }
                case Z: {
                    if ((o & 0xC) != 0) {
                        return (o >> 2 & 3) == ofs ? Orientation.E : Orientation.W;
                    }
                    if ((o & 1) == 0) {
                        return state;
                    }
                    return Orientation.values()[o & 3 | ((o & 3) == ofs ? 4 : 12)];
                }
            }
            return state;
        }
    };
    public static final PropertyOrientation ALL_AXIS = new PropertyOrientation("orient", new Orientation[]{Orientation.Bn, Orientation.Tn, Orientation.N, Orientation.S, Orientation.W, Orientation.E}){

        @Override
        public Orientation getPlacementState(boolean sneak, int y, int p, EnumFacing f, float X, float Y, float Z) {
            if (sneak) {
                return Orientation.fromFacing(f.func_176734_d());
            }
            if (p == 0) {
                return Orientation.values()[y];
            }
            return p < 0 ? Orientation.Bn : Orientation.Tn;
        }

        @Override
        public EnumFacing[] rotations() {
            return EnumFacing.field_82609_l;
        }

        @Override
        public Orientation getRotatedState(Orientation state, EnumFacing side) {
            switch (state.front.ordinal() & 6 | (side.ordinal() & 6) << 4 | (state.front.ordinal() ^ side.ordinal()) & 1) {
                case 5: 
                case 64: {
                    return Orientation.S;
                }
                case 4: 
                case 65: {
                    return Orientation.N;
                }
                case 37: 
                case 66: {
                    return Orientation.Bn;
                }
                case 36: 
                case 67: {
                    return Orientation.Tn;
                }
                case 3: 
                case 32: {
                    return Orientation.W;
                }
                case 2: 
                case 33: {
                    return Orientation.E;
                }
            }
            return state;
        }
    };
    public static final PropertyOrientation HOR_AXIS = new PropertyOrientation("orient", new Orientation[]{Orientation.N, Orientation.S, Orientation.W, Orientation.E}){

        @Override
        public Orientation getPlacementState(boolean sneak, int y, int p, EnumFacing f, float X, float Y, float Z) {
            if (sneak) {
                if (f == EnumFacing.DOWN || f == EnumFacing.UP) {
                    return Z + X > 1.0f ? (Z > X ? Orientation.S : Orientation.E) : (Z < X ? Orientation.N : Orientation.W);
                }
                return Orientation.fromFacing(f.func_176734_d());
            }
            return Orientation.values()[y];
        }

        @Override
        public EnumFacing[] rotations() {
            return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
        }

        @Override
        public Orientation getRotatedState(Orientation state, EnumFacing side) {
            int ofs = side == EnumFacing.DOWN ? 1 : (side == EnumFacing.UP ? 3 : 0);
            return Orientation.values()[state.ordinal() + ofs & 3];
        }
    };

    protected PropertyOrientation(String name, Orientation ... allowedValues) {
        super(name, Orientation.class, Arrays.asList(allowedValues));
    }

    public abstract Orientation getPlacementState(boolean var1, int var2, int var3, EnumFacing var4, float var5, float var6, float var7);

    public abstract EnumFacing[] rotations();

    public abstract Orientation getRotatedState(Orientation var1, EnumFacing var2);
}

