/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.api.Capabilities;
import cd4017be.api.computers.ComputerAPI;
import cd4017be.api.energy.EnergyAPI;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.item.ItemMaterial;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.SyncNetworkHandler;
import cd4017be.lib.render.ItemMaterialMeshDefinition;
import cd4017be.lib.render.SpecialModelLoader;
import cd4017be.lib.script.Module;
import cd4017be.lib.templates.TabMaterials;
import cd4017be.lib.util.FileUtil;
import cd4017be.lib.util.TooltipEditor;
import cd4017be.lib.util.TooltipUtil;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="cd4017be_lib", useMetadata=true, acceptedMinecraftVersions="[1.12.2]")
public class Lib {
    public static final String ID = "cd4017be_lib";
    public static final String ConfigName = "core";
    @Mod.Instance
    public static Lib instance;
    public static Logger LOG;
    public static ItemMaterial materials;
    public static BaseItem rrwi;
    public static final TabMaterials creativeTab;

    public Lib() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOG = event.getModLog();
        FileUtil.initConfigDir(event);
        BlockGuiHandler.register();
        Capabilities.register();
        rrwi = new BaseItem("rrwi");
        materials = new ItemMaterial("m");
        materials.func_77637_a(creativeTab);
        Lib.creativeTab.item = new ItemStack((Item)materials);
        RecipeScriptContext.instance = new RecipeScriptContext(LOG);
        RecipeScriptContext.instance.setup();
        RecipeScriptContext.instance.run("core.PRE_INIT");
        RecipeScriptContext.ConfigConstants cfg = new RecipeScriptContext.ConfigConstants((Module)RecipeScriptContext.instance.modules.get(ConfigName));
        GuiNetworkHandler.register();
        SyncNetworkHandler.register(cfg);
        EnergyAPI.init(cfg);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ComputerAPI.register();
        RecipeScriptContext.instance.runAll("INIT");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeScriptContext.instance.runAll("POST_INIT");
        TooltipUtil.addScriptVariables();
        if (event.getSide().isClient()) {
            TooltipEditor.init();
        }
    }

    @Mod.EventHandler
    public void afterStart(FMLServerAboutToStartEvent event) {
        RecipeScriptContext.instance = null;
        System.gc();
    }

    @Mod.EventHandler
    public void onShutdown(FMLServerStoppingEvent event) {
        TickRegistry.instance.clear();
        if (TooltipUtil.editor != null) {
            TooltipUtil.editor.save();
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> ev) {
        ev.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{rrwi, materials});
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerMaterialModels(ModelRegistryEvent ev) {
        SpecialModelLoader.setMod(ID);
        BlockItemRegistry.registerRender(rrwi);
        BlockItemRegistry.registerRender(materials);
        BlockItemRegistry.registerRender(materials, (ItemMeshDefinition)new ItemMaterialMeshDefinition(materials));
    }

    static {
        creativeTab = new TabMaterials(ID);
    }
}

