/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.wire;

import cd4017be.api.rs_ctr.port.IConnector;
import cd4017be.api.rs_ctr.port.IIntegratedConnector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.api.rs_ctr.wire.IWiredConnector;
import cd4017be.api.rs_ctr.wire.RelayPort;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;

public class WireLine
implements Collection<MountedPort> {
    public final Port source;
    public final Port sink;
    public final RelayPort[] hooks;

    public WireLine(MountedPort port) throws WireLoopException {
        MountedPort p1;
        ArrayDeque<RelayPort> list = new ArrayDeque<RelayPort>();
        Port p0 = WireLine.scan(port, list);
        Port port2 = p1 = port instanceof RelayPort ? WireLine.scan(((RelayPort)port).opposite, list) : port;
        if (port.isMaster) {
            this.source = p1;
            this.sink = p0;
        } else {
            this.source = p0;
            this.sink = p1;
        }
        this.hooks = list.toArray(new RelayPort[list.size()]);
    }

    private static Port getLink(MountedPort port) {
        IConnector c = port.getConnector();
        if (!(c instanceof IWiredConnector)) {
            return null;
        }
        IWiredConnector con = (IWiredConnector)c;
        Port lp = con.getLinkPort(port);
        if (!lp.isMaster ^ port.isMaster) {
            return null;
        }
        if (lp instanceof MountedPort) {
            c = ((MountedPort)lp).getConnector();
            if (c instanceof IIntegratedConnector) {
                return ((IIntegratedConnector)c).getLinkedWith(port);
            }
            if (!(c instanceof IWiredConnector) || !((IWiredConnector)c).isLinked(port)) {
                return null;
            }
        }
        return lp;
    }

    private static Port scan(MountedPort mport, ArrayDeque<RelayPort> list) throws WireLoopException {
        Port port;
        boolean dir = mport.isMaster;
        if (mport instanceof RelayPort && mport.getConnector() != null) {
            if (dir) {
                list.addLast((RelayPort)mport);
            } else {
                list.addFirst((RelayPort)mport);
            }
        }
        while ((port = WireLine.getLink(mport)) instanceof RelayPort) {
            RelayPort sr = (RelayPort)port;
            if (list.contains(sr)) {
                throw new WireLoopException();
            }
            if (dir) {
                list.addLast(sr);
            } else {
                list.addFirst(sr);
            }
            sr = sr.opposite;
            mport = sr;
            if (sr.getConnector() == null) {
                return null;
            }
            if (dir) {
                list.addLast(sr);
                continue;
            }
            list.addFirst(sr);
        }
        return port;
    }

    public boolean checkTypes() {
        Class<?> type = null;
        if (this.source != null) {
            type = this.source.type;
        }
        if (this.sink != null) {
            if (type == null) {
                type = this.sink.type;
            } else if (this.sink.type != type) {
                return false;
            }
        }
        if (type == null) {
            return true;
        }
        for (RelayPort port : this.hooks) {
            if (((IWiredConnector)port.getConnector()).isCompatible(type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        int n = this.hooks.length;
        if (this.source != null) {
            ++n;
        }
        if (this.sink != null) {
            ++n;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.source == null && this.sink == null && this.hooks.length == 0;
    }

    @Override
    public boolean contains(Object port) {
        if (port instanceof RelayPort) {
            for (RelayPort sr : this.hooks) {
                if (sr != port) continue;
                return true;
            }
            return false;
        }
        return port == this.source || port == this.sink;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<MountedPort> iterator() {
        return new Iterator<MountedPort>(){
            int i;
            int n;
            {
                this.i = WireLine.this.source instanceof MountedPort ? -1 : 0;
                this.n = WireLine.this.hooks.length + (WireLine.this.sink instanceof MountedPort ? 1 : 0);
            }

            @Override
            public boolean hasNext() {
                return this.i < this.n;
            }

            @Override
            public MountedPort next() {
                int j;
                return (j = this.i++) < 0 ? (MountedPort)WireLine.this.source : (j < WireLine.this.hooks.length ? WireLine.this.hooks[j] : (MountedPort)WireLine.this.sink);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super MountedPort> action) {
        if (this.source instanceof MountedPort) {
            action.accept((MountedPort)this.source);
        }
        for (RelayPort port : this.hooks) {
            action.accept(port);
        }
        if (this.sink instanceof MountedPort) {
            action.accept((MountedPort)this.sink);
        }
    }

    public MountedPort[] toArray() {
        return this.toArray(new MountedPort[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int n = this.size();
        if (a.length < n) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), n);
        }
        int i = 0;
        if (this.source != null) {
            a[i++] = this.source;
        }
        System.arraycopy(this.hooks, 0, a, i, this.hooks.length);
        if (this.source != null) {
            a[n - 1] = this.source;
        }
        return null;
    }

    @Override
    public boolean add(MountedPort e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends MountedPort> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static class WireLoopException
    extends Exception {
    }
}

