/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.wire;

import cd4017be.api.rs_ctr.port.IConnector;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.ITagableConnector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.api.rs_ctr.wire.IHookAttachable;
import cd4017be.api.rs_ctr.wire.IWiredConnector;
import cd4017be.api.rs_ctr.wire.WireLine;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RelayPort
extends MountedPort {
    public static final float SIZE = 0.03125f;
    public static BiFunction<IHookAttachable, Integer, RelayPort> IMPLEMENTATION;
    public final RelayPort opposite;

    protected RelayPort(IPortProvider owner, int pin) {
        super(owner, pin & 0xFFF | 0x8000, null, true);
        this.opposite = this.createPair();
    }

    protected RelayPort(RelayPort opposite) {
        super(opposite.owner, opposite.pin ^ 0x1000, null, !opposite.isMaster);
        this.opposite = opposite;
    }

    protected abstract RelayPort createPair();

    @Override
    public Pair<Vec3d, EnumFacing> rayTrace(Vec3d start, Vec3d dir) {
        RayTraceResult rt = new AxisAlignedBB(this.pos.field_72450_a - 0.03125, this.pos.field_72448_b - 0.03125, this.pos.field_72449_c - 0.03125, this.pos.field_72450_a + 0.03125, this.pos.field_72448_b + 0.03125, this.pos.field_72449_c + 0.03125).func_72327_a(start, start.func_178787_e(dir));
        return rt == null ? null : Pair.of((Object)rt.field_72307_f.func_178788_d(start), (Object)rt.field_178784_b);
    }

    @Override
    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        String s = this.connector != null ? this.connector.displayInfo(this, this.linkID) : (this.opposite.connector != null ? this.opposite.connector.displayInfo(this.opposite, this.linkID) : TooltipUtil.translate(this.name));
        if (!s.isEmpty() && s.charAt(0) == '\n') {
            s = s.substring(1);
        }
        return Pair.of((Object)this.pos, (Object)s);
    }

    public abstract void orient(Orientation var1);

    @Override
    public <T> void addRenderComps(List<T> list, Class<T> type) {
        super.addRenderComps(list, type);
        if (type.isInstance(this.opposite.connector)) {
            list.add(type.cast(this.opposite.connector));
            this.opposite.connector.setPort(this.opposite);
        }
    }

    @Override
    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        ItemStack stack = player.func_184614_ca();
        if (hit || player.func_70093_af() && stack.func_190926_b()) {
            if (this.connector != null) {
                this.setConnector(null, player);
            } else if (this.opposite.connector != null) {
                this.opposite.setConnector(null, player);
            } else {
                ((IHookAttachable)this.owner).removeHook(this.pin, player);
            }
            return true;
        }
        if (stack.func_77973_b() instanceof IWiredConnector.IWiredConnectorItem) {
            ((IWiredConnector.IWiredConnectorItem)stack.func_77973_b()).doAttach(stack, this.connector != null && this.opposite.connector == null ? this.opposite : this, player);
            return true;
        }
        return false;
    }

    @Override
    public void connect(Port to) {
        MountedPort p;
        IConnector con;
        WireLine line;
        try {
            line = new WireLine(this);
        }
        catch (WireLine.WireLoopException e) {
            return;
        }
        if (line.source == null || line.sink == null || !line.contains(to) || !line.checkTypes()) {
            return;
        }
        String label = null;
        Iterator<MountedPort> iterator = line.iterator();
        while (iterator.hasNext() && (label = (con = (p = iterator.next()).getConnector()) instanceof ITagableConnector ? ((ITagableConnector)con).getTag() : null) == null) {
        }
        String label_ = label;
        line.forEach((Consumer<? super MountedPort>)((Consumer<MountedPort>)c -> {
            IConnector cn = c.getConnector();
            if (cn instanceof ITagableConnector) {
                ((ITagableConnector)cn).setTag((MountedPort)c, label_);
            }
        }));
        line.source.connect(line.sink);
        int id = line.source.getLink();
        for (RelayPort rp : line.hooks) {
            rp.linkID = id;
            rp.owner.onPortModified(rp, 1);
        }
    }

    @Override
    public void disconnect() {
        WireLine line;
        try {
            line = new WireLine(this);
        }
        catch (WireLine.WireLoopException e) {
            return;
        }
        if (line.source != null) {
            line.source.disconnect();
        } else if (line.sink != null) {
            line.sink.disconnect();
        }
        for (RelayPort rp : line.hooks) {
            rp.linkID = 0;
            rp.owner.onPortModified(rp, 2);
        }
    }

    @Override
    public void onLoad() {
        if (this.connector != null) {
            this.connector.onLoad(this);
        }
        if (this.opposite.connector != null) {
            this.opposite.connector.onLoad(this);
        }
    }

    @Override
    public void onUnload() {
        if (this.connector != null) {
            this.connector.onUnload();
        }
        if (this.opposite.connector != null) {
            this.opposite.connector.onUnload();
        }
    }

    public abstract ItemStack getDropped();
}

