/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.port;

import cd4017be.api.rs_ctr.port.Port;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Link {
    public static final Logger LOG = LogManager.getLogger((String)"rs_ctr API");
    static Int2ObjectMap<Link> links = new Int2ObjectOpenHashMap();
    private static int nextLinkID = 1;
    private static int lastFreeID = 0;
    private static File file;
    public final int id;
    Port source;
    Port sink;

    private static int newLinkID() {
        if (lastFreeID != 0) {
            int i = lastFreeID;
            lastFreeID = 0;
            return i;
        }
        return nextLinkID++;
    }

    private static void freeID(int id) {
        if (id == 0) {
            return;
        }
        if (id == nextLinkID - 1) {
            if (id > 1 && lastFreeID == id - 1) {
                nextLinkID = lastFreeID;
                lastFreeID = 0;
            } else {
                nextLinkID = id;
            }
        } else if (((long)id & 0xFFFFFFFFL) > ((long)lastFreeID & 0xFFFFFFFFL)) {
            lastFreeID = id;
        }
    }

    public static void saveData() {
        links.clear();
        if (file == null) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("nextID", nextLinkID);
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)file);
            LOG.info("Signal Link IDs sucessfully saved");
        }
        catch (IOException e) {
            LOG.error("failed to save Signal Link IDs: ", (Throwable)e);
        }
    }

    public static void loadData(File savedir) {
        nextLinkID = 1;
        lastFreeID = 0;
        file = new File(savedir, "data/signalLinkIDs.dat");
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74797_a((File)file);
            if (nbt == null) {
                LOG.info("Signal Link ID file not found: this must be a newly created world.");
                return;
            }
            int i = nbt.func_74762_e("nextID");
            if (i != 0) {
                nextLinkID = i;
            }
            LOG.info("Signal Link IDs sucessfully loaded");
        }
        catch (IOException e) {
            LOG.error("failed to load Signal Link IDs: ", (Throwable)e);
        }
    }

    public Link(Port port) {
        this.id = port.linkID;
        if (port.isMaster) {
            this.source = port;
        } else {
            this.sink = port;
        }
        if (this.id >= nextLinkID) {
            nextLinkID = this.id + 1;
            LOG.warn("It appears the used up Signal Link IDs info wasn't properly saved to disk. IDs may have been assigned duplicate!");
        }
    }

    public Link(Port source, Port sink) {
        if (!source.isMaster || sink.isMaster) {
            throw new IllegalArgumentException("invalid port directions!");
        }
        this.source = source;
        this.sink = sink;
        source.linkID = sink.linkID = Link.newLinkID();
        this.id = sink.linkID;
        links.put(sink.linkID, (Object)this);
        source.owner.setPortCallback(source.pin, sink.owner.getPortCallback(sink.pin));
        source.owner.onPortModified(source, 1);
        sink.owner.onPortModified(sink, 1);
    }

    public void load(Port port) {
        boolean link;
        if (port.isMaster) {
            link = this.source == null && this.sink != null;
            this.source = port;
        } else {
            link = this.sink == null && this.source != null;
            this.sink = port;
        }
        if (link) {
            this.source.owner.setPortCallback(this.source.pin, this.sink.owner.getPortCallback(this.sink.pin));
        } else {
            LOG.warn("duplicate {} port loaded on ID {}", (Object)(port.isMaster ? "master" : "slave"), (Object)this.id);
        }
    }

    public void unload(Port port) {
        if (this.source != null) {
            this.source.owner.setPortCallback(this.source.pin, null);
        }
        if (port.isMaster) {
            this.source = null;
        } else {
            this.sink = null;
        }
        if (this.source == null && this.sink == null) {
            links.remove(this.id);
        }
    }

    public void disconnect() {
        if (this.source != null) {
            this.source.linkID = 0;
            this.source.owner.setPortCallback(this.source.pin, null);
            this.source.owner.onPortModified(this.source, 2);
        }
        if (this.sink != null) {
            this.sink.linkID = 0;
            this.sink.owner.onPortModified(this.sink, 2);
        }
        links.remove(this.id);
        Link.freeID(this.id);
    }
}

