/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.EnergyAPI;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class EnergyIndustrialCraft
implements EnergyAPI.IEnergyHandler {
    @Override
    public EnergyAPI.IEnergyAccess create(TileEntity te, EnumFacing s) {
        return te instanceof IEnergyStorage ? new EnergyTile((IEnergyStorage)te) : null;
    }

    @Override
    public EnergyAPI.IEnergyAccess create(ItemStack item, int s) {
        return item.func_77973_b() instanceof IElectricItem ? new EnergyItem(item, s < 0) : null;
    }

    class EnergyItem
    implements EnergyAPI.IEnergyAccess {
        final ItemStack item;
        final boolean intern;

        EnergyItem(ItemStack item, boolean intern) {
            this.item = item;
            this.intern = intern;
        }

        @Override
        public float getStorage() {
            return (float)ElectricItem.manager.getCharge(this.item) * EnergyAPI.EU_value;
        }

        @Override
        public float getCapacity() {
            return this.item.func_77973_b() instanceof IElectricItem ? (float)((IElectricItem)this.item.func_77973_b()).getMaxCharge(this.item) * EnergyAPI.EU_value : 0.0f;
        }

        @Override
        public float addEnergy(float e) {
            if (e > 0.0f) {
                return (float)ElectricItem.manager.charge(this.item, (double)(e / EnergyAPI.EU_value), Integer.MAX_VALUE, this.intern, false) * EnergyAPI.EU_value;
            }
            if (e < 0.0f) {
                return (float)ElectricItem.manager.discharge(this.item, (double)(e / -EnergyAPI.EU_value), Integer.MAX_VALUE, this.intern, !this.intern, false) * -EnergyAPI.EU_value;
            }
            return 0.0f;
        }
    }

    static class EnergyTile
    implements EnergyAPI.IEnergyAccess {
        final IEnergyStorage t;

        EnergyTile(IEnergyStorage s) {
            this.t = s;
        }

        @Override
        public float getStorage() {
            return (float)this.t.getStored() * EnergyAPI.EU_value;
        }

        @Override
        public float getCapacity() {
            return (float)this.t.getCapacity() * EnergyAPI.EU_value;
        }

        @Override
        public float addEnergy(float e) {
            int s = this.t.getStored();
            int c = this.t.getCapacity();
            if (e >= EnergyAPI.EU_value && s < c) {
                int a = (int)Math.floor(e / EnergyAPI.EU_value);
                if (s + a > c) {
                    e = (float)(c - s) * EnergyAPI.EU_value;
                    this.t.setStored(c);
                } else {
                    this.t.setStored(s + a);
                }
            } else if (e <= -EnergyAPI.EU_value && s > 0) {
                int a = (int)Math.floor(e / -EnergyAPI.EU_value);
                if (a > s) {
                    e = (float)s * -EnergyAPI.EU_value;
                    this.t.setStored(0);
                } else {
                    this.t.setStored(s - a);
                }
            } else {
                e = 0.0f;
            }
            return e;
        }
    }
}

