/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.network.server;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.rending.Rending;
import com.shinoow.abyssalcraft.api.rending.RendingRegistry;
import com.shinoow.abyssalcraft.common.network.AbstractMessage;
import com.shinoow.abyssalcraft.lib.util.items.IStaffOfRending;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class StaffOfRendingMessage
extends AbstractMessage.AbstractServerMessage<StaffOfRendingMessage> {
    int id;
    EnumHand hand;

    public StaffOfRendingMessage() {
    }

    public StaffOfRendingMessage(int id, EnumHand hand) {
        this.id = id;
        this.hand = hand;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.id = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5);
        this.hand = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5) == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.id, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)(this.hand == EnumHand.MAIN_HAND ? 0 : 1), (int)5);
    }

    private boolean drain(EntityPlayer player, Entity entity, ItemStack stack) {
        boolean success;
        block3: {
            int drainAmount;
            IStaffOfRending staff;
            block2: {
                staff = (IStaffOfRending)stack.func_77973_b();
                drainAmount = staff.getDrainAmount(stack);
                success = false;
                if (!(entity instanceof EntityLiving)) break block2;
                EntityLiving target = (EntityLiving)entity;
                for (Rending r2 : RendingRegistry.instance().getRendings().stream().filter(r -> r.isApplicable(target)).collect(Collectors.toList())) {
                    if (target.field_70128_L || !success && !target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)drainAmount)) continue;
                    staff.increaseEnergy(stack, r2.getName());
                    success = true;
                }
                break block3;
            }
            if (!(entity instanceof MultiPartEntityPart)) break block3;
            MultiPartEntityPart target = (MultiPartEntityPart)entity;
            EntityLiving parent = (EntityLiving)target.field_70259_a;
            for (Rending r3 : RendingRegistry.instance().getRendings().stream().filter(r -> r.isApplicable(parent)).collect(Collectors.toList())) {
                if (target.field_70128_L || !success && !target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)drainAmount)) continue;
                staff.increaseEnergy(stack, r3.getName());
                success = true;
            }
        }
        return success;
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (player.func_184586_b(this.hand).func_190926_b()) {
            return;
        }
        ItemStack stack = player.func_184586_b(this.hand);
        Entity entity = player.field_70170_p.func_73045_a(this.id);
        if (entity == null) {
            return;
        }
        if (stack.func_77973_b() instanceof IStaffOfRending) {
            if (entity instanceof EntityLiving) {
                if (this.drain(player, entity, stack) && EnchantmentHelper.func_77506_a((Enchantment)AbyssalCraftAPI.multi_rend, (ItemStack)stack) == 1) {
                    player.field_70170_p.func_72839_b(entity, entity.func_174813_aQ().func_186662_g(3.0)).stream().forEach(e -> this.drain(player, (Entity)e, stack));
                }
            } else if (entity instanceof MultiPartEntityPart && ((MultiPartEntityPart)entity).field_70259_a instanceof EntityLiving && this.drain(player, entity, stack) && EnchantmentHelper.func_77506_a((Enchantment)AbyssalCraftAPI.multi_rend, (ItemStack)stack) == 1) {
                player.field_70170_p.func_72839_b(entity, entity.func_174813_aQ().func_186662_g(3.0)).stream().forEach(e -> this.drain(player, (Entity)e, stack));
            }
        }
    }
}

