/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.inventory;

import com.shinoow.abyssalcraft.api.recipe.MaterializerRecipes;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityMaterializer;
import com.shinoow.abyssalcraft.common.network.PacketDispatcher;
import com.shinoow.abyssalcraft.common.network.server.TransferStackMessage;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class InventoryMaterializer
implements IInventory {
    private String inventoryTitle;
    private final int slotsCount;
    private final NonNullList<ItemStack> inventoryContents;
    private boolean hasCustomName;
    private final TileEntityMaterializer tile;

    public InventoryMaterializer(String title, boolean customName, int slotCount, TileEntityMaterializer tile) {
        this.inventoryTitle = title;
        this.hasCustomName = customName;
        this.slotsCount = slotCount;
        this.inventoryContents = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
        this.tile = tile;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.inventoryContents.size() ? (ItemStack)this.inventoryContents.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ((ItemStack)this.inventoryContents.get(index)).func_77946_l();
        if (!itemstack.func_190926_b()) {
            itemstack.func_190920_e(count);
            this.func_70296_d();
            if (this.tile.func_145831_w().field_72995_K) {
                PacketDispatcher.sendToServer(new TransferStackMessage(index, itemstack));
            }
            MaterializerRecipes.instance().processMaterialization(itemstack, this.tile.func_70301_a(0));
            this.tile.isDirty = true;
        }
        return itemstack;
    }

    public ItemStack addItem(ItemStack stack) {
        ItemStack itemstack = stack.func_77946_l();
        for (int i = 0; i < this.slotsCount; ++i) {
            ItemStack itemstack1 = this.func_70301_a(i);
            if (itemstack1.func_190926_b()) {
                this.func_70299_a(i, itemstack);
                this.func_70296_d();
                return ItemStack.field_190927_a;
            }
            if (!ItemStack.func_179545_c((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            int j = Math.min(this.func_70297_j_(), itemstack1.func_77976_d());
            int k = Math.min(itemstack.func_190916_E(), j - itemstack1.func_190916_E());
            if (k <= 0) continue;
            itemstack1.func_190917_f(k);
            itemstack.func_190918_g(k);
            if (!itemstack.func_190926_b()) continue;
            this.func_70296_d();
            return ItemStack.field_190927_a;
        }
        if (itemstack.func_190916_E() != stack.func_190916_E()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.inventoryContents.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return this.slotsCount;
    }

    public String func_70005_c_() {
        return this.inventoryTitle;
    }

    public boolean func_145818_k_() {
        return this.hasCustomName;
    }

    public void setCustomName(String inventoryTitleIn) {
        this.hasCustomName = true;
        this.inventoryTitle = inventoryTitleIn;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventoryContents.clear();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventoryContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

