/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks;

import com.shinoow.abyssalcraft.lib.ACTabs;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class IngotBlock
extends Block {
    public static final PropertyEnum<EnumIngotType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumIngotType.class);

    public IngotBlock() {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumIngotType.ABYSSALNITE)));
        this.func_149711_c(4.0f);
        this.func_149752_b(12.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(ACTabs.tabBlock);
        this.setHarvestLevel("pickaxe", 2);
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beaconpos) {
        return true;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityDragon || entity instanceof EntityWither || entity instanceof EntityWitherSkull) {
            return state.func_177229_b(TYPE) != EnumIngotType.ETHAXIUM;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess p_180659_2_, BlockPos p_180659_3_) {
        return ((EnumIngotType)((Object)state.func_177229_b(TYPE))).getMapColor();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return world.func_180495_p(pos).func_177229_b(TYPE) == EnumIngotType.ETHAXIUM ? Float.MAX_VALUE : super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public int getHarvestLevel(IBlockState state) {
        return ((EnumIngotType)((Object)state.func_177229_b(TYPE))).getHarvestLevel();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumIngotType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumIngotType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumIngotType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        for (int i = 0; i < EnumIngotType.values().length; ++i) {
            par3List.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{TYPE}).build();
    }

    public static enum EnumIngotType implements IStringSerializable
    {
        ABYSSALNITE(0, "abyssalnite", "abyblock", 2, MapColor.field_151678_z, TextFormatting.DARK_AQUA),
        REFINED_CORALIUM(1, "refinedcoralium", "corblock", 5, MapColor.field_151679_y, TextFormatting.AQUA),
        DREADIUM(2, "dreadium", "dreadiumblock", 6, MapColor.field_151645_D, TextFormatting.DARK_RED),
        ETHAXIUM(3, "ethaxium", "ethaxiumblock", 8, MapColor.field_151659_e, TextFormatting.AQUA);

        private static final EnumIngotType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String state;
        private final int harvest;
        private final MapColor mapColor;
        private final TextFormatting format;

        private EnumIngotType(int meta, String name, String state, int harvest, MapColor mapColor, TextFormatting format) {
            this.meta = meta;
            this.name = name;
            this.state = state;
            this.harvest = harvest;
            this.mapColor = mapColor;
            this.format = format;
        }

        public int getMeta() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public int getHarvestLevel() {
            return this.harvest;
        }

        public String toString() {
            return this.name;
        }

        public String getState() {
            return this.state;
        }

        public TextFormatting getFormat() {
            return this.format;
        }

        public static EnumIngotType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumIngotType[EnumIngotType.values().length];
            EnumIngotType[] enumIngotTypeArray = EnumIngotType.values();
            int n = enumIngotTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumIngotType enumtype;
                EnumIngotType.META_LOOKUP[enumtype.getMeta()] = enumtype = enumIngotTypeArray[i];
            }
        }
    }
}

